/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSReplaceImplementsExtendsKeyword
extends FixAndIntentionAction {
    public JSReplaceImplementsExtendsKeyword(@NotNull JSReferenceList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/ecmascript6/JSReplaceImplementsExtendsKeyword", "<init>"));
        }
        this.registerElementRefForFix((PsiElement)list, null);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"replace.implements.keyword.fix.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/JSReplaceImplementsExtendsKeyword", "getName"));
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        if (psiElement == null) {
            return;
        }
        String text = psiElement.getText();
        if (text == null) {
            return;
        }
        ASTNode type = psiElement.getNode().findChildByType(JSTokenTypes.IMPLEMENTS_KEYWORD);
        if (type == null) {
            return;
        }
        String extendsList = text.substring(type.getPsi().getStartOffsetInParent() + type.getTextLength());
        ASTNode node = JSChangeUtil.createStatementFromText(project, "interface A extends " + extendsList + " {}", JavaScriptSupportLoader.TYPESCRIPT);
        if (node == null) {
            return;
        }
        JSReferenceList list = ((TypeScriptInterface)node.getPsi()).getExtendsList();
        if (list == null) {
            return;
        }
        psiElement.replace((PsiElement)list);
    }
}

