/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandlerContext;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportHandler
extends JSImportHandler {
    private static final TypeScriptImportHandler INSTANCE = new TypeScriptImportHandler();

    protected TypeScriptImportHandler() {
    }

    public static boolean processES6DeclarationsInScope(@NotNull JSElement scope, final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, final boolean includeExportSpecifiers) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "processES6DeclarationsInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "processES6DeclarationsInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "processES6DeclarationsInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "processES6DeclarationsInScope"));
        }
        JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler$1", "execute"));
                }
                if (!includeExportSpecifiers && element instanceof ES6ExportSpecifier) {
                    return true;
                }
                return processor.execute(element, state);
            }
        };
        if (!JSResolveUtil.processDeclarationsInScope(scope, delegatingProcessor, state, lastParent, place)) {
            return false;
        }
        return ES6PsiUtil.processExportAllDeclarations(scope, place, processor, null);
    }

    public static TypeScriptImportHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeName"));
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        JSTypeResolveResult jSTypeResolveResult = TypeScriptImportHandler.resolveNameImpl(type, source, false, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveName"));
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private static JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, boolean typeContext, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited) {
        String qName;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        PsiElement source = TypeScriptImportHandler.getSourceElement(sourceRaw);
        if (source == null) {
            source = sourceRaw;
        }
        if (!DialectDetector.isTypeScript(source)) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(type);
        Collection<Object> elements = TypeScriptImportHandler.resolveTypeElements(qualifiedName, source, visited, typeContext);
        final PsiElement finalSource = source;
        if ((elements = ContainerUtil.filter(elements, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return TypeScriptImportHandler.checkModulesAccess(finalSource, element) && TypeScriptConfigService.Provider.isAccessible(finalSource, element);
            }
        })).isEmpty()) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
            }
            return jSTypeResolveResult;
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : "";
        if (qName == null) {
            qName = "";
        }
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(qName, elements);
        if (jSTypeResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveNameImpl"));
        }
        return jSTypeResolveResult;
    }

    private static PsiElement getSourceElement(@NotNull PsiElement sourceRaw) {
        if (sourceRaw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRaw", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getSourceElement"));
        }
        PsiElement type = PsiTreeUtil.getContextOfType((PsiElement)sourceRaw, (boolean)false, (Class[])new Class[]{JSSourceElement.class});
        if (type instanceof TypeScriptType) {
            type = TypeScriptImportHandler.getSourceElement(sourceRaw.getParent());
        }
        if (type instanceof TypeScriptModule || type instanceof JSFile || type == null) {
            return type;
        }
        PsiElement parent = type.getContext();
        if (type instanceof JSBlockStatement) {
            if (parent instanceof JSFunction) {
                return parent;
            }
            return type;
        }
        if (parent != null && TypeScriptPsiUtil.isTopLevelContainer(parent)) {
            return parent;
        }
        return type;
    }

    @Override
    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "getQualifiedNameResolvedType"));
        }
        final Ref resultValue = new Ref();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.source = context;
        visitor.visited = (Set)new THashSet();
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                if (qualifierResult instanceof JSQualifiedNamedElement) {
                    resultValue.set((Object)((JSQualifiedNamedElement)qualifierResult));
                    return true;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return resultValue.get() != null;
            }
        };
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(type);
        visitor.processQualifier(name);
        return resultValue.get() == null ? "" : ((JSQualifiedNamedElement)resultValue.get()).getQualifiedName();
    }

    @NotNull
    private static Set<? extends PsiElement> resolveTypeElements(@NotNull JSQualifiedName qualifiedName, @NotNull PsiElement source, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited, boolean typeContext) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        final THashSet result = new THashSet();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.source = source;
        visitor.typeContext = typeContext;
        visitor.visited = visited;
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                result.add((Object)qualifierResult);
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };
        visitor.processQualifier(qualifiedName);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "resolveTypeElements"));
        }
        return tHashSet;
    }

    private static boolean findReferencedElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptElementVisitor visitor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "findReferencedElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "findReferencedElements"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler", "findReferencedElements"));
        }
        boolean strictTypeContext = visitor.isStrictTypeContext();
        Collection<? extends PsiElement> localResults = TypeScriptQualifiedNameResolver.getElements(name, source, visitor);
        boolean methodAccepted = false;
        for (PsiElement psiElement : localResults) {
            if (strictTypeContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(psiElement)) continue;
            boolean accepted = false;
            if (psiElement instanceof TypeScriptImportStatement) {
                TypeScriptExternalModuleReference externalModuleReference = ((TypeScriptImportStatement)psiElement).getExternalModuleReference();
                TypeScriptEntityName internalModuleReference = ((TypeScriptImportStatement)psiElement).getInternalModuleReference();
                if (externalModuleReference != null) {
                    Collection resolveResults = externalModuleReference.multiResolve();
                    for (PsiElement resolve : resolveResults) {
                        if (resolve == null || !TypeScriptPsiUtil.isTopLevelContainer(resolve)) continue;
                        TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
                        if (exportAssignment != null) {
                            accepted = TypeScriptImportHandler.processAssignExpression((JSExportAssignment)exportAssignment, visitor);
                            continue;
                        }
                        if (visitor.accept(resolve)) {
                            return true;
                        }
                        accepted = true;
                    }
                } else if (internalModuleReference != null) {
                    accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(internalModuleReference.multiResolve(false)), visitor, ContainerUtil.newHashSet());
                }
            } else if (psiElement instanceof TypeScriptModule) {
                String qName = ((TypeScriptModule)psiElement).getQualifiedName();
                if (qName != null) {
                    visitor.accept(psiElement);
                    accepted = true;
                }
            } else if (TypeScriptImportHandler.isImport(psiElement)) {
                accepted = TypeScriptImportHandler.resolveImport(psiElement, visitor, ContainerUtil.newHashSet());
            } else if (psiElement instanceof TypeScriptGlobalModuleExportDeclaration) {
                for (PsiElement module : ((TypeScriptGlobalModuleExportDeclaration)psiElement).getModules()) {
                    if (visitor.accept(module)) {
                        return true;
                    }
                    accepted = true;
                }
            }
            if (!accepted && visitor.accept(psiElement)) {
                return true;
            }
            methodAccepted = true;
        }
        return methodAccepted;
    }

    private static Collection<PsiElement> convertToPsiElements(ResolveResult[] results) {
        return ContainerUtil.mapNotNull((Object[])results, ResolveResult::getElement);
    }

    private static boolean isImport(PsiElement element) {
        return element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof JSExportAssignment;
    }

    private static boolean resolveImport(PsiElement element, TypeScriptElementVisitor accumulatedElementsVisitor, Set<PsiElement> visited) {
        if (visited != null && !visited.add(element)) {
            return false;
        }
        boolean accepted = false;
        if (element instanceof TypeScriptImportStatement) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(((TypeScriptImportStatement)element).findReferencedElements(), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportExportSpecifier) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(((ES6ImportExportSpecifier)element).resolveOverAliases(visited)), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportedBinding) {
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(((ES6ImportedBinding)element).findReferencedElements(visited), accumulatedElementsVisitor, visited);
        } else if (element instanceof ES6ImportExportSpecifierAlias) {
            ES6ImportExportSpecifier specifier = ((ES6ImportExportSpecifierAlias)element).findSpecifierElement();
            if (specifier != null) {
                accepted = TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(specifier.resolveOverAliases()), accumulatedElementsVisitor, visited);
            } else {
                if (accumulatedElementsVisitor.accept(element)) {
                    return true;
                }
                accepted = true;
            }
        } else if (element instanceof JSExportAssignment) {
            accepted = TypeScriptImportHandler.processAssignExpression((JSExportAssignment)element, accumulatedElementsVisitor);
        }
        return accepted;
    }

    private static boolean processWithResolveImportReferences(Collection<? extends PsiElement> elements, TypeScriptElementVisitor accumulatedElementsVisitor, Set<PsiElement> visited) {
        boolean accepted = false;
        for (PsiElement psiElement : elements) {
            if (TypeScriptImportHandler.isImport(psiElement)) {
                accepted = TypeScriptImportHandler.resolveImport(psiElement, accumulatedElementsVisitor, visited);
                continue;
            }
            if (accumulatedElementsVisitor.accept(psiElement)) {
                return true;
            }
            accepted = true;
        }
        return accepted;
    }

    @Nullable
    public static JSElement getParentModuleOrFile(PsiElement module) {
        return ES6PsiUtil.getExportScope(module);
    }

    public static boolean checkModulesAccess(PsiElement source, PsiElement element) {
        return TypeScriptModuleAccessibilityChecker.INSTANCE.check(source, element) == null;
    }

    private static boolean processAssignExpression(JSExportAssignment assignment, TypeScriptElementVisitor accumulatedElementsVisitor) {
        boolean accepted = false;
        String referenceName = assignment.getInitializerReference();
        if (referenceName != null) {
            JSTypeResolveResult result = TypeScriptImportHandler.resolveNameImpl(referenceName, (PsiElement)assignment, accumulatedElementsVisitor.isStrictTypeContext(), accumulatedElementsVisitor.visited());
            accepted = TypeScriptImportHandler.processWithResolveImportReferences(result.getElements(), accumulatedElementsVisitor, ContainerUtil.newHashSet());
        } else {
            JSExpression assignmentExpression = assignment.getExpression();
            if (assignmentExpression instanceof JSClassExpression) {
                accumulatedElementsVisitor.accept((PsiElement)assignmentExpression);
                return true;
            }
            if (assignmentExpression instanceof JSReferenceExpression) {
                return TypeScriptImportHandler.processWithResolveImportReferences(TypeScriptImportHandler.convertToPsiElements(((JSReferenceExpression)assignmentExpression).multiResolve(false)), accumulatedElementsVisitor, null);
            }
        }
        return accepted;
    }

    private static final class SubTypeVisitor
    implements TypeScriptHierarchyVisitor {
        private TypeScriptHierarchyVisitor parent;
        private PsiElement source;
        private String name;
        private Set<Pair<JSQualifiedName, PsiElement>> visited;
        private boolean typeContext;
        private boolean isQualifier = false;

        private SubTypeVisitor() {
        }

        private TypeScriptElementVisitor createSimpleExpressionVisitor(final boolean localResolve) {
            return new TypeScriptElementVisitor(){
                private THashSet<PsiElement> accepted;
                private final boolean isLocalResolve;
                {
                    this.isLocalResolve = localResolve;
                }

                @Override
                public boolean isLocalResolve() {
                    return this.isLocalResolve;
                }

                @Override
                public boolean accept(PsiElement element) {
                    if (this.accepted == null) {
                        this.accepted = new THashSet();
                    }
                    if (!this.accepted.add((Object)element)) {
                        return false;
                    }
                    return parent.accept(element);
                }

                @Override
                public PsiElement getSource() {
                    return source;
                }

                @Override
                public boolean isStrictTypeContext() {
                    return typeContext;
                }

                @Override
                public boolean isQualifier() {
                    return isQualifier;
                }

                @Override
                public Set<Pair<JSQualifiedName, PsiElement>> visited() {
                    return visited;
                }
            };
        }

        @Override
        public boolean accept(PsiElement qualifierResult) {
            if (qualifierResult instanceof TypeScriptModule || qualifierResult instanceof JSFile) {
                TypeScriptImportHandler.findReferencedElements(this.name, qualifierResult, this.createSimpleExpressionVisitor(true));
            }
            return this.parent.isDone();
        }

        public SubTypeVisitor createSubVisitor() {
            SubTypeVisitor visitor = new SubTypeVisitor();
            visitor.parent = this;
            visitor.source = this.source;
            visitor.visited = this.visited;
            visitor.isQualifier = true;
            return visitor;
        }

        public void processQualifier(JSQualifiedName qualifiedName) {
            if (!this.visited.add((Pair<JSQualifiedName, PsiElement>)Pair.create((Object)qualifiedName, (Object)this.source))) {
                return;
            }
            this.name = qualifiedName.getName();
            JSQualifiedName qualifier = qualifiedName.getParent();
            if (qualifier != null) {
                this.createSubVisitor().processQualifier(qualifier);
            } else {
                TypeScriptImportHandler.findReferencedElements(this.name, this.source, this.createSimpleExpressionVisitor(false));
            }
        }

        @Override
        public boolean isDone() {
            return this.parent.isDone();
        }
    }

    private static interface TypeScriptHierarchyVisitor {
        public boolean accept(PsiElement var1);

        public boolean isDone();
    }

    private static interface TypeScriptElementVisitor
    extends TypeScriptImportHandlerContext {
        public boolean accept(PsiElement var1);

        public Set<Pair<JSQualifiedName, PsiElement>> visited();
    }
}

