/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandlerContext;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQualifiedNameResolver {
    private static Collection<? extends PsiElement> getLocalElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalElements"));
        }
        PsiElement module = ES6PsiUtil.getNonStrictExportScope(source);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        if (!(module instanceof JSElement)) {
            return result;
        }
        PsiElement realPlace = TypeScriptQualifiedNameResolver.getRealSource(source, context);
        TypeScriptModuleDeclarationsProcessor processor = TypeScriptQualifiedNameResolver.createProcessor(name, context, true);
        TypeScriptImportHandler.processES6DeclarationsInScope((JSElement)module, processor, ResolveState.initial(), module, realPlace, !context.isQualifier());
        return ContainerUtil.notNullize(processor.getResults());
    }

    @NotNull
    static Collection<? extends PsiElement> getElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        Collection<? extends PsiElement> collection = context.isLocalResolve() ? TypeScriptQualifiedNameResolver.getLocalElements(name, source, context) : TypeScriptQualifiedNameResolver.getGlobalElements(name, source, context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getElements"));
        }
        return collection;
    }

    @NotNull
    static Collection<? extends PsiElement> getGlobalElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        PsiElement parent;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        PsiElement moduleParent = ES6PsiUtil.getNonStrictExportScope(source);
        Collection<? extends PsiElement> localClasses = TypeScriptQualifiedNameResolver.getLocalClassesIfExists(name, source, context, moduleParent, parent = source.getParent());
        if (localClasses != null) {
            ArrayList elements = ContainerUtil.newArrayList(localClasses);
            TypeScriptQualifiedNameResolver.addMergedAndGlobalElements(source, context, elements, TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, moduleParent), true);
            ArrayList arrayList = elements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
            }
            return arrayList;
        }
        boolean isParentExternalFileModule = TypeScriptQualifiedNameResolver.isExternalFileModule(moduleParent);
        boolean isModule = moduleParent instanceof TypeScriptModule || isParentExternalFileModule;
        TypeScriptModuleDeclarationsProcessor processor = TypeScriptQualifiedNameResolver.createProcessor(name, context, false);
        PsiElement realPlace = TypeScriptQualifiedNameResolver.getRealSource(source, context);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        PsiElement module = moduleParent;
        while (module != null) {
            if (!(module instanceof JSElement)) {
                LinkedHashSet linkedHashSet = result;
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
                }
                return linkedHashSet;
            }
            TypeScriptImportHandler.processES6DeclarationsInScope((JSElement)module, processor, ResolveState.initial(), moduleParent, realPlace, !context.isQualifier());
            List<PsiElement> possibleResults = processor.getResults();
            if (possibleResults != null) {
                if (isParentExternalFileModule && !possibleResults.isEmpty()) {
                    TypeScriptQualifiedNameResolver.addMergedElementsFromAugmentations(module, context, possibleResults, realPlace, processor);
                    ArrayList results = ContainerUtil.newArrayList(processor.getResults());
                    TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(source, results);
                    ArrayList arrayList = results;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
                    }
                    return arrayList;
                }
                Collection<PsiElement> localElements = TypeScriptQualifiedNameResolver.getLocalElements(module, possibleResults);
                if (!context.isQualifier() && isModule && !ContainerUtil.isEmpty(localElements)) {
                    Collection<PsiElement> collection = localElements;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
                    }
                    return collection;
                }
                result.addAll(possibleResults);
            }
            String qName = TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, module);
            TypeScriptQualifiedNameResolver.addMergedAndGlobalElements(source, context, result, qName, false);
            if (!context.isQualifier() && !result.isEmpty()) break;
            module = TypeScriptImportHandler.getParentModuleOrFile(module);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getGlobalElements"));
        }
        return linkedHashSet;
    }

    @Nullable
    private static Collection<PsiElement> getLocalElements(@NotNull PsiElement module, @NotNull List<? extends PsiElement> possibleResults) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalElements"));
        }
        if (possibleResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleResults", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalElements"));
        }
        ArrayList notPublic = null;
        for (PsiElement psiElement : possibleResults) {
            JSAttributeList list;
            if (!(psiElement instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)psiElement).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptQualifiedNameResolver.isRealModuleOfImplicitModule(module, psiElement)) continue;
            if (notPublic == null) {
                notPublic = ContainerUtil.newArrayList();
            }
            notPublic.add(psiElement);
        }
        return notPublic;
    }

    private static boolean isExternalFileModule(PsiElement module) {
        return module instanceof JSFile && ((JSFile)module).isCommonJSModule();
    }

    @NotNull
    private static PsiElement getRealSource(@NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getRealSource"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getRealSource"));
        }
        PsiElement realPlace = context.getSource();
        if (realPlace == null) {
            realPlace = source;
        }
        PsiElement psiElement = realPlace;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getRealSource"));
        }
        return psiElement;
    }

    @Nullable
    private static Collection<? extends PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context, @Nullable PsiElement module, @Nullable PsiElement parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalClassesIfExists"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalClassesIfExists"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getLocalClassesIfExists"));
        }
        if (module == parent || module == source || context.isQualifier()) {
            return null;
        }
        if (TypeScriptQualifiedNameResolver.isAmbientModule(module)) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement currentParent = source; currentParent != module && currentParent != null && !TypeScriptPsiUtil.isTopLevelContainerMember(currentParent); currentParent = currentParent.getParent()) {
            if (currentParent instanceof JSClass && StringUtil.equals((CharSequence)((JSClass)currentParent).getName(), (CharSequence)name)) {
                result.add(currentParent);
            } else if (currentParent instanceof JSElement && TypeScriptQualifiedNameResolver.isClassScopeElement(currentParent)) {
                for (JSElement element : JSResolveUtil.findNamedElementsInScope(name, (JSElement)currentParent)) {
                    if (!(element instanceof JSClass)) continue;
                    result.add(element);
                }
            }
            if (result.isEmpty()) continue;
            return result;
        }
        return null;
    }

    private static boolean isAmbientModule(@Nullable PsiElement module) {
        VirtualFile file;
        if (module instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientDeclaration(module)) {
            return true;
        }
        return module instanceof JSFile && (file = PsiUtilCore.getVirtualFile((PsiElement)module)) != null && TypeScriptUtil.isDefinitionFile(file);
    }

    private static boolean isClassScopeElement(PsiElement currentParent) {
        return currentParent instanceof JSBlockStatement || currentParent instanceof TypeScriptModule || currentParent instanceof JSFile || currentParent instanceof TypeScriptFunction && !(currentParent instanceof TypeScriptTypeMember);
    }

    private static void addMergedAndGlobalElements(@NotNull PsiElement currentSource, TypeScriptImportHandlerContext context, @NotNull Collection<PsiElement> result, String qName, boolean modulesOnly) {
        if (currentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedAndGlobalElements"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedAndGlobalElements"));
        }
        Collection<JSQualifiedNamedElement> elementsByQName = TypeScriptClassResolver.getInstance().findElementsByQNameAndPlace(qName, currentSource);
        Condition condition = element -> {
            if (currentSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "lambda$addMergedAndGlobalElements$0"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "lambda$addMergedAndGlobalElements$0"));
            }
            return TypeScriptQualifiedNameResolver.isAcceptableMergeSymbol(element, currentSource, context, result, modulesOnly);
        };
        List filteredElements = ContainerUtil.filter(elementsByQName, (Condition)condition);
        result.addAll(filteredElements);
        TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(currentSource, result);
    }

    private static void addMergedElementsFromAugmentations(@NotNull PsiElement externalModule, @NotNull TypeScriptImportHandlerContext context, List<? extends PsiElement> possibleResults, @NotNull PsiElement realPlace, @NotNull PsiScopeProcessor processor) {
        if (externalModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalModule", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        if (realPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realPlace", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addMergedElementsFromAugmentations"));
        }
        boolean needAugmentations = false;
        for (PsiElement psiElement : possibleResults) {
            if (!ES6ImportHandler.isExported(psiElement)) continue;
            needAugmentations = true;
            break;
        }
        if (!needAugmentations) {
            return;
        }
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(realPlace, ContainerUtil.createMaybeSingletonList((Object)externalModule));
        for (PsiElement augmentation : augmentations) {
            TypeScriptImportHandler.processES6DeclarationsInScope((JSElement)augmentation, processor, ResolveState.initial(), augmentation, realPlace, !context.isQualifier());
        }
    }

    private static boolean isAcceptableMergeSymbol(@NotNull JSQualifiedNamedElement element, @NotNull PsiElement currentSource, @NotNull TypeScriptImportHandlerContext context, @NotNull Collection<PsiElement> result, boolean modulesOnly) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (currentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "isAcceptableMergeSymbol"));
        }
        if (result.contains(element)) {
            return false;
        }
        PsiElement source = TypeScriptQualifiedNameResolver.getRealSource(currentSource, context);
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return TypeScriptConfigService.Provider.isAccessible(currentSource, (PsiElement)element);
        }
        if (modulesOnly && !(element instanceof TypeScriptModule)) {
            return false;
        }
        if (!TypeScriptModuleAccessibilityChecker.checkElementCanBeExported((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSClass && !element.isNamespaceExplicitlyDeclared()) {
            return false;
        }
        PsiElement externalModule = TypeScriptPsiUtil.findExternalModule((PsiElement)element);
        if (externalModule == null) {
            return TypeScriptImportHandler.checkModulesAccess(source, (PsiElement)element) && TypeScriptConfigService.Provider.isAccessible(source, (PsiElement)element);
        }
        PsiElement externalSourceModule = TypeScriptPsiUtil.findExternalModule(currentSource);
        if (!TypeScriptQualifiedNameResolver.externalModulesEqual(externalModule, externalSourceModule) && !TypeScriptQualifiedNameResolver.checkAugmentationAccess((PsiElement)element, externalModule, source)) {
            return false;
        }
        return TypeScriptImportHandler.checkModulesAccess(source, (PsiElement)element) && TypeScriptConfigService.Provider.isAccessible(source, (PsiElement)element) && ES6ImportHandler.isExported((PsiElement)element);
    }

    private static boolean externalModulesEqual(@Nullable PsiElement module, @Nullable PsiElement sourceModule) {
        if (module == sourceModule) {
            return true;
        }
        if (module == null) {
            return false;
        }
        if (module.isEquivalentTo(sourceModule)) {
            return true;
        }
        if (module instanceof TypeScriptModule && sourceModule instanceof TypeScriptModule) {
            String qName = ((TypeScriptModule)module).getQualifiedName();
            return qName != null && qName.equals(((TypeScriptModule)sourceModule).getQualifiedName());
        }
        return false;
    }

    private static void addAugmentationsForModuleResults(@NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result) {
        Collection<PsiElement> externalModules;
        if (currentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSource", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addAugmentationsForModuleResults"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "addAugmentationsForModuleResults"));
        }
        if (result.size() > 0 && !(externalModules = TypeScriptQualifiedNameResolver.getModulesForAugmentations(result)).isEmpty()) {
            result.addAll(TypeScriptAugmentationUtil.getAugmentations(currentSource, externalModules));
        }
    }

    private static Collection<PsiElement> getModulesForAugmentations(@NotNull Collection<PsiElement> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getModulesForAugmentations"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        for (PsiElement element : result) {
            TypeScriptModule typeScriptModule;
            String refName;
            TypeScriptExportAssignment assignment;
            PsiElement module;
            if (TypeScriptPsiUtil.isExternalModule(element)) {
                modules.add(element);
                continue;
            }
            if (!(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isInternal() || (module = TypeScriptPsiUtil.findExternalModule(element)) == null || (assignment = TypeScriptPsiUtil.findExportAssignment(module)) == null || !StringUtil.equals((CharSequence)(refName = assignment.getInitializerReference()), (CharSequence)TypeScriptQualifiedNameResolver.getQualifiedNameWithoutParentModule(typeScriptModule = (TypeScriptModule)element, module))) continue;
            modules.add(module);
        }
        return modules;
    }

    @Nullable
    private static String getQualifiedNameWithoutParentModule(@NotNull TypeScriptModule module, @NotNull PsiElement externalModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getQualifiedNameWithoutParentModule"));
        }
        if (externalModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalModule", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getQualifiedNameWithoutParentModule"));
        }
        if (externalModule instanceof TypeScriptModule) {
            String name = ((TypeScriptModule)externalModule).getQualifiedName();
            String moduleQualifiedName = module.getQualifiedName();
            if (moduleQualifiedName == null || name == null) {
                return moduleQualifiedName;
            }
            int indexOfExternalModule = moduleQualifiedName.indexOf(name);
            return moduleQualifiedName.substring(indexOfExternalModule + name.length() + 1);
        }
        return module.getQualifiedName();
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "getQualifiedNameForModule"));
        }
        return module instanceof TypeScriptModule ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    @NotNull
    public static TypeScriptModuleDeclarationsProcessor createProcessor(@NotNull String name, TypeScriptImportHandlerContext context, boolean allowExport) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "createProcessor"));
        }
        TypeScriptModuleDeclarationsProcessor typeScriptModuleDeclarationsProcessor = new TypeScriptModuleDeclarationsProcessor(name, context.isStrictTypeContext(), allowExport);
        if (typeScriptModuleDeclarationsProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "createProcessor"));
        }
        return typeScriptModuleDeclarationsProcessor;
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    public static boolean checkAugmentationAccess(@NotNull PsiElement element, @NotNull PsiElement module, @Nullable PsiElement source) {
        PsiElement sourceContainer;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "checkAugmentationAccess"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver", "checkAugmentationAccess"));
        }
        if (!TypeScriptQualifiedNameResolver.isNotAugmentationModule(element)) {
            return true;
        }
        if (source instanceof TypeScriptModule) {
            sourceContainer = source;
        } else {
            JSElement jSElement = sourceContainer = source == null ? null : ES6PsiUtil.getExportScope(source);
        }
        return module.isEquivalentTo(sourceContainer) || module instanceof JSQualifiedNamedElement && sourceContainer instanceof JSQualifiedNamedElement && StringUtil.equals((CharSequence)((JSQualifiedNamedElement)module).getQualifiedName(), (CharSequence)((JSQualifiedNamedElement)sourceContainer).getQualifiedName()) || !TypeScriptQualifiedNameResolver.isNotAugmentationModule(module) || !TypeScriptQualifiedNameResolver.isNotAugmentationModule(sourceContainer);
    }

    public static boolean isNotAugmentationModule(PsiElement element) {
        return !(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isAugmentation();
    }
}

