/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.psi.impl.TypeScriptExternalModuleReferenceImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceContributor
extends PsiReferenceContributor {
    public static final Pattern TYPESCRIPT_REFERENCE_PATH = Pattern.compile("^///\\s*<\\s*reference\\s*path\\s*=\\s*(['\"])([^'\"]+)\\1[^/]*\\s*/>.*$");
    public static final ElementPattern<JSLiteralExpression> AUGMENTATION_REF = ((PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).withParent(TypeScriptModule.class)).with((PatternCondition)new PatternCondition<JSLiteralExpression>("TypeScript.declare.augmentation"){

        public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$1", "accepts"));
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof TypeScriptModule)) {
                return false;
            }
            return ((TypeScriptModule)parent).isAugmentation() && ((TypeScriptModule)parent).getNameIdentifier() == expression;
        }
    });

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(JavaScriptReferenceContributor.REQUIRE_ARG_PLACE, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2", "getReferencesByElement"));
                }
                JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element, JSLiteralExpression.class);
                if (literalExpression != null) {
                    PsiReference[] psiReferenceArray = TypeScriptExternalModuleReferenceImpl.getSimpleExternalModuleReferences(literalExpression.getParent(), literalExpression.getText(), literalExpression.getStartOffsetInParent() + 1, true);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$2", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
        registrar.registerReferenceProvider(AUGMENTATION_REF, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3", "getReferencesByElement"));
                }
                JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element, JSLiteralExpression.class);
                if (literalExpression == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text = element.getText();
                String unquoted = StringUtil.unquoteString((String)text);
                PsiElement parent = element.getParent();
                Object[] result = PsiReference.EMPTY_ARRAY;
                for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])JSModuleReferenceContributor.EP_NAME.getExtensions()) {
                    if (!contributor.isApplicable(parent)) continue;
                    Object[] references = contributor.getAllReferences(unquoted, element, 1, this);
                    result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])references);
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$3", "getReferencesByElement"));
                }
                return result;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiComment().withElementType(JSTokenTypes.END_OF_LINE_COMMENT)).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                PsiElement psiElement = (PsiElement)element;
                if (!DialectDetector.isTypeScript(psiElement)) {
                    return false;
                }
                String text = psiElement.getText();
                return TYPESCRIPT_REFERENCE_PATH.matcher(text).matches();
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4", "getReferencesByElement"));
                }
                PsiComment comment = (PsiComment)ObjectUtils.tryCast((Object)psiElement, PsiComment.class);
                Matcher matcher = TYPESCRIPT_REFERENCE_PATH.matcher(psiElement.getText());
                if (comment != null && matcher.find()) {
                    String fileName = matcher.group(2);
                    FileReference[] fileReferenceArray = new FileReferenceSetWithDefaultContext(fileName, (PsiElement)comment, matcher.start(2), this, false, false){

                        public boolean isAbsolutePathReference() {
                            if (super.isAbsolutePathReference()) {
                                return true;
                            }
                            String path = this.getPathString();
                            return path != null && FileUtil.isAbsolute((String)path);
                        }

                        @NotNull
                        public Collection<PsiFileSystemItem> getDefaultContexts() {
                            Collection contexts = super.getDefaultContexts();
                            if (this.isAbsolutePathReference()) {
                                Collection fileSystemRoots = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                                ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{contexts, fileSystemRoots}));
                                if (arrayList == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4$1", "getDefaultContexts"));
                                }
                                return arrayList;
                            }
                            Collection collection = contexts;
                            if (collection == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4$1", "getDefaultContexts"));
                            }
                            return collection;
                        }

                        protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
                            if (sequence == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4$1", "findSeparatorOffset"));
                            }
                            return StringUtil.indexOfAny((CharSequence)sequence, (String)"\\/", (int)startingFrom, (int)sequence.length());
                        }

                        protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
                            if (sequence == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4$1", "findSeparatorLength"));
                            }
                            char c = sequence.charAt(atOffset);
                            return c == '\\' || c == '/' ? 1 : 0;
                        }

                        public FileReference createFileReference(TextRange textRange, int i, String text) {
                            return new JSFileReference(text, i, textRange, this, TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
                        }
                    }.getAllReferences();
                    if (fileReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4", "getReferencesByElement"));
                    }
                    return fileReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$4", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }

    @Nullable
    public static String findReferencePath(@NotNull PsiComment comment) {
        Matcher matcher;
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor", "findReferencePath"));
        }
        if (comment.getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT && (matcher = TYPESCRIPT_REFERENCE_PATH.matcher(comment.getText())).matches()) {
            return matcher.group(2);
        }
        return null;
    }

    @Nullable
    public static PsiFile findReferencedFile(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor", "findReferencedFile"));
        }
        if (TypeScriptReferenceContributor.findReferencePath(comment) == null) {
            return null;
        }
        PsiReference[] references = comment.getReferences();
        if (references.length == 0 || !(references[references.length - 1] instanceof JSFileReference)) {
            return null;
        }
        PsiElement resolve = references[references.length - 1].resolve();
        return resolve instanceof PsiFile ? (PsiFile)resolve : null;
    }

    public static class FileReferenceSetWithDefaultContext
    extends FileReferenceSet {
        public FileReferenceSetWithDefaultContext(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext", "<init>"));
            }
            super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            PsiDirectory directory;
            PsiFile file = this.getContainingFile();
            if (file == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext", "computeDefaultContexts"));
                }
                return list;
            }
            if (this.isAbsolutePathReference()) {
                Collection collection = FileReferenceSetWithDefaultContext.getAbsoluteTopLevelDirLocations((PsiFile)file);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext", "computeDefaultContexts"));
                }
                return collection;
            }
            VirtualFile parent = file.getViewProvider().getVirtualFile().getParent();
            if (parent != null && (directory = file.getManager().findDirectory(parent)) != null) {
                Set<PsiDirectory> set = Collections.singleton(directory);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext", "computeDefaultContexts"));
                }
                return set;
            }
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceContributor$FileReferenceSetWithDefaultContext", "computeDefaultContexts"));
            }
            return list;
        }
    }
}

