/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class TypescriptConstructorChecker
extends JSConstructorChecker {
    public TypescriptConstructorChecker(@NotNull JSAnnotatorProblemReporter problemReporter) {
        if (problemReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemReporter", "com/intellij/lang/javascript/ecmascript6/TypescriptConstructorChecker", "<init>"));
        }
        super(problemReporter);
    }

    @Override
    protected boolean isBaseConstructorCallValid(@NotNull JSFunction constructor, @NotNull JSClass jsClass) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/lang/javascript/ecmascript6/TypescriptConstructorChecker", "isBaseConstructorCallValid"));
        }
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/ecmascript6/TypescriptConstructorChecker", "isBaseConstructorCallValid"));
        }
        if (constructor instanceof TypeScriptFunction && ((TypeScriptFunction)constructor).isOverloadDeclaration()) {
            return true;
        }
        JSAttributeList list = jsClass.getAttributeList();
        if (list != null && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)jsClass)) {
            return true;
        }
        return super.isBaseConstructorCallValid(constructor, jsClass);
    }
}

