/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSToolWindowProvider {
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        FlowJSToolWindowProvider provider = (FlowJSToolWindowProvider)ServiceManager.getService((Project)project, FlowJSToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public FlowJSToolWindowProvider(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider", "<init>"));
        }
        AnAction checkAllFiles = new AnAction(JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JSBundle.message((String)"javascript.flow.error.panel.all.errors", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile1){

            public void actionPerformed(AnActionEvent e) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$1", "lambda$actionPerformed$1"));
                    }
                    FlowJSServerService service = FlowJSServerService.getService(project);
                    List<Object> results = service != null ? service.getAllErrors() : Collections.emptyList();
                    ApplicationManager.getApplication().invokeLater(() -> FlowJSToolWindowProvider.this.myToolWindow.logProjectErrors((ImmutableList<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)results), true));
                });
            }
        };
        this.myToolWindow = new JSLanguageServiceToolWindowManager(project, "Flow", "reference.tool.windows.flow", JavaScriptLanguageIcons.Flowjs.Flow13, checkAllFiles);
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
        this.initToolWindow(project);
    }

    private void initToolWindow(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider", "initToolWindow"));
        }
        if (project.isDisposed() || !project.isOpen() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider", "lambda$initToolWindow$1"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider", "lambda$null$0"));
                }
                if (!project.isDefault() && !project.isDisposed()) {
                    this.myToolWindow.init();
                }
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }, project.getDisposed());
        });
    }

    public JSLanguageServiceToolWindowManager getToolWindow() {
        return this.myToolWindow;
    }
}

