/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class JSCodeStylePanel
extends CodeStyleAbstractPanel {
    public static final String SINGLE_QUOTE = "Single quote";
    public static final String DOUBLE_QUOTES = "Double quotes";
    private JPanel myPanel;
    protected JCheckBox myIndentPackageChildren;
    private JPanel myPreviewPanel;
    protected JTextField myFieldPrefixTextField;
    protected JTextField myPropertyPrefixTextField;
    protected JCheckBox myUseSemicolon;
    protected JPanel myNamingConventionsPane;
    protected JPanel myFormattingOptionsPane;
    private JComboBox myAlignObjectPropertiesCombo;
    private JPanel myCodingStylePane;
    private JCheckBox myFormatCStyleCommentsBox;
    private JPanel myCodeCommentingPanel;
    private JPanel myAlignAssignmentsPanel;
    private JBRadioButton myAlignAssignmentsNoneButton;
    private JBRadioButton myAlignEachVarStatementButton;
    private JRadioButton myAlignAssignmentGroupsButton;
    private JPanel myOptionsPanel;
    protected JPanel myGeneratedOptionsPanel;
    private ComboBox myLiteralQuoteType;
    protected JBCheckBox myUsePublicModifierJBCheckBox;
    private JCheckBox myEnforceQuotesOnFormat;
    private JCheckBox myEnforceSemicolonOnFormat;
    private static CodeStyleSettings mySettings;
    private boolean myInsideUpdate;
    private CommenterForm myCommenterForm;

    public JSCodeStylePanel(Language language, CodeStyleSettings settings) {
        mySettings = settings;
        super(language, null, mySettings);
        this.myInsideUpdate = false;
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        this.addPanelToWatch(this.myPanel);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!JSCodeStylePanel.this.myInsideUpdate) {
                    JSCodeStylePanel.this.somethingChanged();
                }
            }
        };
        this.myUseSemicolon.addItemListener(listener);
        DocumentAdapter adapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!JSCodeStylePanel.this.myInsideUpdate) {
                    JSCodeStylePanel.this.somethingChanged();
                }
            }
        };
        JSCodeStylePanel.initAlignPropertyCombobox(this.myAlignObjectPropertiesCombo);
        this.myAlignObjectPropertiesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MyAlignPropertiesItem item = (MyAlignPropertiesItem)JSCodeStylePanel.this.myAlignObjectPropertiesCombo.getSelectedItem();
                JSCodeStylePanel.this.getCustomJSSettings((CodeStyleSettings)mySettings).ALIGN_OBJECT_PROPERTIES = item.getValue();
                if (!JSCodeStylePanel.this.myInsideUpdate) {
                    JSCodeStylePanel.this.somethingChanged();
                }
            }
        });
        this.myFieldPrefixTextField.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myPropertyPrefixTextField.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myNamingConventionsPane.setVisible(false);
        this.myIndentPackageChildren.setVisible(false);
        this.myUsePublicModifierJBCheckBox.setVisible(false);
        this.myGeneratedOptionsPanel.setVisible(false);
        this.myNamingConventionsPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"javascript.formatting.options.panel.naming.conventions", (Object[])new Object[0]), (boolean)true));
        this.myCodingStylePane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"javascript.formatting.options.panel.coding.style", (Object[])new Object[0]), (boolean)true));
        this.myFormattingOptionsPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"javascript.formatting.options.panel.title", (Object[])new Object[0]), (boolean)true));
        this.myFormatCStyleCommentsBox.setMargin(new Insets(2, 0, 2, 2));
        this.myAlignAssignmentsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Align 'var' statements and assignments"));
        this.myGeneratedOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"js.settings.generated.code.title", (Object[])new Object[0])));
        this.initLiteralQuoteType();
    }

    public static void initAlignPropertyCombobox(JComboBox combobox) {
        combobox.addItem(new MyAlignPropertiesItem(0, JSBundle.message((String)"js.align.properties.none", (Object[])new Object[0])));
        combobox.addItem(new MyAlignPropertiesItem(2, JSBundle.message((String)"js.align.properties.on.colon", (Object[])new Object[0])));
        combobox.addItem(new MyAlignPropertiesItem(1, JSBundle.message((String)"js.align.properties.on.value", (Object[])new Object[0])));
    }

    private void initLiteralQuoteType() {
        this.myLiteralQuoteType.addItem((Object)SINGLE_QUOTE);
        this.myLiteralQuoteType.addItem((Object)DOUBLE_QUOTES);
    }

    private void createUIComponents() {
        this.myCommenterForm = new CommenterForm(this.getDefaultLanguage());
        this.myCodeCommentingPanel = this.myCommenterForm.getCommenterPanel();
    }

    public static int getSelectedAlignPropertiesValue(JComboBox combobox) {
        Object item = combobox.getSelectedItem();
        if (item instanceof MyAlignPropertiesItem) {
            return ((MyAlignPropertiesItem)combobox.getSelectedItem()).getValue();
        }
        return 0;
    }

    public static void selectAlignPropertiesValue(JComboBox combobox, int value) {
        for (int i = 0; i < combobox.getItemCount(); ++i) {
            Object item = combobox.getItemAt(i);
            if (!(item instanceof MyAlignPropertiesItem) || ((MyAlignPropertiesItem)item).getValue() != value) continue;
            combobox.setSelectedIndex(i);
        }
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.js"), scheme, null);
    }

    protected int getRightMargin() {
        return 60;
    }

    protected void prepareForReformat(PsiFile psiFile) {
    }

    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = JavaScriptSupportLoader.JAVASCRIPT;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSCodeStylePanel", "getFileType"));
        }
        return languageFileType;
    }

    protected String getPreviewText() {
        JSCodeStyleSettings jsCodeStyleSettings = (JSCodeStyleSettings)mySettings.getCustomSettings(JSCodeStyleSettings.class);
        String semiColon = (this.myUseSemicolon != null ? this.myUseSemicolon.isSelected() : jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT) ? ";" : "";
        return "/*\n Multiline\n C-style\n Comment\n */\nvar myLink = {\n      img: \"btn.gif\",\n      text: \"Button\",\n      width: 128\n    },\n    local = true,\n    initial = -1;\nvar selector = \"#id\";\n\nvar color = \"red\";\nvar offset = 10;\n\nvarName = val" + semiColon + "\n";
    }

    public void apply(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        jsCodeStyleSettings.INDENT_PACKAGE_CHILDREN = this.myIndentPackageChildren.isSelected() ? 1 : 0;
        jsCodeStyleSettings.FIELD_PREFIX = this.myFieldPrefixTextField.getText();
        jsCodeStyleSettings.PROPERTY_PREFIX = this.myPropertyPrefixTextField.getText();
        jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT = this.myUseSemicolon.isSelected();
        jsCodeStyleSettings.ALIGN_OBJECT_PROPERTIES = JSCodeStylePanel.getSelectedAlignPropertiesValue(this.myAlignObjectPropertiesCombo);
        jsCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS = this.myFormatCStyleCommentsBox.isSelected();
        jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION = this.myAlignEachVarStatementButton.isSelected();
        jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS = this.myAlignAssignmentGroupsButton.isSelected();
        jsCodeStyleSettings.USE_DOUBLE_QUOTES = DOUBLE_QUOTES.equals(this.myLiteralQuoteType.getSelectedItem());
        jsCodeStyleSettings.USE_PUBLIC_MODIFIER = this.myUsePublicModifierJBCheckBox.isSelected();
        jsCodeStyleSettings.FORCE_QUOTE_STYlE = this.myEnforceQuotesOnFormat.isSelected();
        jsCodeStyleSettings.FORCE_SEMICOLON_STYLE = this.myEnforceSemicolonOnFormat.isSelected();
        this.myCommenterForm.apply(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
        return jsCodeStyleSettings.INDENT_PACKAGE_CHILDREN == 1 != this.myIndentPackageChildren.isSelected() || !jsCodeStyleSettings.FIELD_PREFIX.equals(this.myFieldPrefixTextField.getText()) || !jsCodeStyleSettings.PROPERTY_PREFIX.equals(this.myPropertyPrefixTextField.getText()) || jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT != this.myUseSemicolon.isSelected() || jsCodeStyleSettings.ALIGN_OBJECT_PROPERTIES != JSCodeStylePanel.getSelectedAlignPropertiesValue(this.myAlignObjectPropertiesCombo) || jsCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS != this.myFormatCStyleCommentsBox.isSelected() || jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION != this.myAlignEachVarStatementButton.isSelected() || jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS != this.myAlignAssignmentGroupsButton.isSelected() || jsCodeStyleSettings.USE_DOUBLE_QUOTES != DOUBLE_QUOTES.equals(this.myLiteralQuoteType.getSelectedItem()) || jsCodeStyleSettings.USE_PUBLIC_MODIFIER != this.myUsePublicModifierJBCheckBox.isSelected() || jsCodeStyleSettings.FORCE_QUOTE_STYlE != this.myEnforceQuotesOnFormat.isSelected() || jsCodeStyleSettings.FORCE_SEMICOLON_STYLE != this.myEnforceSemicolonOnFormat.isSelected() || this.myCommenterForm.isModified(settings);
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public Set<String> processListOptions() {
        HashSet options = ContainerUtil.newHashSet((Iterable)super.processListOptions());
        options.add(SINGLE_QUOTE);
        options.add(DOUBLE_QUOTES);
        return options;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        try {
            this.myInsideUpdate = true;
            JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(settings);
            this.myIndentPackageChildren.setSelected(jsCodeStyleSettings.INDENT_PACKAGE_CHILDREN == 1);
            this.myFieldPrefixTextField.setText(jsCodeStyleSettings.FIELD_PREFIX);
            this.myPropertyPrefixTextField.setText(jsCodeStyleSettings.PROPERTY_PREFIX);
            this.myUseSemicolon.setSelected(jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT);
            JSCodeStylePanel.selectAlignPropertiesValue(this.myAlignObjectPropertiesCombo, jsCodeStyleSettings.ALIGN_OBJECT_PROPERTIES);
            this.myFormatCStyleCommentsBox.setSelected(jsCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS);
            this.myAlignAssignmentsNoneButton.setSelected(!jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS && !jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION);
            this.myAlignEachVarStatementButton.setSelected(jsCodeStyleSettings.ALIGN_MULTILINE_VAR_DECLARATION);
            this.myAlignAssignmentGroupsButton.setSelected(jsCodeStyleSettings.ALIGN_MULTIPLE_ASSIGNMENTS);
            this.myLiteralQuoteType.setSelectedItem((Object)(jsCodeStyleSettings.USE_DOUBLE_QUOTES ? DOUBLE_QUOTES : SINGLE_QUOTE));
            this.myUsePublicModifierJBCheckBox.setSelected(jsCodeStyleSettings.USE_PUBLIC_MODIFIER);
            this.myEnforceQuotesOnFormat.setSelected(jsCodeStyleSettings.FORCE_QUOTE_STYlE);
            this.myEnforceSemicolonOnFormat.setSelected(jsCodeStyleSettings.FORCE_SEMICOLON_STYLE);
            this.myCommenterForm.reset(settings);
        }
        finally {
            this.myInsideUpdate = false;
        }
    }

    protected String getFileTypeExtension(FileType fileType) {
        return "js";
    }

    protected JSCodeStyleSettings getCustomJSSettings(CodeStyleSettings settings) {
        return (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        ComboBox comboBox;
        JCheckBox jCheckBox3;
        JPanel jPanel3;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel4;
        JRadioButton jRadioButton;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel5;
        JCheckBox jCheckBox4;
        JComboBox jComboBox;
        JCheckBox jCheckBox5;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        this.createUIComponents();
        this.myPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel8.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myOptionsPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel7);
        this.myFormattingOptionsPane = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/JavaScriptBundle").getString("javascript.formatting.options.panel.title"), (int)0, (int)0, null, null));
        this.myIndentPackageChildren = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("to.indent.package.statement.children"));
        jCheckBox5.setMargin(new Insets(2, 0, 2, 2));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.align.properties"));
        jPanel9.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAlignObjectPropertiesCombo = jComboBox = new JComboBox();
        jPanel9.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFormatCStyleCommentsBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.format.cstyle.comments"));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignAssignmentsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Align 'var' statements and assignments", 0, 0, null, null));
        this.myAlignAssignmentsNoneButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Do not align");
        jPanel5.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignEachVarStatementButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Align multiline 'var' statements");
        jPanel5.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignAssignmentGroupsButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Align multiple 'var' statements and assignments");
        jPanel5.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNamingConventionsPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Naming conventions", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Field prefix:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFieldPrefixTextField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Property prefix:");
        jLabel3.setDisplayedMnemonic('P');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPropertyPrefixTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCodingStylePane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Coding style", (int)0, (int)0, null, null));
        this.myUseSemicolon = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("use.semicolon.to.terminate.statement"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.quote.marks"));
        jPanel3.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLiteralQuoteType = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEnforceQuotesOnFormat = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.quote.marks.enforce.on.reformat"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(3, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEnforceSemicolonOnFormat = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.quote.marks.enforce.on.reformat"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = this.myCodeCommentingPanel;
        jPanel7.add((Component)jPanel10, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGeneratedOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Generated code options", 0, 0, null, null));
        this.myUsePublicModifierJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("js.generated.use.public.modifier"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(0, 1, 5, 1, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class MyAlignPropertiesItem {
        private String myTitle;
        private int myValue;

        public MyAlignPropertiesItem(int value, String title) {
            this.myValue = value;
            this.myTitle = title;
        }

        public int getValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myTitle;
        }
    }
}

