/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.StringUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class JSEnforceCodeStylePreprocessor
implements PreFormatProcessor {
    private static TokenSet possiblyAmbiguousTokens = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACKET, JSTokenTypes.LPAR, JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.DIV, JSTokenTypes.BACKQUOTE});

    @NotNull
    public TextRange process(@NotNull ASTNode element, final @NotNull TextRange range) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "process"));
        }
        PsiElement rootPsi = element.getPsi();
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(rootPsi);
        if (dialect == null || !dialect.getOptionHolder().isJavaScript() && !dialect.getOptionHolder().isTypeScript) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "process"));
            }
            return textRange;
        }
        final JSCodeStyleSettings languageSettings = JSCodeStyleSettings.getSettings(rootPsi);
        if (!languageSettings.FORCE_QUOTE_STYlE && !languageSettings.FORCE_SEMICOLON_STYLE) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "process"));
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        final Document document = psiDocumentManager.getDocument(rootPsi.getContainingFile());
        if (document == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "process"));
            }
            return textRange;
        }
        JSRecursiveElementVisitor visitor = new JSRecursiveElementVisitor(){
            int myDelta = 0;

            public void visitElement(PsiElement element) {
                String result;
                super.visitElement(element);
                if (!languageSettings.FORCE_QUOTE_STYlE) {
                    return;
                }
                ASTNode node = element.getNode();
                if (!JSTokenTypes.STRING_LITERALS.contains(node.getElementType())) {
                    return;
                }
                String stringValue = node.getText();
                if (stringValue.equals(result = JSEnforceCodeStylePreprocessor.applyQuoteStyle(stringValue, languageSettings.USE_DOUBLE_QUOTES))) {
                    return;
                }
                document.replaceString(node.getStartOffset() + this.myDelta, node.getStartOffset() + node.getTextLength() + this.myDelta, (CharSequence)result);
                this.myDelta += result.length() - stringValue.length();
            }

            public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
                super.visitES6ImportDeclaration(importDeclaration);
                this.applySemicolonStyle((JSElement)importDeclaration);
            }

            public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
                super.visitES6ExportDeclaration(exportDeclaration);
                this.applySemicolonStyle((JSElement)exportDeclaration);
            }

            public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
                super.visitES6ExportDefaultAssignment(node);
                this.applySemicolonStyle((JSElement)node);
            }

            public void visitJSStatement(JSStatement node) {
                super.visitJSStatement(node);
                if (!JSUtils.isStatementUsuallyRequiringSemicolon(node)) {
                    return;
                }
                this.applySemicolonStyle((JSElement)node);
            }

            public void visitJSForStatement(JSForStatement node) {
                this.visitElement((PsiElement)node.getBody());
            }

            private void applySemicolonStyle(@NotNull JSElement node) {
                boolean needSemicolon;
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor$1", "applySemicolonStyle"));
                }
                if (!languageSettings.FORCE_SEMICOLON_STYLE || !range.contains(node.getTextRange())) {
                    return;
                }
                boolean hasSemicolon = node.getLastChild().getNode().getElementType() == JSTokenTypes.SEMICOLON;
                if (hasSemicolon == (needSemicolon = languageSettings.USE_SEMICOLON_AFTER_STATEMENT)) {
                    return;
                }
                int endOffset = node.getNode().getStartOffset() + node.getTextLength();
                if (needSemicolon) {
                    document.insertString(endOffset + this.myDelta, (CharSequence)";");
                    ++this.myDelta;
                } else if (JSEnforceCodeStylePreprocessor.isSafeToDeleteSemicolon(node)) {
                    document.deleteString(endOffset - 1 + this.myDelta, endOffset + this.myDelta);
                    --this.myDelta;
                }
            }
        };
        DocumentUtil.executeInBulk((Document)document, (boolean)true, () -> {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "process"));
        }
        return textRange;
    }

    private static boolean isSafeToDeleteSemicolon(@NotNull JSElement jsElement) {
        if (jsElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsElement", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "isSafeToDeleteSemicolon"));
        }
        if (!(jsElement instanceof JSStatement)) {
            return true;
        }
        JSStatement nextStatement = (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)jsElement, JSStatement.class);
        if (nextStatement == null) {
            return true;
        }
        PsiElement firstLeaf = PsiTreeUtil.getDeepestFirst((PsiElement)nextStatement);
        return !possiblyAmbiguousTokens.contains(firstLeaf.getNode().getElementType());
    }

    private static String applyQuoteStyle(@NotNull String original, boolean useDoubleQuotes) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePreprocessor", "applyQuoteStyle"));
        }
        if (useDoubleQuotes == StringUtil.isDoubleQuotedString(original)) {
            return original;
        }
        return StringUtil.changeQuotes(original);
    }
}

