/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;

public class StandardJSCodeStyle
extends PredefinedCodeStyle {
    public StandardJSCodeStyle() {
        super("JavaScript Standard Style", (Language)JavascriptLanguage.INSTANCE);
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            throw new RuntimeException("Assertion failure. indent options were null");
        }
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        jsSettings.USE_DOUBLE_QUOTES = false;
        jsSettings.FORCE_QUOTE_STYlE = true;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = true;
        commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
        jsSettings.USE_SEMICOLON_AFTER_STATEMENT = false;
        jsSettings.FORCE_SEMICOLON_STYLE = true;
        jsSettings.SPACES_WITHIN_IMPORTS = true;
    }
}

