/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSNodeVisitor;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.JavascriptFormattingModelBuilder;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSDocCommentBlock;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSLocalAlignmentFactory;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.webcore.template.formatter.TemplateFormatUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubBlockVisitor
extends JSNodeVisitor {
    public static final TokenSet IMPORT_EXPORT_SPECIFIERS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_SPECIFIER, ES6ElementTypes.IMPORT_SPECIFIER});
    public static final TokenSet IMPORT_EXPORT_DECLARATION = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION, ES6ElementTypes.IMPORT_DECLARATION});
    List<Block> myBlocks;
    protected final CommonCodeStyleSettings mySettings;
    private final CodeStyleSettings myTopSettings;
    private final Language myDialect;
    private final JSCodeStyleSettings myJSCodeStyleSettings;
    private final JSBlock myBlock;
    private final JSLocalAlignmentFactory myAlignmentFactory;

    public SubBlockVisitor(@Nullable JSBlock block, @NotNull CodeStyleSettings settings, @NotNull Language dialect, ASTNodeBasedAlignmentFactory alignmentFactory, JSCodeStyleSettings jsCodeStyleSettings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor", "<init>"));
        }
        this.myBlocks = new ArrayList<Block>();
        this.myBlock = block;
        this.myTopSettings = settings;
        this.myDialect = dialect;
        this.mySettings = this.myTopSettings.getCommonSettings(dialect);
        this.myJSCodeStyleSettings = jsCodeStyleSettings;
        this.myAlignmentFactory = this.createLocalAlignmentFactory(settings);
        this.myAlignmentFactory.setSharedAlignmentFactory(alignmentFactory);
    }

    protected JSLocalAlignmentFactory createLocalAlignmentFactory(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor", "createLocalAlignmentFactory"));
        }
        return new JSLocalAlignmentFactory(this.mySettings);
    }

    public SubBlockVisitor(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor", "<init>"));
        }
        this(null, settings, (Language)JavascriptLanguage.INSTANCE, null, (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class));
    }

    public List<Block> getBlocks() {
        return this.myBlocks;
    }

    @Override
    public void visitElement(ASTNode node) {
        JavascriptFormattingModelBuilder builder = (JavascriptFormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(this.myDialect);
        Indent sharedSmartIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
        for (PsiElement elt = node.getPsi().getFirstChild(); elt != null; elt = elt.getNextSibling()) {
            Object block;
            XmlFormattingPolicy policy;
            ASTNode child = elt.getNode();
            assert (child != null);
            if (child.getElementType() == JSTokenTypes.WHITE_SPACE || child.getTextRange().getLength() <= 0) continue;
            Wrap wrap = this.getWrap(node, child);
            Alignment childAlignment = this.myAlignmentFactory.getAlignment(child);
            Indent childIndent = this.getIndent(node, child, sharedSmartIndent);
            XmlFormattingPolicy xmlFormattingPolicy = policy = this.myBlock != null ? this.myBlock.getPolicy() : null;
            if (child instanceof JSXmlLiteralExpressionImpl && policy != null) {
                block = this.createXmlTagBlock(child, wrap, childAlignment, childIndent, policy);
            } else {
                Block outerLangBlock;
                Block block2 = outerLangBlock = child.getPsi() instanceof OuterLanguageElement ? TemplateFormatUtil.buildTemplateLanguageBlock((OuterLanguageElement)((OuterLanguageElement)child.getPsi()), (CodeStyleSettings)this.myTopSettings, (Indent)childIndent) : null;
                if (outerLangBlock != null) {
                    block = outerLangBlock;
                } else {
                    JSBlock childBlock = builder.createSubBlock(child, childAlignment, childIndent, wrap, this.myTopSettings, this.myDialect, this.myAlignmentFactory.getSharedAlignmentFactory(), this.myJSCodeStyleSettings);
                    childBlock.setChildWrap(this.createChildWrap(child));
                    childBlock.setPolicy(policy);
                    block = childBlock;
                }
            }
            this.addBlock((Block)block);
        }
    }

    @NotNull
    protected XmlTagBlock createXmlTagBlock(ASTNode child, Wrap wrap, Alignment childAlignment, Indent childIndent, XmlFormattingPolicy policy) {
        JSXmlTagBlock jSXmlTagBlock = new JSXmlTagBlock(child, wrap, childAlignment, policy, childIndent);
        if (jSXmlTagBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor", "createXmlTagBlock"));
        }
        return jSXmlTagBlock;
    }

    @Override
    public void visitDocComment(ASTNode node) {
        ASTNode child = node.getFirstChildNode();
        if (child != null && child.getElementType() == JSTokenTypes.DOC_COMMENT) {
            this.visit(child);
        } else {
            super.visitDocComment(node);
        }
    }

    @Override
    public void visitComment(ASTNode node) {
        if (this.myJSCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS) {
            this.buildCommentBlocks(node);
        }
    }

    protected void addBlock(Block block) {
        this.myBlocks.add(block);
    }

    private void buildCommentBlocks(ASTNode node) {
        String commentText = node.getText();
        int pos = 0;
        while (pos < commentText.length()) {
            int nextPos = commentText.indexOf(10, pos);
            if (nextPos < 0) {
                nextPos = commentText.length();
            }
            if (pos != nextPos) {
                Indent childIndent = pos == 0 ? Indent.getNoneIndent() : Indent.getSpaceIndent((int)1);
                this.addBlock(new JSDocCommentBlock(node, pos, nextPos, childIndent));
            }
            for (pos = nextPos + 1; pos < commentText.length() && (commentText.charAt(pos) == ' ' || commentText.charAt(pos) == '\t' || commentText.charAt(pos) == '\n'); ++pos) {
            }
        }
    }

    @Nullable
    protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
        ASTNode prevNode;
        IElementType parentNodeType;
        IElementType nodeElementType = node.getElementType();
        if (nodeElementType instanceof JSFileElementType || nodeElementType instanceof EmbeddingElementType || node.getPsi() instanceof JSFile) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSTokenTypes.DOC_COMMENT) {
            ASTNode treePrev = child.getTreePrev();
            if (treePrev != null && treePrev.getPsi() instanceof PsiWhiteSpace && treePrev.textContains('\n')) {
                return Indent.getSpaceIndent((int)1);
            }
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.CONDITIONAL_EXPRESSION && child != node.getFirstChildNode()) {
            return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
        }
        IElementType childElementType = child.getElementType();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentNodeType = parentNode != null ? parentNode.getElementType() : null;
        if (childElementType == JSTokenTypes.END_OF_LINE_COMMENT && (prevNode = child.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace && prevNode.getText().endsWith("\n") && this.mySettings.KEEP_FIRST_COLUMN_COMMENT) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.RETURN_STATEMENT) {
            if (node.getFirstChildNode() == child) {
                return Indent.getNoneIndent();
            }
            boolean enforceIndent = childElementType == JSElementTypes.BINARY_EXPRESSION;
            return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)enforceIndent);
        }
        if (nodeElementType == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.DESTRUCTURING_OBJECT && (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == ES6ElementTypes.CLASS && (childElementType == JSElementTypes.CALL_SIGNATURE || childElementType == JSElementTypes.FUNCTION_SIGNATURE || childElementType == TypeScriptElementTypes.PROPERTY_SIGNATURE)) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || nodeElementType == TypeScriptElementTypes.OBJECT_TYPE || IMPORT_EXPORT_DECLARATION.contains(nodeElementType)) {
            if (childElementType == JSTokenTypes.RBRACE || childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.IMPORT_KEYWORD || childElementType == JSTokenTypes.EXPORT_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSTokenTypes.COMMA) {
                return this.getCommaIndent(Indent.Type.NORMAL);
            }
            return Indent.getNormalIndent();
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(childElementType) && nodeElementType == JSElementTypes.ARGUMENT_LIST) {
            return sharedSmartIndent;
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(nodeElementType) && parentNodeType == JSElementTypes.ARGUMENT_LIST) {
            if (childElementType == JSTokenTypes.FUNCTION_KEYWORD || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            ASTNode next = TreeUtil.skipElements((ASTNode)child.getTreeNext(), (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.WHITE_SPACE}));
            if (next != null && next.getElementType() == JSTokenTypes.EQGT) {
                return Indent.getNoneIndent();
            }
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(parentNodeType) && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType)) {
            if (childElementType == JSTokenTypes.RBRACE || childElementType == JSTokenTypes.LBRACE) {
                return Indent.getNoneIndent();
            }
            if (this.mySettings.BRACE_STYLE == 3) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType) && !JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
            return Indent.getNoneIndent();
        }
        if (JSElementTypes.PARAMETER_LISTS.contains(nodeElementType)) {
            if (childElementType == JSTokenTypes.RPAR || node.getFirstChildNode() == child) {
                return Indent.getNoneIndent();
            }
            return Indent.getContinuationIndent();
        }
        if (nodeElementType == JSElementTypes.ARGUMENT_LIST) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSElementTypes.BINARY_EXPRESSION) {
                return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            }
            return sharedSmartIndent;
        }
        if (nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT && !JSSpacingProcessor.NOT_A_PACKAGE_CONTENT.contains(childElementType)) {
            if (this.myJSCodeStyleSettings.INDENT_PACKAGE_CHILDREN == 1) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.ATTRIBUTE_LIST || childElementType == JSStubElementTypes.ATTRIBUTE_LIST) {
            return Indent.getNoneIndent();
        }
        if ((nodeElementType instanceof JSPropertyElementType || nodeElementType == ES6ElementTypes.FUNCTION_PROPERTY) && (child == ((JSProperty)node.getPsi()).getNameIdentifier() || JSTokenTypes.COMMENTS.contains(childElementType) || child.getPsi() instanceof JSReferenceExpression)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == ES6ElementTypes.SPREAD_PROPERTY && childElementType == JSTokenTypes.DOT_DOT_DOT) {
            return Indent.getNoneIndent();
        }
        if (JSElementTypes.VAR_STATEMENTS.contains(nodeElementType)) {
            if (JSTokenTypes.VAR_MODIFIERS.contains(childElementType) || SubBlockVisitor.isStatementLevelComment(child) || childElementType == JSTokenTypes.SEMICOLON) {
                return Indent.getNoneIndent();
            }
            if (JSElementTypes.BODY_VARIABLES.contains(childElementType)) {
                IElementType prevElementType;
                ASTNode prev = child.getTreePrev();
                IElementType iElementType2 = prevElementType = prev != null ? prev.getElementType() : null;
                if (prev == null || parentNodeType instanceof JSClassElementTypeBase && !JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(this.myDialect) || prevElementType == JSStubElementTypes.ATTRIBUTE_LIST || JSTokenTypes.VAR_MODIFIERS.contains(prevElementType) || parentNodeType == JSStubElementTypes.TYPESCRIPT_ENUM) {
                    return Indent.getNoneIndent();
                }
            }
            if (childElementType == JSTokenTypes.COMMA) {
                return this.getCommaIndent(Indent.Type.CONTINUATION);
            }
            return sharedSmartIndent;
        }
        if (JSElementTypes.BODY_VARIABLES.contains(nodeElementType)) {
            if (childElementType == JSTokenTypes.IDENTIFIER) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSElementTypes.BINARY_EXPRESSION) {
                return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            }
        }
        if (JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType) && childElementType == JSTokenTypes.FUNCTION_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
            if (JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType) && (this.mySettings.METHOD_BRACE_STYLE == 3 || this.mySettings.METHOD_BRACE_STYLE == 4)) {
                return Indent.getNormalIndent();
            }
            if (this.mySettings.BRACE_STYLE == 3 || this.mySettings.BRACE_STYLE == 4) {
                return Indent.getNormalIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM || nodeElementType == JSStubElementTypes.TYPESCRIPT_MODULE) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (childElementType == JSElementTypes.CATCH_BLOCK) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(childElementType)) {
            return this.mySettings.INDENT_CASE_FROM_SWITCH ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(nodeElementType)) {
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(childElementType) || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.SWITCH_STATEMENT && (childElementType == JSTokenTypes.RBRACE || childElementType == JSTokenTypes.LBRACE)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.IF_STATEMENT) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.IF_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR)) {
                return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            }
            if (childElementType == JSTokenTypes.ELSE_KEYWORD || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSElementTypes.IF_STATEMENT && this.mySettings.SPECIAL_ELSE_IF_TREATMENT && ((JSIfStatement)node.getPsi()).getElse() == child.getPsi()) {
                return Indent.getNoneIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType)) {
                return Indent.getNormalIndent();
            }
        }
        if (nodeElementType == JSElementTypes.FOR_STATEMENT) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.FOR_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (node.getLastChildNode() == child) {
                return JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType) ? Indent.getNoneIndent() : Indent.getNormalIndent();
            }
            return Indent.getContinuationIndent();
        }
        if (nodeElementType == JSElementTypes.WITH_STATEMENT && JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType)) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.DOWHILE_STATEMENT && childElementType == JSTokenTypes.WHILE_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.TRY_STATEMENT && childElementType == JSTokenTypes.FINALLY_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT || nodeElementType == JSStubElementTypes.TYPESCRIPT_MODULE || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM || nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE) {
            ASTNode parent = node.getTreeParent();
            if (parent != null && JSElementTypes.FUNCTION_DECLARATIONS.contains(parent.getElementType()) && this.mySettings.METHOD_BRACE_STYLE == 3) {
                return Indent.getNoneIndent();
            }
            if (this.mySettings.BRACE_STYLE == 3) {
                return Indent.getNoneIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType) || JSTokenTypes.COMMENTS.contains(childElementType) && (childElementType != JSTokenTypes.DOC_COMMENT || node.getFirstChildNode() != child)) {
                return Indent.getNormalIndent();
            }
            if (child instanceof OuterLanguageElement) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (node.getPsi() instanceof JSLoopStatement && child.getPsi() == ((JSLoopStatement)node.getPsi()).getBody()) {
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION || nodeElementType == JSStubElementTypes.DESTRUCTURING_ARRAY) {
            if (childElementType == JSTokenTypes.LBRACKET || childElementType == JSTokenTypes.RBRACKET) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            if (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.EMBEDDED_EXPRESSION) {
            if (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
            if (childElementType == JSElementTypes.BINARY_EXPRESSION) {
                return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            }
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (nodeElementType == JSElementTypes.EXPRESSION_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            ASTNode prev;
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR) {
                return Indent.getNoneIndent();
            }
            ASTNode lastChild = node.getLastChildNode();
            if (lastChild != null && lastChild.getElementType() == JSTokenTypes.RPAR && (prev = lastChild.getTreePrev()) != null && prev.getPsi() instanceof PsiWhiteSpace && prev.textContains('\n')) {
                return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            }
        }
        if (nodeElementType == JSElementTypes.BINARY_EXPRESSION && childElementType != JSElementTypes.BINARY_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        if (childElementType == JSTokenTypes.GET_KEYWORD || childElementType == JSTokenTypes.SET_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (childElementType == JSElementTypes.ARGUMENT_LIST || childElementType == JSElementTypes.BINARY_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    private static boolean isStatementLevelComment(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor", "isStatementLevelComment"));
        }
        if (JSTokenTypes.COMMENTS.contains(child.getElementType())) {
            ASTNode parent = child.getTreeParent();
            return parent == null || parent.getFirstChildNode() == child;
        }
        return false;
    }

    @Nullable
    protected Wrap getWrap(ASTNode node, ASTNode child) {
        WrapType wrapType = null;
        IElementType nodeElementType = node.getElementType();
        if (child.getElementType() == JSTokenTypes.COMMA && !this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE) {
            wrapType = WrapType.NONE;
        } else if (nodeElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)node.getPsi();
            if (child.getElementType() == assignment.getOperationSign() && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE || child.getPsi() == assignment.getROperand() && !this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                wrapType = WrappingUtil.getWrapType((int)this.mySettings.ASSIGNMENT_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.BINARY_EXPRESSION) {
            JSBinaryExpression binary = (JSBinaryExpression)node.getPsi();
            if (child.getElementType() == binary.getOperationSign() && this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE || child.getPsi() == binary.getROperand() && !this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return this.getCurrentWrap(this.mySettings.BINARY_OPERATION_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR)) {
                wrapType = this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP ? WrapType.ALWAYS : WrapType.NONE;
            } else if (child == node.findChildByType(JSTokenTypes.RPAR)) {
                wrapType = this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP ? WrapType.ALWAYS : WrapType.NONE;
            }
        } else if (nodeElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            IElementType childType = child.getElementType();
            if (childType != JSTokenTypes.LBRACKET && childType != JSTokenTypes.RBRACKET && !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LBRACKET)) {
                return this.getCurrentWrap(this.getArrayInitializerWrap());
            }
        } else if (nodeElementType == JSElementTypes.CONDITIONAL_EXPRESSION) {
            IElementType elementType = child.getElementType();
            if (this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE) {
                if (elementType == JSTokenTypes.QUEST || elementType == JSTokenTypes.COLON) {
                    return this.getCurrentWrap(this.mySettings.TERNARY_OPERATION_WRAP);
                }
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
            }
            if (child.getPsi() instanceof JSExpression && node.getFirstChildNode() != child) {
                return this.getCurrentWrap(this.mySettings.TERNARY_OPERATION_WRAP);
            }
        } else if (JSElementTypes.PARAMETER_LISTS.contains(nodeElementType) && WrappingUtil.shouldWrap((int)this.mySettings.METHOD_PARAMETERS_WRAP)) {
            if (!this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE ? !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR) && child.getElementType() != JSTokenTypes.LPAR && child.getElementType() != JSTokenTypes.RPAR : child.getElementType() == JSTokenTypes.COMMA) {
                return this.getCurrentWrap(this.mySettings.METHOD_PARAMETERS_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.FOR_STATEMENT || nodeElementType == JSElementTypes.FOR_IN_STATEMENT) {
            if (!FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR) && JSElementTypes.EXPRESSIONS.contains(child.getElementType())) {
                return this.getCurrentWrap(this.mySettings.FOR_STATEMENT_WRAP);
            }
        } else if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION && this.hasWrapInBraces(child, JSExtendedLanguagesTokenSetProvider.PROPERTIES)) {
            return this.getCurrentWrap(this.myJSCodeStyleSettings.OBJECT_LITERAL_WRAP);
        }
        if ((nodeElementType == ES6ElementTypes.IMPORT_DECLARATION || nodeElementType == ES6ElementTypes.EXPORT_DECLARATION) && this.hasWrapInBraces(child, IMPORT_EXPORT_SPECIFIERS)) {
            return this.getCurrentWrap(this.myJSCodeStyleSettings.IMPORTS_WRAP);
        }
        return wrapType == null ? null : Wrap.createWrap((WrapType)wrapType, (boolean)true);
    }

    private boolean hasWrapInBraces(ASTNode child, TokenSet properties) {
        return !this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE ? !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LBRACE) && properties.contains(child.getElementType()) : child.getElementType() == JSTokenTypes.COMMA;
    }

    @Nullable
    private Wrap createChildWrap(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor", "createChildWrap"));
        }
        IElementType nodeType = node.getElementType();
        Wrap currentWrap = this.getCurrentWrap(4);
        if (this.checkShouldWrapEveryItem(nodeType)) {
            return currentWrap;
        }
        return null;
    }

    protected boolean checkShouldWrapEveryItem(IElementType nodeType) {
        return SubBlockVisitor.shouldWrapEveryItem(nodeType, JSElementTypes.BINARY_EXPRESSION, this.mySettings.BINARY_OPERATION_WRAP) || SubBlockVisitor.shouldWrapEveryItem(nodeType, JSElementTypes.ARRAY_LITERAL_EXPRESSION, this.mySettings.ARRAY_INITIALIZER_WRAP) || SubBlockVisitor.shouldWrapEveryItem(nodeType, JSStubElementTypes.PARAMETER_LIST, this.mySettings.METHOD_PARAMETERS_WRAP) || SubBlockVisitor.shouldWrapEveryItem(nodeType, JSElementTypes.FOR_STATEMENT, this.mySettings.FOR_STATEMENT_WRAP) || SubBlockVisitor.shouldWrapEveryItem(nodeType, JSElementTypes.CONDITIONAL_EXPRESSION, this.mySettings.TERNARY_OPERATION_WRAP) || SubBlockVisitor.shouldWrapEveryItem(nodeType, JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, this.myJSCodeStyleSettings.OBJECT_LITERAL_WRAP) || SubBlockVisitor.shouldWrapEveryItem(nodeType, (IElementType)ES6ElementTypes.IMPORT_DECLARATION, this.myJSCodeStyleSettings.IMPORTS_WRAP) || SubBlockVisitor.shouldWrapEveryItem(nodeType, (IElementType)ES6ElementTypes.EXPORT_DECLARATION, this.myJSCodeStyleSettings.IMPORTS_WRAP);
    }

    private Wrap getCurrentWrap(int type) {
        Wrap blockWrap;
        Wrap wrap = blockWrap = this.myBlock != null ? this.myBlock.getChildWrap() : null;
        if (blockWrap != null) {
            return blockWrap;
        }
        return Wrap.createWrap((int)type, (boolean)true);
    }

    protected static boolean shouldWrapEveryItem(IElementType nodeType, IElementType expectedType, int wrapType) {
        return nodeType == expectedType && (wrapType & 4) != 0;
    }

    private Indent getCommaIndent(Indent.Type baseType) {
        int indentSize;
        int commaIndentSize;
        CommonCodeStyleSettings.IndentOptions indentOptions;
        if (this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE && (baseType == Indent.Type.CONTINUATION || baseType == Indent.Type.NORMAL) && (indentOptions = this.mySettings.getIndentOptions()) != null && (commaIndentSize = (indentSize = baseType == Indent.Type.CONTINUATION ? indentOptions.CONTINUATION_INDENT_SIZE : indentOptions.INDENT_SIZE) - (this.mySettings.SPACE_AFTER_COMMA ? 1 : 0) - 1) >= 0) {
            return Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)commaIndentSize, (boolean)false, (boolean)false);
        }
        return Indent.getIndent((Indent.Type)baseType, (boolean)false, (boolean)false);
    }

    private int getArrayInitializerWrap() {
        return this.mySettings.ARRAY_INITIALIZER_WRAP;
    }

    private class JSXmlBlock
    extends XmlBlock {
        private final Wrap myWrap;
        private final Alignment myAlignment;
        private final Indent myIndent;

        public JSXmlBlock(ASTNode child, Wrap wrap, Alignment alignment, Indent indent, XmlFormattingPolicy policy, boolean preserveSpace) {
            super(child, wrap, alignment, policy, indent, null, preserveSpace);
            this.myWrap = wrap;
            this.myAlignment = alignment;
            this.myIndent = indent;
        }

        protected List<Block> splitAttribute(ASTNode node, XmlFormattingPolicy formattingPolicy) {
            ASTNode child = node.getFirstChildNode();
            if (child.getElementType() == JSTokenTypes.XML_JS_SCRIPT) {
                JavascriptFormattingModelBuilder builder = (JavascriptFormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(SubBlockVisitor.this.myDialect);
                XmlFormattingPolicy policy = SubBlockVisitor.this.myBlock != null ? SubBlockVisitor.this.myBlock.getPolicy() : null;
                JSBlock block = builder.createSubBlock(child, this.myAlignment, this.myIndent, this.myWrap, SubBlockVisitor.this.myTopSettings, SubBlockVisitor.this.myDialect, SubBlockVisitor.this.myAlignmentFactory.getSharedAlignmentFactory(), SubBlockVisitor.this.myJSCodeStyleSettings);
                block.setChildWrap(SubBlockVisitor.this.createChildWrap(child));
                block.setPolicy(policy);
                return Collections.singletonList(block);
            }
            return super.splitAttribute(node, formattingPolicy);
        }

        protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            return new JSXmlBlock(child, wrap, alignment, indent, this.myXmlFormattingPolicy, this.isPreserveSpace());
        }
    }

    private class JSXmlTagBlock
    extends XmlTagBlock {
        public JSXmlTagBlock(ASTNode child, Wrap wrap, Alignment childAlignment, XmlFormattingPolicy policy, Indent childIndent) {
            super(child, wrap, childAlignment, policy, childIndent);
        }

        public JSXmlTagBlock(ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, boolean space) {
            super(child, wrap, alignment, policy, indent, space);
        }

        protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            return new JSXmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
        }

        protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            return new JSXmlBlock(child, wrap, alignment, indent, this.myXmlFormattingPolicy, this.isPreserveSpace());
        }

        protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
            IElementType type = childPsi.getNode().getElementType();
            if (type == JSTokenTypes.XML_JS_SCRIPT || type == JSTokenTypes.NON_CHAMELEON_XML_JS_SCRIPT) {
                return false;
            }
            if (childPsi instanceof XmlElement) {
                return true;
            }
            return super.useMyFormatter(myLanguage, childLanguage, childPsi);
        }

        protected Alignment chooseAlignment(ASTNode child, Alignment attrAlignment, Alignment textAlignment) {
            ASTNode startEnd;
            if (child.getElementType() == JSTokenTypes.XML_JS_SCRIPT && child.getTreeParent().getElementType() == JSElementTypes.XML_LITERAL_EXPRESSION && ((startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(child.getTreeParent())) == null || startEnd.getStartOffset() >= child.getTextRange().getEndOffset())) {
                Alignment alignment = this.myXmlFormattingPolicy.getShouldAlignAttributes() ? attrAlignment : null;
                child.putUserData(JavascriptFormattingModelBuilder.BLOCK_ALIGNMENT, (Object)alignment);
                return alignment;
            }
            return super.chooseAlignment(child, attrAlignment, textAlignment);
        }
    }
}

