/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public abstract class JSAbstractPropertyAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private Alignment myCurrPropertyAlignment;

    protected abstract Alignment getParentLiteralAlignment();

    protected abstract int getAlignObjectProperties();

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSAbstractPropertyAlignmentFactory", "getAlignment"));
        }
        if (this.getAlignObjectProperties() != 0) {
            IElementType childType = child.getElementType();
            ASTNode parent = child.getTreeParent();
            if (parent != null) {
                IElementType parentType;
                if (parent.getElementType() instanceof JSPropertyElementType || parent.getElementType() == ES6ElementTypes.PROPERTY) {
                    if (JSAbstractPropertyAlignmentFactory.shouldRestartAlignment(parent, child)) {
                        this.createPropertyAlignment();
                    }
                    if (this.getAlignObjectProperties() == 2 && childType == JSTokenTypes.COLON) {
                        return this.myCurrPropertyAlignment;
                    }
                    if (this.getAlignObjectProperties() == 1 && child == parent.getLastChildNode() && child != parent.getFirstChildNode()) {
                        return this.myCurrPropertyAlignment;
                    }
                }
                IElementType iElementType = parentType = (parent = child.getTreeParent()) != null ? parent.getElementType() : null;
                if (parentType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACE || parentType == JSElementTypes.ARRAY_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACKET) {
                    return this.getParentLiteralAlignment();
                }
            }
        }
        return null;
    }

    protected void createPropertyAlignment() {
        this.myCurrPropertyAlignment = Alignment.createAlignment((boolean)true);
    }

    private static boolean shouldRestartAlignment(@NotNull ASTNode property, @NotNull ASTNode child) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/formatter/blocks/alignment/JSAbstractPropertyAlignmentFactory", "shouldRestartAlignment"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSAbstractPropertyAlignmentFactory", "shouldRestartAlignment"));
        }
        if (property.getTextRange().getStartOffset() != child.getTextRange().getStartOffset()) {
            return false;
        }
        for (ASTNode beforeProperty = property.getTreePrev(); beforeProperty != null; beforeProperty = beforeProperty.getTreePrev()) {
            int lineBreaks;
            if (beforeProperty.getElementType() instanceof JSPropertyElementType) {
                return false;
            }
            if (!(beforeProperty.getPsi() instanceof PsiWhiteSpace) || (lineBreaks = StringUtil.getLineBreakCount((CharSequence)beforeProperty.getText())) <= 1) continue;
            return true;
        }
        return false;
    }
}

