/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.amd.JSCommonReferenceContributor;
import com.intellij.lang.javascript.frameworks.amd.JSNonFileAmdModuleReference;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.BasicJavascriptNamesValidator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JSAmdReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                String methodName;
                PsiElement psiElement = (PsiElement)element;
                PsiElement parent = psiElement.getParent();
                if (!(parent instanceof JSArrayLiteralExpression)) {
                    return false;
                }
                JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(parent.getParent());
                return methodExpression != null && ("define".equals(methodName = methodExpression.getReferenceName()) || "require".equals(methodName)) && methodExpression.getQualifier() == null;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$1", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$1", "getReferencesByElement"));
                }
                String text = StringUtil.unquoteString((String)psiElement.getText());
                if (text.startsWith("http:") || text.startsWith("https:") || text.startsWith("//")) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                int offset = 1;
                int i = text.indexOf(33);
                if (i != -1) {
                    if ("text".regionMatches(0, text, 0, i)) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$1", "getReferencesByElement"));
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    text = text.substring(i + 1);
                    offset += i + 1;
                }
                if ((i = text.indexOf(63)) != -1) {
                    text = text.substring(i + 1);
                    offset += i + 1;
                }
                if ((i = text.lastIndexOf(33)) != -1) {
                    text = text.substring(0, i);
                }
                if ("require".equals(text) || "exports".equals(text) || "module".equals(text)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] result = JSCommonReferenceContributor.INSTANCE.getAllReferences(text, psiElement, offset, this);
                if (BasicJavascriptNamesValidator.isProperty(text)) {
                    PsiReference[] merged = new PsiReference[result.length + 1];
                    System.arraycopy(result, 0, merged, 0, result.length);
                    merged[merged.length - 1] = new JSNonFileAmdModuleReference((JSLiteralExpression)psiElement);
                    result = merged;
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$1", "getReferencesByElement"));
                }
                return result;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                PsiElement psiElement = (PsiElement)element;
                PsiElement parent = psiElement.getParent();
                if (!(parent instanceof JSProperty)) {
                    return false;
                }
                if (!((parent = parent.getParent().getParent()) instanceof JSProperty) || !"paths".equals(((JSProperty)parent).getName())) {
                    return false;
                }
                if (!((parent = parent.getParent().getParent()) instanceof JSArgumentList)) {
                    return false;
                }
                if (!((parent = parent.getParent()) instanceof JSCallExpression)) {
                    return false;
                }
                JSExpression methodExpression = ((JSCallExpression)parent).getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && "config".equals(((JSReferenceExpression)methodExpression).getReferencedName())) {
                    JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                    return qualifier instanceof JSReferenceExpression && "require".equals(((JSReferenceExpression)qualifier).getReferencedName()) && ((JSReferenceExpression)qualifier).getQualifier() == null;
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$3", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$3", "getReferencesByElement"));
                }
                String text = psiElement.getText();
                FileReference[] fileReferenceArray = new FileReferenceSet(StringUtil.unquoteString((String)text), psiElement, 1, this, false, true, DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY){

                    public FileReference createFileReference(TextRange range, int index, String text) {
                        return new JSFileReference(text, index, range, this);
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdReferenceContributor$3", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
        });
    }
}

