/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.MethodHierarchyBrowserBase;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyBrowser;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSMethodHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyProvider", "getTarget"));
        }
        JSPsiElementBase method = JSHierarchyUtils.getJSFunction(dataContext);
        if (!(method instanceof JSFunction)) {
            return null;
        }
        JSClass parentClass = JSResolveUtil.getClassOfContext((PsiElement)method);
        if (parentClass == null) {
            return null;
        }
        return JSInheritanceUtil.canHaveSuperMethod((JSFunction)method) || JSInheritanceUtil.canBeSuperMethod((JSFunction)method) ? method : null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        JSMethodHierarchyBrowser jSMethodHierarchyBrowser = new JSMethodHierarchyBrowser(target.getProject(), target);
        if (jSMethodHierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyProvider", "createHierarchyBrowser"));
        }
        return jSMethodHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyProvider", "browserActivated"));
        }
        ((JSMethodHierarchyBrowser)hierarchyBrowser).changeView(MethodHierarchyBrowserBase.METHOD_TYPE);
    }
}

