/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;

public class JavaScriptPsiTreeChangePreprocessor
extends PsiTreeChangePreprocessorBase {
    public JavaScriptPsiTreeChangePreprocessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/index/JavaScriptPsiTreeChangePreprocessor", "<init>"));
        }
        super(project);
    }

    protected boolean isInsideCodeBlock(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return false;
        }
        if (element == null || !element.isValid() || element.getParent() == null) {
            return true;
        }
        while (!(element instanceof JSFile) && !(element instanceof JSClass)) {
            if (element instanceof XmlAttribute || element instanceof XmlText) {
                PsiFile containingFile = element.getContainingFile();
                return !(containingFile instanceof XmlFile) || !JavaScriptSupportLoader.isFlexMxmFile(containingFile);
            }
            if (element instanceof PsiFile || element instanceof PsiDirectory || element instanceof JSBlockStatement || element == null) {
                return true;
            }
            PsiElement pparent = element.getParent();
            if (pparent instanceof JSNamedElement) {
                JSFunction function;
                JSNamedElement namedElement = (JSNamedElement)pparent;
                if (namedElement instanceof JSFunction && ((function = (JSFunction)namedElement).getParameterList() == element || function.getReturnTypeElement() == element)) {
                    return false;
                }
                return element != namedElement.getNameIdentifier() && !(element instanceof JSReferenceList);
            }
            element = pparent;
        }
        return false;
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/index/JavaScriptPsiTreeChangePreprocessor", "treeChanged"));
        }
        if (!(event.getFile() instanceof JSFile) && !(event.getFile() instanceof XmlFile)) {
            return;
        }
        super.treeChanged(event);
    }
}

