/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AssignParameterToFieldAction
extends FixAndIntentionAction {
    public static final String VAR_NAME = "__var_name";
    private final FixAndIntentionAction myAction;
    private final String myFieldName;
    private final String myName;
    private final String myClassName;

    public AssignParameterToFieldAction(FixAndIntentionAction action, String fieldName, String name, String className) {
        this.myAction = action;
        this.myFieldName = fieldName;
        this.myName = name;
        this.myClassName = className;
    }

    @NotNull
    public String getName() {
        String string = this.myAction != null ? this.myAction.getName() : JSBundle.message((String)"javascript.assign.parameter.to.field.intention.name", (Object[])new Object[]{this.myName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/AssignParameterToFieldAction", "getName"));
        }
        return string;
    }

    @Override
    protected void applyFix(final Project project, PsiElement psiElement, PsiFile file, final Editor editor) {
        int ourParameterIndex;
        JSFunction fun;
        if (file == null) {
            file = psiElement.getContainingFile();
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSFunction.class)) == null) {
            return;
        }
        JSSourceElement[] body = fun.getBody();
        if (body.length == 0 || !(body[0] instanceof JSBlockStatement)) {
            return;
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)fun);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        PsiElement firstChild = body[0].getFirstChild();
        List<JSParameter> parameters = Arrays.asList(fun.getParameterVariables());
        if ((firstChild = JSFormatUtil.findInsertionPlaceStartingFrom(firstChild, true, (Function<PsiElement, Boolean>)((Function)arg_0 -> AssignParameterToFieldAction.lambda$applyFix$0(parameters, ourParameterIndex = parameters.indexOf(psiElement.getParent()), arg_0)))) == null) {
            firstChild = body[0].getLastChild();
        }
        int offset = firstChild.getTextRange().getStartOffset();
        boolean staticContext = JSResolveUtil.calculateStaticFromContext(psiElement);
        if (isTypeScript || this.myFieldName.equals(this.myName) || staticContext) {
            String res = staticContext ? this.myClassName + "." : "this.";
            template.addTextSegment(res);
            BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression(this.myFieldName);
            template.addVariable(VAR_NAME, (Expression)expression, (Expression)expression, true);
        } else {
            template.addTextSegment(this.myFieldName);
        }
        template.addTextSegment(" = " + this.myName + JSCodeStyleSettings.getSemicolon(file));
        template.addEndVariable();
        final PsiFile finalFile = file;
        editor.getCaretModel().moveToOffset(offset);
        template.setToReformat(true);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){
            String newFieldName;
            {
                this.newFieldName = AssignParameterToFieldAction.this.myFieldName;
            }

            public void beforeTemplateFinished(TemplateState state, Template template) {
                TextResult variableValue = state.getVariableValue(AssignParameterToFieldAction.VAR_NAME);
                if (variableValue == null) {
                    return;
                }
                String fieldName = variableValue.getText();
                if (!((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)).isIdentifier(fieldName, project)) {
                    return;
                }
                this.newFieldName = fieldName;
            }

            public void templateFinished(Template template, boolean brokenOff) {
                if (AssignParameterToFieldAction.this.myAction != null) {
                    Runnable action = () -> {
                        FixAndIntentionAction createFieldFromParameterAction = JSFixFactory.getInstance().createFieldFromParameterAction(this.newFieldName);
                        createFieldFromParameterAction.sharePointer(AssignParameterToFieldAction.this.myAction);
                        createFieldFromParameterAction.invoke(project, editor, finalFile);
                    };
                    if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                        action.run();
                    } else {
                        ApplicationManager.getApplication().invokeLater(action, project.getDisposed());
                    }
                }
            }
        });
    }

    private static /* synthetic */ Boolean lambda$applyFix$0(List parameters, int ourParameterIndex, PsiElement psiElement1) {
        if (psiElement1 instanceof JSExpressionStatement) {
            int i;
            PsiElement resolve;
            JSExpression rOperand;
            JSExpression expression = ((JSExpressionStatement)psiElement1).getExpression();
            if (expression instanceof JSCallExpression && ((JSCallExpression)expression).getMethodExpression() instanceof JSSuperExpression) {
                return Boolean.TRUE;
            }
            if (expression instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)expression).getROperand()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSParameter && (i = parameters.indexOf((JSParameter)resolve)) != -1 && i < ourParameterIndex) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

