/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.ES6ConvertForInToForOfQuickFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSConvertToForEachIntention;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertToForOfInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSForInStatement(JSForInStatement node) {
                if (node.isForEach()) {
                    return;
                }
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                String varName = (String)JSConvertToForEachIntention.getForInVarName(node).getFirst();
                if (varName == null) {
                    return;
                }
                JSExpression collectionExpression = node.getCollectionExpression();
                JSExpression array = null;
                if (collectionExpression instanceof JSReferenceExpression) {
                    PsiElement resolve = ((JSReferenceExpression)collectionExpression).resolve();
                    if (resolve != null && resolve.isValid() && resolve instanceof JSNamedElement) {
                        array = resolve;
                    }
                } else {
                    array = collectionExpression;
                }
                if (array == null) {
                    return;
                }
                JSTypeEvaluationResult type = JSTypeEvaluator.getElementType((PsiElement)array);
                if (type == null || type.getType() == null || !JSTypeUtils.isIterableCollectionType(type.getType())) {
                    return;
                }
                Object[] nodes = node.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FOR_KEYWORD, JSTokenTypes.IN_KEYWORD}));
                Collection<Object> anchors = nodes.length == 0 ? Collections.singleton(node) : ContainerUtil.map((Object[])nodes, n -> n.getPsi());
                ES6ConvertForInToForOfQuickFix fix = new ES6ConvertForInToForOfQuickFix(node);
                for (PsiElement psiElement : anchors) {
                    holder.registerProblem(psiElement, JSBundle.message((String)"js.convert.for.in.to.for.of.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{fix});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertToForOfInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

