/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.JSGroupNames;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityComparisonWithCoercionJSInspection
extends JSInspection {
    public Severity mySeverity;

    public EqualityComparisonWithCoercionJSInspection(Severity severity) {
        this.mySeverity = severity;
    }

    public EqualityComparisonWithCoercionJSInspection() {
        this.mySeverity = Severity.Always;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection$1", "visitJSBinaryExpression"));
                }
                super.visitJSBinaryExpression(expression);
                IElementType signTokenType = expression.getOperationSign();
                if (!JSTokenTypes.EQEQ.equals(signTokenType) && !JSTokenTypes.NE.equals(signTokenType)) {
                    return;
                }
                if (EqualityComparisonWithCoercionJSInspection.this.needToHighlight(expression)) {
                    IElementType newSign = signTokenType == JSTokenTypes.EQEQ ? JSTokenTypes.EQEQEQ : JSTokenTypes.NEQEQ;
                    String newSignText = signTokenType == JSTokenTypes.EQEQ ? "===" : "!==";
                    holder.registerProblem((PsiElement)expression, JSBundle.message((String)"javascript.equality.comparison.with.coercion.error.string", (Object[])new Object[0]), new LocalQuickFix[]{new MyQuickfix(newSign, newSignText)});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private boolean needToHighlight(@NotNull JSBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection", "needToHighlight"));
        }
        JSExpression lhs = JSUtils.unparenthesize(expression.getLOperand());
        JSExpression rhs = JSUtils.unparenthesize(expression.getROperand());
        switch (this.mySeverity) {
            case Always: {
                return true;
            }
            case AlwaysExceptNull: {
                return !EqualityComparisonWithCoercionJSInspection.isNull(lhs) && !EqualityComparisonWithCoercionJSInspection.isNull(rhs);
            }
            case OnlySuspicious: {
                return EqualityComparisonWithCoercionJSInspection.mayCauseCoercion(rhs) || EqualityComparisonWithCoercionJSInspection.mayCauseCoercion(lhs);
            }
        }
        throw new AssertionError((Object)String.format("%s was out of range of expected values", new Object[]{this.mySeverity}));
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 5, true, false));
        JLabel label = new JLabel(JSBundle.message((String)"javascript.equality.comparison.with.coercion.options.label", (Object[])new Object[0]));
        ComboBox severityCombobox = new ComboBox((Object[])Severity.values());
        severityCombobox.setSelectedItem((Object)(this.mySeverity != null ? this.mySeverity : Severity.OnlySuspicious));
        severityCombobox.addActionListener(e -> {
            this.mySeverity = (Severity)((Object)((Object)severityCombobox.getSelectedItem()));
        });
        panel.add((Component)label, "West");
        panel.add((Component)severityCombobox, "West");
        return panel;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"javascript.equality.comparison.with.coercion.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    private static boolean isNull(@Nullable JSExpression expression) {
        return expression != null && expression instanceof JSLiteralExpression && "null".equals(expression.getText());
    }

    private static boolean mayCauseCoercion(@Nullable JSExpression expression) {
        if (expression == null || !(expression instanceof JSLiteralExpression)) {
            return false;
        }
        if (EqualityComparisonWithCoercionJSInspection.isNull(expression)) {
            return true;
        }
        String text = expression.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text) || "true".equals(text) || "false".equals(text) || "undefined".equals(text) || "''".equals(text);
    }

    public static enum Severity {
        Always(JSBundle.message((String)"javascript.equality.comparison.with.coercion.option.always", (Object[])new Object[0])),
        AlwaysExceptNull(JSBundle.message((String)"javascript.equality.comparison.with.coercion.option.always.except.null", (Object[])new Object[0])),
        OnlySuspicious(JSBundle.message((String)"javascript.equality.comparison.with.coercion.option.only.suspicious", (Object[])new Object[0]));

        public String myDescription;

        private Severity(String description) {
            this.myDescription = description;
        }

        public String toString() {
            return this.myDescription;
        }
    }

    private static class MyQuickfix
    implements LocalQuickFix {
        private IElementType signType;
        private final String signString;

        public MyQuickfix(IElementType signType, String signString) {
            this.signType = signType;
            this.signString = signString;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"javascript.equality.comparison.with.coercion.fix", (Object[])new Object[]{this.signString});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection$MyQuickfix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.equality.comparison.with.coercion.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection$MyQuickfix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection$MyQuickfix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/EqualityComparisonWithCoercionJSInspection$MyQuickfix", "applyFix"));
            }
            ASTNode expressionNode = descriptor.getPsiElement().getNode();
            ASTNode operatorNode = JSBinaryExpressionImpl.getOperationSignNode(expressionNode);
            LeafElement newChild = ASTFactory.leaf((IElementType)this.signType, (CharSequence)this.signString);
            CodeEditUtil.setNodeGenerated((ASTNode)newChild, (boolean)true);
            expressionNode.replaceChild(operatorNode, (ASTNode)newChild);
        }
    }
}

