/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileHeaderKeeper {
    private final PsiElement myTopElement;
    private PsiComment myKeptHeader;
    private final List<PsiWhiteSpace> myAfterSpaces;
    private NewLineEraser myEraser;

    public FileHeaderKeeper(PsiElement topElement) {
        this.myTopElement = topElement;
        this.myAfterSpaces = new ArrayList<PsiWhiteSpace>();
    }

    public void cutHeader() {
        PsiComment comment = (PsiComment)PsiTreeUtil.findChildOfType((PsiElement)this.myTopElement, PsiComment.class);
        if (comment != null) {
            if (comment.getPrevSibling() != null && FileHeaderKeeper.getPrevNotSpaceElement(comment.getPrevSibling()) != null) {
                return;
            }
            if (this.myTopElement.equals(comment.getParent()) || comment instanceof JSDocComment && comment.getParent() != null && this.myTopElement.equals(comment.getParent().getParent())) {
                this.myKeptHeader = (PsiComment)comment.copy();
                this.myEraser = new NewLineEraser((PsiElement)comment);
                PsiElement current = comment.getNextSibling();
                comment.delete();
                while (current instanceof PsiWhiteSpace) {
                    this.myAfterSpaces.add((PsiWhiteSpace)current.copy());
                    current = current.getNextSibling();
                    current.getPrevSibling().delete();
                }
            }
        }
    }

    public void returnHeader() {
        if (this.myKeptHeader != null) {
            assert (this.myEraser != null);
            PsiElement anchor = this.myTopElement.getFirstChild();
            anchor = anchor != null ? this.myTopElement.addBefore((PsiElement)this.myKeptHeader, anchor) : this.myTopElement.add((PsiElement)this.myKeptHeader);
            PsiElement newHeader = anchor;
            for (PsiWhiteSpace space : this.myAfterSpaces) {
                anchor = this.myTopElement.addAfter((PsiElement)space, anchor);
            }
            this.myEraser.process(newHeader);
        }
    }

    private static PsiElement getPrevNotSpaceElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/FileHeaderKeeper", "getPrevNotSpaceElement"));
        }
        for (PsiElement current = element; current != null; current = current.getPrevSibling()) {
            if (current instanceof PsiWhiteSpace) continue;
            return current;
        }
        return null;
    }
}

