/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSStringConcatenationToES6TemplateQuickFix;
import com.intellij.lang.javascript.intentions.ES6ConvertToTemplateStringHelper;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSStringConcatenationToES6TemplateHelper;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSStringConcatenationToES6TemplateInspection
extends JSInspection
implements ES6CoolRefactoring {
    public static final Key<Set<PsiElement>> KEY = Key.create((String)"JavaScript.String.Concat.To.Template.String");

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                this.installFix((JSExpression)node);
            }

            public void visitJSConditionalExpression(JSConditionalExpression node) {
                this.installFix((JSExpression)node);
            }

            private boolean installFix(JSExpression node) {
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return false;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)node, JSStringTemplateExpression.class) != null) {
                    return false;
                }
                HashSet<JSExpression> data = (HashSet<JSExpression>)session.getUserData(KEY);
                if (data == null) {
                    data = new HashSet<JSExpression>();
                    session.putUserData(KEY, data);
                }
                if (data.contains(node)) {
                    return false;
                }
                List<JSExpression> list = JSStringConcatenationToES6TemplateHelper.findExpressionsList((PsiElement)node);
                if (list == null) {
                    return false;
                }
                Collections.reverse(list);
                boolean found = false;
                for (JSExpression expression : list) {
                    if (data.contains(expression)) {
                        return false;
                    }
                    if (!found) {
                        ES6ConvertToTemplateStringHelper helper = new ES6ConvertToTemplateStringHelper(expression);
                        helper.process();
                        if (helper.isValid()) {
                            found = true;
                            holder.registerProblem((PsiElement)expression, JSBundle.message((String)"js.replace.string.concatenation.with.es6.template.inspection.name", (Object[])new Object[0]), new LocalQuickFix[]{new JSStringConcatenationToES6TemplateQuickFix(node)});
                        }
                    }
                    data.add(expression);
                }
                return found;
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

