/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class JSUndefinedPropertyAssignmentInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                JSReferenceExpression refExpr;
                JSExpression qualifier;
                DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
                JSExpression expression = node.getExpression();
                if (expression instanceof JSReferenceExpression && dialect != null && dialect.isJavaScript() && (qualifier = (refExpr = (JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) {
                    PsiElement resolve = ((JSReferenceExpression)qualifier).resolve();
                    PsiElement refExprResolve = refExpr.resolve();
                    if (resolve instanceof JSVariable && refExprResolve != null && refExprResolve == node) {
                        JSType type = JSTypeUtils.getValuableType(((JSVariable)resolve).getType());
                        String property = refExpr.getReferencedName();
                        if (!(JSTypeUtils.isNewPropertiesDefinitionAllowed(type) || type instanceof JSRecordType && ((JSRecordType)type).hasProperty(property))) {
                            PsiElement refName = refExpr.getReferenceNameElement();
                            holder.registerProblem((PsiElement)(refName == null ? node : refName), JSBundle.message((String)"js.undefined.property.assignment.inspection.message", (Object[])new Object[]{property, type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), new LocalQuickFix[0]);
                        }
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndefinedPropertyAssignmentInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.undefined.property.assignment.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUndefinedPropertyAssignmentInspection", "getDisplayName"));
        }
        return string;
    }
}

