/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTokenType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnterminatedStatementJSInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreSemicolonAtEndOfBlock = true;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        Visitor visitor = new Visitor(this.ignoreSemicolonAtEndOfBlock, holder);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection", "createVisitor"));
        }
        return visitor;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unterminated.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.STYLE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("unterminated.statement.ignore.atend.of.block", new Object[0]), (InspectionProfileEntry)this, "ignoreSemicolonAtEndOfBlock");
    }

    @Nullable
    private static PsiElement nextCodeLeaf(@NotNull JSStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection", "nextCodeLeaf"));
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)statement);
        while (nextLeaf != null && !UnterminatedStatementJSInspection.isJSCodeElement(nextLeaf)) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        return nextLeaf;
    }

    private static boolean isJSCodeElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection", "isJSCodeElement"));
        }
        return !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment);
    }

    private static class Visitor
    extends JSElementVisitor {
        private final boolean ignoreSemicolonAtEndOfBlock;
        private ProblemsHolder myProblemsHolder;

        public Visitor(boolean ignoreSemicolonAtEndOfBlock, ProblemsHolder problemsHolder) {
            this.ignoreSemicolonAtEndOfBlock = ignoreSemicolonAtEndOfBlock;
            this.myProblemsHolder = problemsHolder;
        }

        public void visitJSCallExpression(JSCallExpression node) {
            super.visitJSCallExpression(node);
            this.reportPossibleUnterminatedStatement((PsiElement)node.getMethodExpression(), (Condition<PsiElement>)((Condition)expression -> expression instanceof JSObjectLiteralExpression || expression instanceof JSFunctionExpression || expression instanceof JSLiteralExpression || expression instanceof JSArrayLiteralExpression));
        }

        public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
            super.visitJSIndexedPropertyAccessExpression(node);
            this.reportPossibleUnterminatedStatement((PsiElement)node.getQualifier(), (Condition<PsiElement>)((Condition)expression -> expression instanceof JSObjectLiteralExpression || expression instanceof JSFunctionExpression || expression instanceof JSLiteralExpression));
        }

        public void visitJSStatement(JSStatement node) {
            super.visitJSStatement(node);
            if (!JSUtils.isStatementUsuallyRequiringSemicolon(node) || node instanceof JSEmptyStatement) {
                return;
            }
            if (this.isTerminated(node) || node instanceof JSExpressionStatement && node.getContainingFile() instanceof JSExpressionCodeFragment) {
                return;
            }
            this.reportUnterminatedStatement(node);
        }

        public void visitJSStringTemplateExpression(JSStringTemplateExpression stringTemplateExpression) {
            super.visitJSStringTemplateExpression(stringTemplateExpression);
            PsiElement firstChild = stringTemplateExpression.getFirstChild();
            if (firstChild != null && firstChild.getNode().getElementType() != JSTokenTypes.BACKQUOTE) {
                this.reportPossibleUnterminatedStatement(firstChild, (Condition<PsiElement>)((Condition)__ -> true));
            }
        }

        private void reportPossibleUnterminatedStatement(@Nullable PsiElement target, Condition<PsiElement> isSuspiciousType) {
            if (target == null || !isSuspiciousType.value((Object)target)) {
                return;
            }
            PsiElement leaf = PsiTreeUtil.nextLeaf((PsiElement)target);
            while (leaf != null && !UnterminatedStatementJSInspection.isJSCodeElement(leaf)) {
                if (leaf.textContains('\n')) {
                    String message = InspectionJSBundle.message("unterminated.statement.possibly.unterminated.statement.error", new Object[0]);
                    TerminateStatementFix fix = new TerminateStatementFix(target);
                    ProblemDescriptor problemDescriptor = this.createProblemDescriptorAfter(target, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                    this.myProblemsHolder.registerProblem(problemDescriptor);
                    break;
                }
                leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
            }
        }

        protected void reportUnterminatedStatement(JSStatement statement) {
            PsiFile file = statement.getContainingFile();
            PsiElement context = file.getContext();
            if (context != null && !context.textContains('\n')) {
                return;
            }
            TerminateStatementFix fix = new TerminateStatementFix((PsiElement)statement);
            ProblemDescriptor problemDescriptor = this.createProblemDescriptorAfter((PsiElement)statement, InspectionJSBundle.message("unterminated.statement.error.string", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            this.myProblemsHolder.registerProblem(problemDescriptor);
        }

        private boolean isTerminated(@NotNull JSStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$Visitor", "isTerminated"));
            }
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)statement);
            if (dialect == null || !JSInheritedLanguagesHelper.isNeedToBeTerminated((PsiElement)statement)) {
                return true;
            }
            JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)statement);
            if (!codeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT) {
                return true;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof JSForInStatement || parent instanceof JSForStatement) {
                return true;
            }
            String text = statement.getText();
            if (text == null) {
                return true;
            }
            boolean terminated = text.endsWith(";");
            if (!terminated) {
                PsiElement nextLeaf = UnterminatedStatementJSInspection.nextCodeLeaf(statement);
                if (nextLeaf != null) {
                    IElementType type;
                    ASTNode nextLeafNode = nextLeaf.getNode();
                    IElementType iElementType = type = nextLeafNode != null ? nextLeafNode.getElementType() : null;
                    if (type == JSTokenTypes.RBRACE || type == XmlTokenType.XML_END_TAG_START || type == XmlTokenType.XML_TAG_END || type == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                        return this.ignoreSemicolonAtEndOfBlock;
                    }
                } else if (InjectedLanguageManager.getInstance((Project)statement.getContainingFile().getProject()).getInjectionHost((PsiElement)statement.getContainingFile()) != null) {
                    return this.ignoreSemicolonAtEndOfBlock;
                }
            }
            return terminated;
        }

        @NotNull
        protected ProblemDescriptor createProblemDescriptorAfter(@NotNull PsiElement location, @NotNull String description, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
            PsiElement element;
            boolean afterEOL;
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$Visitor", "createProblemDescriptorAfter"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$Visitor", "createProblemDescriptorAfter"));
            }
            if (highlightType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightType", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$Visitor", "createProblemDescriptorAfter"));
            }
            if (fixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$Visitor", "createProblemDescriptorAfter"));
            }
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)location);
            while (nextLeaf != null && nextLeaf.getTextLength() == 0 || nextLeaf instanceof PsiErrorElement) {
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            }
            if (nextLeaf == null || nextLeaf.getText().startsWith("\n")) {
                afterEOL = true;
                element = BaseInspectionVisitor.findValidEditorLocation(location);
            } else {
                afterEOL = false;
                element = nextLeaf;
            }
            ProblemDescriptorBase problemDescriptorBase = new ProblemDescriptorBase(element, element, description, fixes, highlightType, afterEOL, new TextRange(0, 1), true, false);
            if (problemDescriptorBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$Visitor", "createProblemDescriptorAfter"));
            }
            return problemDescriptorBase;
        }
    }

    private static class TerminateStatementFix
    extends LocalQuickFixOnPsiElement {
        protected TerminateStatementFix(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix", "<init>"));
            }
            super(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("terminate.statement.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/inspections/UnterminatedStatementJSInspection$TerminateStatementFix", "invoke"));
            }
            if (startElement instanceof JSStatement) {
                startElement.getNode().addLeaf(JSTokenTypes.SEMICOLON, (CharSequence)";", null);
            } else {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = documentManager.getDocument(file);
                if (document == null) {
                    return;
                }
                document.insertString(startElement.getTextOffset() + startElement.getTextLength(), (CharSequence)";");
                documentManager.commitDocument(document);
            }
        }
    }
}

