/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalSymbolsInspection;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstInspection;
import com.intellij.lang.javascript.intentions.JSVariableInitializationExtractor;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertVarToLetConstQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction,
BatchQuickFix<CommonProblemDescriptor> {
    private static final long SEARCH_TIMEOUT = 200L;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix");
    private final SmartPsiElementPointer<JSVarStatement> myPointer;
    private final List<PsiElement> myToReformat;
    private boolean myForceFix;
    private boolean myConservative;
    private boolean myInBatch;
    private boolean myForceVariant;
    private boolean myForceConstVariant;
    private Set<PsiElement> myGeneratedLets = new HashSet<PsiElement>();

    public ES6ConvertVarToLetConstQuickFix(JSVarStatement varStatement) {
        this.myPointer = SmartPointerManager.getInstance((Project)varStatement.getProject()).createSmartPsiElementPointer((PsiElement)varStatement);
        this.myToReformat = new SmartList();
    }

    public ES6ConvertVarToLetConstQuickFix setForceFix(boolean forceFix) {
        this.myForceFix = forceFix;
        return this;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public ES6ConvertVarToLetConstQuickFix forceVariant(boolean forceConstVariant) {
        this.myForceVariant = true;
        this.myForceConstVariant = forceConstVariant;
        return this;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myForceVariant) {
            String string = JSBundle.message((String)(this.myForceConstVariant ? "js.convert.var.to.const.text" : "js.convert.var.to.let.text"), (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "getText"));
            }
            return string;
        }
        String string = JSBundle.message((String)"js.convert.var.to.let.or.const", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "isAvailable"));
        }
        JSVarStatement node = (JSVarStatement)this.myPointer.getElement();
        if (node == null) {
            return false;
        }
        return this.isAvailableImpl(node);
    }

    private boolean isAvailableImpl(JSVarStatement node) {
        ES6ConvertVarToLetConstInspection.ScopeInfo information = ES6ConvertVarToLetConstInspection.getScopeInformation((PsiElement)node);
        PsiFile scope = information.topLevel ? node.getContainingFile() : information.functionParent;
        boolean thereAreDuplicates = false;
        for (JSVariable variable : node.getVariables()) {
            if (variable.getParent() instanceof JSDestructuringArray || variable.getParent() instanceof JSDestructuringProperty) {
                return false;
            }
            Pair<List<JSVariable>, Boolean> duplicatesInfo = ES6ConvertVarToLetConstInspection.findDuplicates(variable, (PsiElement)scope, information.blockParent);
            if (!((Boolean)duplicatesInfo.getSecond()).booleanValue()) {
                return false;
            }
            thereAreDuplicates |= !((List)duplicatesInfo.getFirst()).isEmpty();
        }
        return !this.myForceVariant || !this.myForceConstVariant || this.myForceFix || !thereAreDuplicates && ES6ConvertVarToLetConstQuickFix.canBeConst(node, false, this.myInBatch);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "invoke"));
        }
        JSVarStatement element = (JSVarStatement)this.myPointer.getElement();
        if (element != null && element.isValid()) {
            this.applyFixImpl(project, element, null);
        }
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.var.to.let.or.const.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element.getNode().getElementType() == JSTokenTypes.VAR_KEYWORD && element.getParent() instanceof JSVarStatement) {
            this.applyFixImpl(project, (JSVarStatement)element.getParent(), null);
        }
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "applyFix"));
        }
        if (psiElementsToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "applyFix"));
        }
        MyBatchRefactoringProcessor processor = new MyBatchRefactoringProcessor(project, descriptors, this.getFamilyName());
        processor.run();
    }

    private void applyFixImpl(@NotNull Project project, JSVarStatement varStatement, @Nullable MultiMap<String, PsiReference> referenceMap) {
        boolean moveFromFor;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "applyFixImpl"));
        }
        if (!this.isAvailableImpl(varStatement)) {
            return;
        }
        NewLineEraser eraser = new NewLineEraser((PsiElement)varStatement);
        CommentsMover commentsMover = new CommentsMover((JSSourceElement)varStatement);
        JSVariable[] variables = varStatement.getVariables();
        ArrayList<Pair> moveList = new ArrayList<Pair>();
        HashSet<JSVariable> stayLet = new HashSet<JSVariable>();
        HashSet<JSVariable> stayConst = new HashSet<JSVariable>();
        for (JSVariable variable2 : variables) {
            Outcome outcome = this.defineFixActions(variable2, referenceMap);
            if (!outcome.success) {
                return;
            }
            if (outcome.moveUp) {
                moveList.add(Pair.create((Object)variable2, (Object)outcome));
                continue;
            }
            if (this.myForceVariant && this.myForceConstVariant || !this.myForceVariant && outcome.canBeConst) {
                stayConst.add(variable2);
                continue;
            }
            stayLet.add(variable2);
        }
        if (this.myConservative && !moveList.isEmpty()) {
            return;
        }
        boolean bl = moveFromFor = !moveList.isEmpty() && (varStatement.getParent() instanceof JSForStatement || varStatement.getParent() instanceof JSForInStatement);
        if (moveFromFor) {
            Outcome outcome = (Outcome)((Pair)moveList.get(0)).getSecond();
            moveList.addAll(ContainerUtil.map(stayConst, variable -> Pair.create((Object)variable, (Object)outcome)));
            moveList.addAll(ContainerUtil.map(stayLet, variable -> Pair.create((Object)variable, (Object)outcome)));
            stayConst.clear();
            stayLet.clear();
        }
        List movedVariables = ContainerUtil.map(moveList, pair -> (JSVariable)pair.getFirst());
        List movedWithInitializerVariables = ContainerUtil.map((Collection)ContainerUtil.filter(moveList, pair -> ((Outcome)pair.getSecond()).canBeConst), pair -> (JSVariable)pair.getFirst());
        for (Pair pair2 : moveList) {
            this.createDeclarations(varStatement, (JSVariable)pair2.getFirst(), (Outcome)pair2.getSecond());
        }
        boolean stayLetEmpty = stayLet.isEmpty();
        boolean stayConstEmpty = stayConst.isEmpty();
        if (moveFromFor) {
            for (Pair pair3 : moveList) {
                this.replaceVariableWithAssignmentInPlace((JSVariable)pair3.getFirst());
            }
        } else {
            JSVariableInitializationExtractor extractor = new JSVariableInitializationExtractor(movedVariables, varStatement);
            extractor.deleteExtracted(movedWithInitializerVariables);
            if (this.myForceVariant || stayConstEmpty != stayLetEmpty) {
                JSVarStatement.VarKeyword keyword = this.myForceVariant ? (this.myForceConstVariant ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET) : (stayLetEmpty ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET);
                extractor.withNewKeyword(keyword);
            } else {
                extractor.toBeConst(stayConst);
            }
            this.myToReformat.addAll(extractor.transform());
        }
        if (!this.myGeneratedLets.isEmpty()) {
            commentsMover.move(this.myGeneratedLets, this.myToReformat);
            for (PsiElement let : this.myGeneratedLets) {
                if (!(let instanceof JSVarStatement) || !let.isValid() || !new JSRefactoringUtil.MergeDeclarationAndInitializationPredicate().setReferenceMap(referenceMap).satisfiedBy(let)) continue;
                this.myToReformat.addAll(JSRefactoringUtil.mergeDeclarationAndAssignment((JSVarStatement)let));
            }
        }
        eraser.process();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        for (PsiElement element : this.myToReformat) {
            if (!element.isValid()) continue;
            codeStyleManager.reformat(element);
        }
    }

    private boolean convertDuplicateDeclarations(@NotNull JSVariable variable, PsiElement variableScopeElement, PsiElement variableBlockScope, @Nullable MultiMap<String, PsiReference> referenceMap) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "convertDuplicateDeclarations"));
        }
        Pair<List<JSVariable>, Boolean> pair = ES6ConvertVarToLetConstInspection.findDuplicates(variable, variableScopeElement, variableBlockScope);
        if (!((Boolean)pair.getSecond()).booleanValue() || this.myConservative && !((List)pair.getFirst()).isEmpty() || this.myForceVariant && this.myForceConstVariant) {
            return this.myForceFix || this.myForceVariant && this.myForceConstVariant;
        }
        for (JSVariable duplicate : (List)pair.getFirst()) {
            this.replaceVariableWithAssignmentInPlace(duplicate);
        }
        if (referenceMap != null && !this.myToReformat.isEmpty()) {
            for (PsiElement element : this.myToReformat) {
                if (!(element instanceof JSExpressionStatement)) continue;
                Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)element, JSReferenceExpression.class);
                for (JSReferenceExpression expression : expressions) {
                    if (variable.getName() == null || !variable.getName().equals(expression.getReferenceName())) continue;
                    referenceMap.putValue((Object)variable.getName(), (Object)expression);
                }
            }
        }
        return true;
    }

    private void replaceVariableWithAssignmentInPlace(JSVariable duplicate) {
        PsiElement parent = duplicate.getParent();
        if (parent instanceof JSVarStatement && duplicate.getName() != null) {
            JSVarStatement varStatement = (JSVarStatement)parent;
            if (duplicate.getInitializer() == null) {
                if (varStatement.getParent() instanceof JSForStatement || varStatement.getParent() instanceof JSForInStatement) {
                    PsiElement psi = JSChangeUtil.createExpressionFromText(duplicate.getProject(), duplicate.getName()).getPsi();
                    this.myToReformat.add(duplicate.getParent().replace(psi));
                }
            } else {
                this.myToReformat.addAll(new JSVariableInitializationExtractor(duplicate).setKeepInsideFor(false).transform());
            }
        }
    }

    @NotNull
    private JSVarStatement createLetStatement(boolean canBeConst, @NotNull Project project, List<JSVariable> existingVariables, boolean moveInitializer) {
        JSVariable first;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "createLetStatement"));
        }
        String semicolon = JSCodeStyleSettings.getSemicolon(project);
        String text = this.myForceVariant && this.myForceConstVariant || !this.myForceVariant && canBeConst && moveInitializer ? "const a" + semicolon : "let a" + semicolon;
        JSVarStatement newStatement = (JSVarStatement)JSChangeUtil.createStatementFromText(project, text).getPsi();
        JSVariable after = first = newStatement.getVariables()[0];
        for (JSVariable variable : existingVariables) {
            if (after != first) {
                after = newStatement.addAfter(JSChangeUtil.createCommaPsiElement(project), (PsiElement)after);
            }
            JSVariable copy = (JSVariable)variable.copy();
            if (!moveInitializer && copy.getInitializer() != null) {
                PsiElement current = copy.getFirstChild();
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                boolean eqFound = false;
                while (current != null) {
                    PsiElement sibling = current.getNextSibling();
                    if (current.getNode().getElementType().equals(JSTokenTypes.EQ)) {
                        eqFound = true;
                    }
                    if (eqFound && !(current instanceof PsiWhiteSpace)) {
                        elements.add(current);
                    }
                    current = sibling;
                }
                for (PsiElement element : elements) {
                    element.delete();
                }
            }
            after = newStatement.addAfter((PsiElement)copy, (PsiElement)after);
        }
        first.delete();
        this.myToReformat.add((PsiElement)newStatement);
        JSVarStatement jSVarStatement = newStatement;
        if (jSVarStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "createLetStatement"));
        }
        return jSVarStatement;
    }

    private void createDeclarations(@NotNull JSVarStatement varStatement, @NotNull JSVariable variable, @NotNull Outcome outcome) {
        PsiElement scope;
        if (varStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varStatement", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "createDeclarations"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "createDeclarations"));
        }
        if (outcome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outcome", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "createDeclarations"));
        }
        PsiElement anchor = null;
        if (outcome.topLevel) {
            JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)variable, JSEmbeddedContent.class);
            Object object = scope = embeddedContent != null ? embeddedContent : variable.getContainingFile();
            if (outcome.firstReference != null) {
                if (outcome.firstReference instanceof JSSourceElement) {
                    anchor = outcome.firstReference;
                } else {
                    PsiElement current = outcome.firstReference;
                    while (current != null && !scope.equals(current.getParent())) {
                        current = PsiTreeUtil.getParentOfType((PsiElement)current, JSSourceElement.class);
                    }
                    anchor = current;
                }
            }
            if (anchor == null) {
                anchor = ES6ConvertVarToLetConstQuickFix.getLastParentStatementBeforeFileLevel(varStatement);
            }
        } else {
            scope = outcome.myBlockParentAsMoveTarget != null ? outcome.myBlockParentAsMoveTarget : PsiTreeUtil.getChildOfType((PsiElement)outcome.functionParent, JSBlockStatement.class);
            anchor = PsiTreeUtil.getChildOfType((PsiElement)scope, JSSourceElement.class);
        }
        if (scope == null) {
            return;
        }
        boolean moveInitializer = variable.getInitializer() != null && outcome.canBeConst;
        JSVarStatement statement = this.createLetStatement(outcome.canBeConst, variable.getProject(), Collections.singletonList(variable), moveInitializer);
        if (anchor != null) {
            PsiElement created;
            if (this.myGeneratedLets.contains(anchor)) {
                PsiElement current = anchor;
                while (true) {
                    if (current.getNextSibling().getNode().getElementType() == JSTokenTypes.WHITE_SPACE) {
                        current = current.getNextSibling();
                        continue;
                    }
                    if (!this.myGeneratedLets.contains(current = current.getNextSibling())) break;
                    anchor = current;
                }
                while (this.myGeneratedLets.contains(anchor.getNextSibling())) {
                    anchor = anchor.getNextSibling();
                }
                created = scope.addAfter((PsiElement)statement, anchor);
            } else {
                PsiElement current = anchor;
                while (current.getPrevSibling() instanceof PsiComment || current.getPrevSibling() instanceof PsiWhiteSpace) {
                    if (!((current = current.getPrevSibling()) instanceof PsiComment)) continue;
                    PsiElement associatedElement = CommentsMover.findAssociatedElementForComment((PsiComment)current);
                    if (associatedElement == null || !PsiTreeUtil.isAncestor((PsiElement)associatedElement, (PsiElement)anchor, (boolean)false)) break;
                    anchor = current;
                }
                created = scope.addBefore((PsiElement)statement, anchor);
            }
            this.myGeneratedLets.add(created);
        } else {
            scope.add((PsiElement)statement);
        }
    }

    private static PsiElement getLastParentStatementBeforeFileLevel(JSVarStatement statement) {
        JSVarStatement current = statement;
        while (!(current.getParent() instanceof PsiFile) && current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    public static boolean canBeConst(@NotNull JSVarStatement statement, boolean quick, boolean inBatch) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix", "canBeConst"));
        }
        boolean changes = false;
        for (JSVariable variable : statement.getVariables()) {
            Collection<PsiReference> references;
            if (variable.getInitializer() == null || variable.getName() == null) {
                return false;
            }
            if (quick) {
                references = JSDefaultRenameProcessor.findReferencesForScope((PsiElement)variable, false, (SearchScope)GlobalSearchScope.fileScope((PsiFile)statement.getContainingFile()));
            } else {
                SearchScope scope = statement.getUseScope();
                if (scope instanceof LocalSearchScope) {
                    scope = GlobalSearchScope.filesScope((Project)statement.getProject(), Arrays.asList(((LocalSearchScope)scope).getVirtualFiles()));
                }
                GlobalSearchScope scopeForSearch = JSUnusedGlobalSymbolsInspection.skipLibraryFiles(statement.getProject(), (GlobalSearchScope)scope);
                PsiSearchHelper.SearchCostResult cheapEnoughToSearch = PsiSearchHelper.SERVICE.getInstance((Project)statement.getProject()).isCheapEnoughToSearch(variable.getName(), scopeForSearch, null, null);
                if (cheapEnoughToSearch == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return !inBatch;
                }
                references = JSDefaultRenameProcessor.findReferencesForScope((PsiElement)variable, false, (SearchScope)scopeForSearch, 200L);
            }
            for (PsiReference reference : references) {
                PsiElement element;
                if (!(reference instanceof PsiElement) || !ES6ConvertVarToLetConstQuickFix.changingExpression(element = (PsiElement)reference)) continue;
                changes = true;
                break;
            }
            if (changes) break;
        }
        return !changes;
    }

    private Outcome defineFixActions(JSVariable variable, @Nullable MultiMap<String, PsiReference> referenceMap) {
        PsiFile futureVariableScopeElement;
        Outcome result = new Outcome();
        String variableName = variable.getName();
        if (variableName == null) {
            return result;
        }
        ES6ConvertVarToLetConstInspection.ScopeInfo variableScope = ES6ConvertVarToLetConstInspection.getScopeInformation((PsiElement)variable);
        if (!(variableScope.topLevel || variableScope.functionParent != null && variableScope.blockParent != null)) {
            return result;
        }
        result.functionParent = variableScope.functionParent;
        result.topLevel = variableScope.topLevel;
        result.isEmbedded = variableScope.isEmbedded;
        PsiElement variableScopeElement = ES6ConvertVarToLetConstQuickFix.getFileOrEmbeddedScopeElement(variable, result);
        Object object = futureVariableScopeElement = variableScope.wrappingBlockParent == null ? variable.getContainingFile() : variableScope.wrappingBlockParent;
        if (!this.convertDuplicateDeclarations(variable, variableScopeElement, variableScope.blockParent, referenceMap)) {
            return result;
        }
        boolean changes = false;
        boolean hasReferencesOutsideBlock = false;
        Collection<PsiReference> references = referenceMap != null ? referenceMap.get((Object)variableName) : JSDefaultRenameProcessor.findReferencesForScope((PsiElement)variable, false, (SearchScope)GlobalSearchScope.fileScope((PsiFile)variable.getContainingFile()));
        ArrayList asElements = new ArrayList();
        asElements.addAll(ContainerUtil.mapNotNull(references, ref -> ref instanceof PsiElement ? (PsiElement)ref : null));
        for (PsiElement element : asElements) {
            JSSourceElement parentStatement;
            boolean beforeInText;
            if (variable.equals(element)) continue;
            ES6ConvertVarToLetConstInspection.ScopeInfo scopeInfo = ES6ConvertVarToLetConstInspection.getScopeInformation(element);
            if (referenceMap != null && !Comparing.equal((Object)scopeInfo.functionParent, (Object)variableScope.functionParent)) continue;
            if (ES6ConvertVarToLetConstQuickFix.changingExpression(element)) {
                changes = true;
            }
            if ((beforeInText = ES6ConvertVarToLetConstQuickFix.beforeInText(element, (PsiElement)variable)) && (result.firstReference == null || ES6ConvertVarToLetConstQuickFix.beforeInText(element, result.firstReference))) {
                result.firstReference = element;
            }
            if ((parentStatement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSourceElement.class)) == variable.getParent()) continue;
            if (PsiTreeUtil.isAncestor((PsiElement)variableScope.blockParent, (PsiElement)element, (boolean)true)) {
                if (!beforeInText && (variableScope.blockParent == variableScope.wrappingBlockParent || PsiTreeUtil.isAncestor((PsiElement)variableScope.wrappingBlockParent, (PsiElement)element, (boolean)true))) continue;
                result.moveUp = true;
                continue;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)variableScopeElement, (PsiElement)element, (boolean)true)) continue;
            hasReferencesOutsideBlock = true;
            if (!beforeInText && PsiTreeUtil.isAncestor((PsiElement)futureVariableScopeElement, (PsiElement)(scopeInfo.blockParent == null ? variable.getContainingFile() : scopeInfo.blockParent), (boolean)false)) continue;
            result.moveUp = true;
        }
        if (!hasReferencesOutsideBlock) {
            result.myBlockParentAsMoveTarget = variableScope.blockParent;
        }
        result.canBeConst = !changes && variable.getInitializer() != null && !references.isEmpty();
        result.success = true;
        return result;
    }

    private static PsiElement getFileOrEmbeddedScopeElement(JSVariable variable, Outcome result) {
        JSEmbeddedContent embeddedContent;
        if (result.isEmbedded && (embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)variable, JSEmbeddedContent.class)) != null) {
            return embeddedContent;
        }
        return result.topLevel ? variable.getContainingFile() : result.functionParent;
    }

    private static boolean beforeInText(PsiElement element, PsiElement variable) {
        return element.getTextRange().getStartOffset() < variable.getTextRange().getStartOffset();
    }

    private static boolean changingExpression(PsiElement element) {
        if (element.getParent() instanceof JSDefinitionExpression && ((JSDefinitionExpression)element.getParent()).getExpression() == element && element.getParent().getParent() instanceof JSAssignmentExpression) {
            return true;
        }
        return element.getParent() instanceof JSPostfixExpression || element.getParent() instanceof JSPrefixExpression;
    }

    public ES6ConvertVarToLetConstQuickFix setConservative(boolean conservative) {
        this.myConservative = conservative;
        return this;
    }

    public ES6ConvertVarToLetConstQuickFix setInBatch(boolean inBatch) {
        this.myInBatch = inBatch;
        return this;
    }

    private static class MyBatchRefactoringProcessor
    extends BaseRefactoringProcessor {
        final MultiMap<VirtualFile, ES6ConvertVarToLetConstQuickFix> myFixesMap;
        final MultiMap<VirtualFile, String> myWords;
        final List<PsiElement> myElements;
        private final Project myProject;
        private final CommonProblemDescriptor[] myDescriptors;
        private final String myFamilyName;

        public MyBatchRefactoringProcessor(Project project, CommonProblemDescriptor[] descriptors, String familyName) {
            super(project);
            this.myProject = project;
            this.myDescriptors = descriptors;
            this.myFamilyName = familyName;
            this.myFixesMap = new MultiMap();
            this.myWords = new MultiMap();
            this.myElements = new ArrayList<PsiElement>();
        }

        @NotNull
        protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MyBatchRefactoringProcessor", "createUsageViewDescriptor"));
            }
            BaseUsageViewDescriptor baseUsageViewDescriptor = new BaseUsageViewDescriptor(new PsiElement[0]);
            if (baseUsageViewDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MyBatchRefactoringProcessor", "createUsageViewDescriptor"));
            }
            return baseUsageViewDescriptor;
        }

        @NotNull
        protected UsageInfo[] findUsages() {
            MyBatchRefactoringProcessor.fillFixesMap(this.myDescriptors, this.myFixesMap, this.myWords, this.myElements);
            UsageInfo[] usageInfoArray = (UsageInfo[])ContainerUtil.map2Array(this.myElements, UsageInfo.class, element -> new UsageInfo(element));
            if (usageInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MyBatchRefactoringProcessor", "findUsages"));
            }
            return usageInfoArray;
        }

        protected void performRefactoring(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MyBatchRefactoringProcessor", "performRefactoring"));
            }
            PostprocessReformattingAspect.getInstance((Project)this.myProject).postponeFormattingInside(() -> {
                for (VirtualFile file : this.myFixesMap.keySet()) {
                    Collection fixes = this.myFixesMap.get((Object)file);
                    PsiFile containingFile = ((ES6ConvertVarToLetConstQuickFix)fixes.iterator().next()).myPointer.getContainingFile();
                    LOG.assertTrue(containingFile != null);
                    MultiMap referenceMap = new MultiMap();
                    MyBatchRefactoringProcessor.fillReferenceMap(this.myWords, containingFile, (MultiMap<String, PsiReference>)referenceMap);
                    for (ES6ConvertVarToLetConstQuickFix fix : fixes) {
                        JSVarStatement element = (JSVarStatement)fix.myPointer.getElement();
                        if (element == null || !element.isValid()) continue;
                        fix.applyFixImpl(this.myProject, element, (MultiMap<String, PsiReference>)referenceMap);
                    }
                }
            });
        }

        protected String getCommandName() {
            return this.myFamilyName;
        }

        private static void fillReferenceMap(MultiMap<VirtualFile, String> words, PsiFile containingFile, MultiMap<String, PsiReference> referenceMap) {
            Collection references = PsiTreeUtil.findChildrenOfType((PsiElement)containingFile, JSReferenceExpression.class);
            references = ContainerUtil.filter((Collection)references, expression -> expression.getQualifier() == null && words.get((Object)containingFile.getVirtualFile()).contains(expression.getReferenceName()));
            for (JSReferenceExpression reference : references) {
                PsiElement resolve = reference.resolve();
                if (resolve == null || !resolve.isValid() || !(resolve instanceof JSNamedElement)) continue;
                referenceMap.putValue((Object)((JSNamedElement)resolve).getName(), (Object)reference);
            }
        }

        private static void fillFixesMap(@NotNull CommonProblemDescriptor[] descriptors, MultiMap<VirtualFile, ES6ConvertVarToLetConstQuickFix> fixesMap, MultiMap<VirtualFile, String> words, List<PsiElement> elements) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MyBatchRefactoringProcessor", "fillFixesMap"));
            }
            for (CommonProblemDescriptor descriptor : descriptors) {
                QuickFix[] fixes = descriptor.getFixes();
                if (fixes == null) continue;
                for (QuickFix fix : fixes) {
                    if (fix instanceof ES6ConvertVarToLetConstQuickFix) {
                        VirtualFile file;
                        SmartPsiElementPointer pointer = ((ES6ConvertVarToLetConstQuickFix)fix).myPointer;
                        JSVarStatement element = (JSVarStatement)pointer.getElement();
                        if (element == null || !element.isValid() || (file = pointer.getVirtualFile()) == null || !file.isValid()) continue;
                        elements.add((PsiElement)element);
                        for (JSVariable variable : element.getVariables()) {
                            words.putValue((Object)file, (Object)variable.getName());
                        }
                        fixesMap.putValue((Object)file, (Object)((ES6ConvertVarToLetConstQuickFix)fix));
                        continue;
                    }
                    throw new AssertionError();
                }
            }
        }
    }

    private static class Outcome {
        private boolean success = false;
        private boolean moveUp = false;
        private PsiElement myBlockParentAsMoveTarget;
        private JSNamedElement functionParent;
        private boolean topLevel;
        private boolean canBeConst;
        private PsiElement firstReference;
        private boolean isEmbedded;

        private Outcome() {
        }
    }
}

