/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.AnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSArrowFunctionToAnonymousIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    public JSArrowFunctionToAnonymousIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.anonymous.function", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element) || !ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        JSFunctionExpression arrowFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        boolean anonymousArrow = arrowFunction != null && JSPsiImplUtils.isArrowFunction((JSFunction)arrowFunction) != null;
        return anonymousArrow && PsiTreeUtil.findChildOfType((PsiElement)arrowFunction, JSThisExpression.class) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention", "invoke"));
        }
        JSFunctionExpression arrowFunction = AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        if (arrowFunction == null || JSPsiImplUtils.isArrowFunction((JSFunction)arrowFunction) == null || PsiTreeUtil.findChildOfType((PsiElement)arrowFunction, JSThisExpression.class) != null) {
            return;
        }
        boolean removeParenthesis = arrowFunction.getParent() instanceof JSParenthesizedExpression && ((JSParenthesizedExpression)arrowFunction.getParent()).getInnerExpression() == arrowFunction;
        JSFunction anonymousFunction = JSFunctionsHelper.createAnonymousFunction(project, (JSFunction)arrowFunction);
        JSElement replaced = JSChangeUtil.replaceElement((JSElement)(removeParenthesis ? (JSElement)arrowFunction.getParent() : arrowFunction), (JSElement)anonymousFunction);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)replaced.getContainingFile(), replaced.getTextRange().getStartOffset(), replaced.getTextRange().getEndOffset());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.anonymous.function.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention", "getFamilyName"));
        }
        return string;
    }
}

