/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JavaScriptGenerateAccessorHandler;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionsHelper {
    public static JSFunction createAnonymousFunction(@NotNull Project project, JSFunction function) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createAnonymousFunction"));
        }
        return JSFunctionsHelper.createFunction(project, function, "");
    }

    public static JSFunction createGetter(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createGetter"));
        }
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createGetter"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createGetter"));
        }
        JSFunction function = JSFunctionsHelper.createAccessorInClassFromText(project, JavaScriptGenerateAccessorHandler.GenerationMode.Getter, name, isStatic, null, false);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    @NotNull
    public static JSFunction createAccessorInClassFromText(@NotNull Project project, @NotNull JavaScriptGenerateAccessorHandler.GenerationMode generationMode, @NotNull String name, boolean isStatic, @Nullable String innerText, boolean withParameter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createAccessorInClassFromText"));
        }
        if (generationMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationMode", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createAccessorInClassFromText"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createAccessorInClassFromText"));
        }
        assert (JavaScriptGenerateAccessorHandler.GenerationMode.Getter.equals((Object)generationMode) || JavaScriptGenerateAccessorHandler.GenerationMode.Setter.equals((Object)generationMode));
        String paramText = JavaScriptGenerateAccessorHandler.GenerationMode.Setter.equals((Object)generationMode) && withParameter ? "value" : "";
        String functionText = "class d{" + (isStatic ? "static " : "") + (JavaScriptGenerateAccessorHandler.GenerationMode.Getter.equals((Object)generationMode) ? "get " : "set ") + name + "(" + paramText + ")" + (innerText == null ? "{}" : innerText) + "}";
        ES6Class aClass = (ES6Class)JSChangeUtil.createExpressionFromText(project, functionText).getPsi(ES6Class.class);
        JSFunction function = (JSFunction)PsiTreeUtil.getChildOfType((PsiElement)aClass, JSFunction.class);
        assert (function != null);
        JSFunction jSFunction = function;
        if (jSFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createAccessorInClassFromText"));
        }
        return jSFunction;
    }

    public static JSFunction createSetter(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name, boolean isStatic) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createSetter"));
        }
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createSetter"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createSetter"));
        }
        JSFunction function = JSFunctionsHelper.createAccessorInClassFromText(project, JavaScriptGenerateAccessorHandler.GenerationMode.Setter, name, isStatic, null, false);
        JSFunctionsHelper.moveParameters(sourceFunction, function);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    public static JSFunction createFunction(@NotNull Project project, @NotNull JSFunction sourceFunction, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createFunction"));
        }
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createFunction"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "createFunction"));
        }
        String functionText = "(" + JSFunctionsHelper.getFunctionAttributesModifiersText(sourceFunction) + "function " + name + "(){})";
        JSParenthesizedExpression expression = (JSParenthesizedExpression)JSChangeUtil.createExpressionFromText(project, functionText).getPsi(JSParenthesizedExpression.class);
        JSFunction function = (JSFunction)expression.getInnerExpression();
        JSFunctionsHelper.moveParameters(sourceFunction, function);
        JSFunctionsHelper.moveFunctionBody(sourceFunction, function);
        return function;
    }

    public static String getFunctionAttributesModifiersText(@NotNull JSFunction sourceFunction) {
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "getFunctionAttributesModifiersText"));
        }
        if (JSFunctionsHelper.hasAttributesOfModifiers(sourceFunction)) {
            return sourceFunction.getAttributeList().getText() + " ";
        }
        return "";
    }

    private static boolean hasAttributesOfModifiers(@NotNull JSFunction sourceFunction) {
        if (sourceFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFunction", "com/intellij/lang/javascript/intentions/JSFunctionsHelper", "hasAttributesOfModifiers"));
        }
        return sourceFunction.getAttributeList() != null && !StringUtil.isEmptyOrSpaces((String)sourceFunction.getAttributeList().getText());
    }

    public static void moveParameters(JSFunction source, JSFunction target) {
        if (source.getParameters().length > 0) {
            JSParameterList sourceParameterList = source.getParameterList();
            assert (target.getParameterList() != null);
            if (JSFunctionsHelper.noBracesAroundSingleParameter(sourceParameterList) && sourceParameterList.getParameters().length == 1) {
                if (JSFunctionsHelper.noBracesAroundSingleParameter(target.getParameterList())) {
                    target.getParameterList().deleteChildRange(target.getParameterList().getFirstChild(), target.getParameterList().getLastChild());
                    target.getParameterList().add(sourceParameterList.getParameters()[0].copy());
                } else {
                    target.getParameterList().addAfter(sourceParameterList.getParameters()[0].copy(), target.getParameterList().getFirstChild());
                }
            } else {
                JSChangeUtil.replaceElement((JSElement)target.getParameterList(), (JSElement)sourceParameterList.copy());
            }
        }
    }

    private static boolean noBracesAroundSingleParameter(JSParameterList sourceParameterList) {
        return sourceParameterList.getParameters().length > 0 && sourceParameterList.getFirstChild() == sourceParameterList.getParameters()[0];
    }

    public static void moveFunctionBody(JSFunction source, JSFunction target) {
        JSBlockStatement targetBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)target, JSBlockStatement.class);
        JSFunctionsHelper.moveFunctionBody(source, targetBlock);
    }

    public static JSStatement moveFunctionBody(JSFunction source, JSBlockStatement targetBlock) {
        JSBlockStatement sourceBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)source, JSBlockStatement.class);
        if (sourceBlock != null) {
            return JSChangeUtil.replaceStatement((JSStatement)targetBlock, (JSStatement)sourceBlock.copy());
        }
        Iterator iterator = PsiTreeUtil.childIterator((PsiElement)source, PsiElement.class);
        while (iterator.hasNext()) {
            PsiElement next = (PsiElement)iterator.next();
            if (next instanceof JSParameterList || next instanceof JSAttributeList || !(next instanceof JSElement)) continue;
            if (!(next instanceof JSStatement)) {
                String returnText = "return 1" + JSCodeStyleSettings.getSemicolon(source.getContainingFile());
                JSReturnStatement statement = (JSReturnStatement)JSChangeUtil.createStatementFromText(source.getProject(), returnText).getPsi(JSReturnStatement.class);
                JSElement element = (JSElement)next;
                element = element instanceof JSParenthesizedExpression && ((JSParenthesizedExpression)element).getInnerExpression() != null ? ((JSParenthesizedExpression)element).getInnerExpression() : element;
                JSChangeUtil.replaceElement((JSElement)statement.getExpression(), element);
                next = statement;
            }
            targetBlock.addAfter(next.copy(), targetBlock.getFirstChild());
            break;
        }
        return targetBlock;
    }

    public static class AccessorsGenerator {
        @NotNull
        private final PsiElement myBaseElement;
        @NotNull
        private final String myName;
        private boolean myIsGetter;
        private String myQualifier;
        private String myBeforeText;
        private String myAfterText;
        private JSNamedElement myNamedElement;

        public AccessorsGenerator(@NotNull PsiElement baseElement, @NotNull String name) {
            if (baseElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseElement", "com/intellij/lang/javascript/intentions/JSFunctionsHelper$AccessorsGenerator", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/intentions/JSFunctionsHelper$AccessorsGenerator", "<init>"));
            }
            this.myIsGetter = true;
            this.myBaseElement = baseElement;
            this.myName = name;
        }

        public String generate() {
            this.myQualifier = this.myQualifier != null ? this.myQualifier + "." : "";
            String semicolon = JSCodeStyleSettings.getSettings((PsiElement)this.myBaseElement).USE_SEMICOLON_AFTER_STATEMENT ? ";" : "";
            StringBuilder sb = new StringBuilder("{\n");
            if (this.myBeforeText != null) {
                sb.append(this.myBeforeText);
            }
            if (this.myIsGetter) {
                sb.append("return ");
                this.qualifiedName(sb).append(semicolon);
            } else {
                this.qualifiedName(sb).append("=").append("value").append(semicolon);
            }
            if (this.myAfterText != null) {
                sb.append(this.myAfterText);
            }
            sb.append("\n}");
            return sb.toString();
        }

        @NotNull
        private StringBuilder qualifiedName(StringBuilder sb) {
            if (this.myNamedElement instanceof JSDefinitionExpression && ((JSDefinitionExpression)this.myNamedElement).getExpression() instanceof JSIndexedPropertyAccessExpression) {
                StringBuilder stringBuilder = sb.append(this.myQualifier.substring(0, this.myQualifier.length() - 1)).append(this.myName);
                if (stringBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSFunctionsHelper$AccessorsGenerator", "qualifiedName"));
                }
                return stringBuilder;
            }
            StringBuilder stringBuilder = sb.append(this.myQualifier).append(this.myName);
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSFunctionsHelper$AccessorsGenerator", "qualifiedName"));
            }
            return stringBuilder;
        }

        public AccessorsGenerator setter() {
            this.myIsGetter = false;
            return this;
        }

        public AccessorsGenerator getter() {
            this.myIsGetter = true;
            return this;
        }

        public AccessorsGenerator setQualifier(String qualifier) {
            this.myQualifier = qualifier;
            return this;
        }

        public AccessorsGenerator setBeforeText(String beforeText) {
            this.myBeforeText = beforeText;
            return this;
        }

        public AccessorsGenerator setAfterText(String afterText) {
            this.myAfterText = afterText;
            return this;
        }

        public AccessorsGenerator setNamedElement(JSNamedElement namedElement) {
            this.myNamedElement = namedElement;
            return this;
        }
    }
}

