/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiFile;

public class JSLibrariesMenuGroup
extends DefaultActionGroup
implements DumbAware {
    public void update(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Presentation presentation = e.getPresentation();
        boolean groupAvailable = false;
        if (file != null) {
            Language language = file.getLanguage();
            if (language.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                JSLanguageDialect dialect = JSUtils.getDialect(file);
                groupAvailable = dialect != JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            } else if (language.is((Language)HTMLLanguage.INSTANCE)) {
                groupAvailable = true;
            }
        }
        presentation.setVisible(groupAvailable);
        presentation.setEnabled(groupAvailable);
    }
}

