/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingLibraryIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryListGroup
extends ActionGroup {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getChildren"));
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] anActionArray = JSLibraryListGroup.getLibraryActions(project, file.getVirtualFile());
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getChildren"));
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction[] getLibraryActions(@NotNull Project project, VirtualFile file) {
        List<ScriptingLibraryModel> libraries;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getLibraryActions"));
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        if (file != null && (libraries = JSLibraryListGroup.sort(libraryManager.getAllLibraries())) != null) {
            boolean predefinedSeparator = false;
            for (ScriptingLibraryModel library : libraries) {
                if (library.isPredefined() && !predefinedSeparator) {
                    actions.add(new Separator("Predefined"));
                    predefinedSeparator = true;
                }
                actions.add((Object)new MySetJsLibraryAction(library, mappings.isAssociatedWith(file, library.getName()), mappings));
            }
        }
        AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSLibraryListGroup", "getLibraryActions"));
        }
        return anActionArray;
    }

    @Nullable
    private static List<ScriptingLibraryModel> sort(ScriptingLibraryModel[] libraries) {
        if (libraries == null) {
            return null;
        }
        ArrayList<ScriptingLibraryModel> result = new ArrayList<ScriptingLibraryModel>();
        result.addAll(Arrays.asList(libraries));
        Collections.sort(result, (lib1, lib2) -> {
            if (lib1.isPredefined() != lib2.isPredefined()) {
                return (lib1.isPredefined() ? 1 : 0) - (lib2.isPredefined() ? 1 : 0);
            }
            return lib1.getName().compareToIgnoreCase(lib2.getName());
        });
        return result;
    }

    private static class MySetJsLibraryAction
    extends AnAction {
        private static Icon USED_ICON = ScriptingLibraryIcons.CHECKED_ICON;
        private static Icon UNUSED_ICON = ScriptingLibraryIcons.UNCHECKED_ICON;
        private boolean myIsInUse;
        private final ScriptingLibraryModel myLibrary;
        private final JSLibraryMappings myMappings;

        private MySetJsLibraryAction(ScriptingLibraryModel library, boolean isInUse, JSLibraryMappings mappings) {
            super(library.getName(), isInUse ? "Don't use library" : "Use library", isInUse ? USED_ICON : UNUSED_ICON);
            this.myIsInUse = isInUse;
            this.myLibrary = library;
            this.myMappings = mappings;
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (!this.myIsInUse && this.isLibraryUsedOnContainingFolderOrProject(virtualFile)) {
                presentation.setEnabled(false);
                presentation.setIcon(USED_ICON);
                presentation.setDescription("Already set for containing folder or project.");
            }
        }

        public void actionPerformed(AnActionEvent e) {
            if (e == null) {
                return;
            }
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            WriteAction.run(() -> {
                JSLibraryManager manager = (JSLibraryManager)((Object)((Object)ServiceManager.getService((Project)project, JSLibraryManager.class)));
                ScriptingLibraryMappings mappings = manager.getLibraryMappings();
                if (!this.myIsInUse) {
                    mappings.associate(virtualFile, this.myLibrary.getName(), this.myLibrary.isPredefined());
                } else {
                    mappings.disassociate(virtualFile, this.myLibrary.getName());
                }
                manager.commitChanges();
            });
        }

        private boolean isLibraryUsedOnContainingFolderOrProject(VirtualFile file) {
            Set libFiles = this.myLibrary.getCompactFiles();
            if (libFiles.size() == 0) {
                libFiles = this.myLibrary.getSourceFiles();
            }
            if (libFiles.size() == 0) {
                return false;
            }
            VirtualFile libFile = (VirtualFile)libFiles.iterator().next();
            return this.myMappings.isApplicable(libFile, file);
        }
    }
}

