/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterState;
import org.jetbrains.annotations.NotNull;

public class ExtendedLinterState<T extends JSLinterState> {
    private final boolean myEnabled;
    private final T myState;

    public ExtendedLinterState(boolean enabled, T state) {
        this.myEnabled = enabled;
        this.myState = state;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ExtendedLinterState", "getState"));
        }
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedLinterState state = (ExtendedLinterState)o;
        return this.myEnabled == state.myEnabled && this.myState.equals(state.myState);
    }

    public int hashCode() {
        int result = this.myEnabled ? 1 : 0;
        result = 31 * result + this.myState.hashCode();
        return result;
    }

    public String toString() {
        return "enabled=" + this.myEnabled + ", " + this.myState;
    }

    public static <T extends JSLinterState> ExtendedLinterState<T> create(boolean enabled, T state) {
        return new ExtendedLinterState<T>(enabled, state);
    }
}

