/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterAnnotationResult<T extends JSLinterState> {
    private final JSLinterInput<T> myInput;
    private final List<JSLinterError> myErrors;
    private final JSLinterFileLevelAnnotation myFileLevelError;
    private final VirtualFile myConfigFile;

    public JSLinterAnnotationResult(@NotNull JSLinterInput<T> input, @NotNull List<JSLinterError> errors, @Nullable JSLinterFileLevelAnnotation fileLevelError, @Nullable VirtualFile configFile) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "<init>"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "<init>"));
        }
        this.myInput = input;
        this.myErrors = errors;
        this.myFileLevelError = fileLevelError;
        this.myConfigFile = configFile;
    }

    @NotNull
    public JSLinterInput getInput() {
        JSLinterInput<T> jSLinterInput = this.myInput;
        if (jSLinterInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "getInput"));
        }
        return jSLinterInput;
    }

    @NotNull
    public T getState() {
        T t = this.myInput.getState();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "getState"));
        }
        return t;
    }

    @NotNull
    public List<JSLinterError> getErrors() {
        List<JSLinterError> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "getErrors"));
        }
        return list;
    }

    public JSLinterFileLevelAnnotation getFileLevelError() {
        return this.myFileLevelError;
    }

    public boolean hasFileLevelInfo() {
        return this.myFileLevelError != null;
    }

    @Nullable
    public VirtualFile getConfigFile() {
        return this.myConfigFile;
    }

    public static <T extends JSLinterState> JSLinterAnnotationResult<T> createLinterResult(@NotNull JSLinterInput<T> input, @NotNull List<JSLinterError> errors, @Nullable VirtualFile configFile) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterResult"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterResult"));
        }
        return new JSLinterAnnotationResult<T>(input, errors, null, configFile);
    }

    @NotNull
    public static <T extends JSLinterState> JSLinterAnnotationResult<T> create(@NotNull JSLinterInput<T> input, @NotNull JSLinterFileLevelAnnotation fileLevelAnnotation, VirtualFile config) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "create"));
        }
        if (fileLevelAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLevelAnnotation", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "create"));
        }
        JSLinterAnnotationResult<T> jSLinterAnnotationResult = new JSLinterAnnotationResult<T>(input, Collections.emptyList(), fileLevelAnnotation, config);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "create"));
        }
        return jSLinterAnnotationResult;
    }
}

