/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterEditorPanelCreator;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterAnnotationsBuilder<T extends JSLinterState> {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final JSLinterAnnotationResult<T> myResult;
    @NotNull
    private final AnnotationHolder myHolder;
    @NotNull
    private final HighlightDisplayKey myKey;
    @NotNull
    private final JSLinterConfigurable<T> myConfigurable;
    @NotNull
    private final String myPrefix;
    private int myTabSize;
    @NotNull
    private JSLinterExternalAnnotator.HighlightingGranularity myHighlightingGranularity;
    @NotNull
    private final Class<? extends JSLinterInspection> myInspectionClass;
    @NotNull
    private final JSLinterStandardFixes myStandardFixes;

    public JSLinterAnnotationsBuilder(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<T> annotationResult, @NotNull AnnotationHolder holder, @NotNull HighlightDisplayKey inspectionKey, @NotNull JSLinterConfigurable<T> configurable, @NotNull String errorPrefix, @NotNull Class<? extends JSLinterInspection> inspectionClass, @NotNull JSLinterStandardFixes fixes) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (errorPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPrefix", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (inspectionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionClass", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "<init>"));
        }
        this.myTabSize = 1;
        this.myFile = file;
        this.myResult = annotationResult;
        this.myHolder = holder;
        this.myKey = inspectionKey;
        this.myConfigurable = configurable;
        this.myPrefix = errorPrefix;
        this.myInspectionClass = inspectionClass;
        this.myStandardFixes = fixes;
        this.myHighlightingGranularity = JSLinterExternalAnnotator.HighlightingGranularity.none;
    }

    @NotNull
    public JSLinterAnnotationsBuilder<T> setTabSize(int tabSize) {
        this.myTabSize = tabSize;
        JSLinterAnnotationsBuilder jSLinterAnnotationsBuilder = this;
        if (jSLinterAnnotationsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "setTabSize"));
        }
        return jSLinterAnnotationsBuilder;
    }

    public void apply() {
        if (this.myResult == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        if (document == null) {
            return;
        }
        this.createFileLevelAnnotations();
        this.processLocalErrors(document);
    }

    private void processLocalErrors(Document document) {
        if (this.myResult == null) {
            return;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)this.myFile.getProject());
        SeverityRegistrar severityRegistrar = inspectionProjectProfileManager.getSeverityRegistrar();
        HighlightSeverity defaultSeverity = JSLinterUtil.getSeverity(inspectionProjectProfileManager, this.myKey, this.myFile);
        EditorColorsScheme colorsScheme = this.myResult.getInput().getColorsScheme();
        Function severityTextAttributesProvider = severity -> JSLinterUtil.getTextAttributes(colorsScheme, severityRegistrar, severity);
        TextAttributes defaultSeverityTextAttributes = (TextAttributes)severityTextAttributesProvider.fun((Object)defaultSeverity);
        List<JSLinterError> limitedErrors = JSLinterUtil.limitErrorsAtTheSamePosition(this.myResult.getErrors(), 10);
        for (JSLinterError linterError : limitedErrors) {
            Annotation annotation = JSLinterExternalAnnotator.createAnnotation(this.myHolder, this.myFile, document, linterError, this.myPrefix, this.myTabSize, defaultSeverity, defaultSeverityTextAttributes, (Function<HighlightSeverity, TextAttributes>)severityTextAttributesProvider, this.myKey, this.myHighlightingGranularity);
            if (annotation == null) continue;
            List<IntentionAction> list = this.myStandardFixes.createListForError(this.myResult.getConfigFile(), this.myConfigurable, linterError);
            for (IntentionAction action : list) {
                annotation.registerFix(action, null, this.myKey);
            }
        }
    }

    private void createFileLevelAnnotations() {
        if (this.myResult == null) {
            throw new AssertionError();
        }
        JSLinterDescriptor descriptor = JSLinterEditorPanelCreator.getInstance(this.myFile.getProject()).getDescriptorByInspectionClass(this.myInspectionClass);
        JSLinterFileLevelAnnotation error = this.myResult.getFileLevelError();
        if (error != null) {
            error.prefix(this.myPrefix);
            JSLinterStandardFixes fixes = new JSLinterStandardFixes().setShowEditSettings(false).setOtherFixes(error.getFixes().createList(this.myResult.getConfigFile(), this.myConfigurable)).setEditConfig(false);
            JSLinterFileLevelAnnotation copy = new JSLinterFileLevelAnnotation(error.getIcon(), error.getMessage(), error.getSeverity(), fixes);
            JSLinterEditorNotificationPanel.setNotification(this.myFile.getProject(), descriptor.uniqueName(), this.myFile.getVirtualFile(), copy);
        } else {
            JSLinterEditorNotificationPanel.clearNotification(this.myFile.getProject(), descriptor.uniqueName(), this.myFile.getVirtualFile());
        }
    }

    public JSLinterAnnotationsBuilder<T> setHighlightingGranularity(@NotNull JSLinterExternalAnnotator.HighlightingGranularity highlightingGranularity) {
        if (highlightingGranularity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingGranularity", "com/intellij/lang/javascript/linter/JSLinterAnnotationsBuilder", "setHighlightingGranularity"));
        }
        this.myHighlightingGranularity = highlightingGranularity;
        return this;
    }
}

