/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.util.containers.ComparatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterError
extends JSLinterErrorBase {
    private final int myLine;
    private final int myColumn;
    private final HighlightSeverity mySeverity;

    public JSLinterError(int line, int column, @NotNull String description, @Nullable String code) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/JSLinterError", "<init>"));
        }
        this(line, column, description, code, null);
    }

    public JSLinterError(int line, int column, @NotNull String description, @Nullable String code, @Nullable HighlightSeverity severity) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/linter/JSLinterError", "<init>"));
        }
        super(description, code);
        this.myLine = line;
        this.myColumn = column;
        this.mySeverity = severity;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    @Nullable
    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public int compareLogicalPositionTo(@NotNull JSLinterError other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/lang/javascript/linter/JSLinterError", "compareLogicalPositionTo"));
        }
        int rowDiff = this.getLine() - other.getLine();
        if (rowDiff != 0) {
            return rowDiff;
        }
        return this.getColumn() - other.getColumn();
    }

    public int compareFully(@NotNull JSLinterError other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/lang/javascript/linter/JSLinterError", "compareFully"));
        }
        int logicalPositionCmp = this.compareLogicalPositionTo(other);
        if (logicalPositionCmp != 0) {
            return logicalPositionCmp;
        }
        return this.myDescription.compareTo(other.myDescription);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLinterError error = (JSLinterError)o;
        return this.myLine == error.myLine && this.myColumn == error.myColumn && ComparatorUtil.equalsNullable((Object)this.mySeverity, (Object)error.mySeverity) && ComparatorUtil.equalsNullable((Object)this.myCode, (Object)error.myCode) && this.myDescription.equals(error.myDescription);
    }

    public int hashCode() {
        int result = this.myLine;
        result = 31 * result + this.myColumn;
        result = 31 * result + (this.mySeverity != null ? this.mySeverity.hashCode() : 0);
        result = 31 * result + (this.myCode != null ? this.myCode.hashCode() : 0);
        result = 31 * result + this.myDescription.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.myLine + "," + this.myColumn + "): " + this.myDescription;
    }
}

