/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterEditorPanelCreator;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterExternalAnnotator<T extends JSLinterState>
extends ExternalAnnotator<JSLinterInput<T>, JSLinterAnnotationResult<T>> {
    private final boolean myOnTheFly;

    public JSLinterExternalAnnotator(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    @NotNull
    protected abstract JSLinterConfigurable<T> createSettingsConfigurable(@NotNull Project var1);

    protected abstract Class<? extends JSLinterConfiguration<T>> getConfigurationClass();

    protected abstract Class<? extends JSLinterInspection> getInspectionClass();

    protected abstract boolean acceptPsiFile(@NotNull PsiFile var1);

    protected boolean acceptState(@NotNull T state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "acceptState"));
        }
        return true;
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @Nullable
    public Icon getFileLevelAnnotationDefaultIcon() {
        return null;
    }

    @Nullable
    public final JSLinterInput<T> collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "collectInformation"));
        }
        return this.collectInformation(file, null);
    }

    @Nullable
    public final JSLinterInput<T> collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "collectInformation"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "collectInformation"));
        }
        JSLinterInput<T> input = this.collectInformation(file, editor);
        JSLinterDescriptor descriptor = JSLinterEditorPanelCreator.getInstance(file.getProject()).getDescriptorByInspectionClass(this.getInspectionClass());
        if (input == null) {
            JSLinterEditorNotificationPanel.clearNotification(file.getProject(), descriptor.uniqueName(), file.getVirtualFile());
        }
        return input;
    }

    @Nullable
    private JSLinterInput<T> collectInformation(@NotNull PsiFile psiFile, @Nullable Editor editor) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "collectInformation"));
        }
        if (psiFile.getContext() != null || !this.acceptPsiFile(psiFile)) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return null;
        }
        if (psiFile.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            return null;
        }
        Project project = psiFile.getProject();
        if (this.isOnTheFly() && !JSLinterInspection.isToolEnabled(project, this.getInspectionClass(), psiFile)) {
            return null;
        }
        JSLinterConfiguration<T> configuration = JSLinterConfiguration.getInstance(project, this.getConfigurationClass());
        T state = configuration.getExtendedState().getState();
        if (!this.acceptState(state)) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        String fileContent = document.getText();
        if (StringUtil.isEmptyOrSpaces((String)fileContent)) {
            return null;
        }
        EditorColorsScheme colorsScheme = editor != null ? editor.getColorsScheme() : null;
        return JSLinterInput.create(project, psiFile, document, fileContent, state, colorsScheme);
    }

    @Nullable
    public JSLinterAnnotationResult<T> doAnnotate(@Nullable JSLinterInput<T> collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        JSLinterAnnotationResult<T> result = this.annotate(collectedInfo);
        if (result == null || !result.hasFileLevelInfo()) {
            JSLinterDescriptor descriptor = JSLinterEditorPanelCreator.getInstance(collectedInfo.getProject()).getDescriptorByInspectionClass(this.getInspectionClass());
            JSLinterEditorNotificationPanel.clearNotification(collectedInfo.getProject(), descriptor.uniqueName(), collectedInfo.getVirtualFile());
        }
        return result;
    }

    @Nullable
    public JSLinterAnnotationResult<T> annotate(@NotNull JSLinterInput<T> input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "annotate"));
        }
        return null;
    }

    public abstract void apply(@NotNull PsiFile var1, @Nullable JSLinterAnnotationResult<T> var2, @NotNull AnnotationHolder var3);

    @Nullable
    protected static Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull PsiFile file, @NotNull Document document, @NotNull JSLinterError linterError, @NotNull String messagePrefix, int tabSize, @NotNull HighlightSeverity defaultSeverity, @Nullable TextAttributes defaultSeverityTextAttributes, @NotNull HighlightDisplayKey inspectionKey, @NotNull HighlightingGranularity highlightingGranularity) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (linterError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterError", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (messagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagePrefix", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (defaultSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSeverity", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (highlightingGranularity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingGranularity", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        return JSLinterExternalAnnotator.createAnnotation(holder, file, document, linterError, messagePrefix, tabSize, defaultSeverity, defaultSeverityTextAttributes, null, inspectionKey, highlightingGranularity);
    }

    @Nullable
    protected static Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull PsiFile file, @NotNull Document document, @NotNull JSLinterError linterError, @NotNull String messagePrefix, int tabSize, @NotNull HighlightSeverity defaultSeverity, @Nullable TextAttributes defaultSeverityTextAttributes, @Nullable Function<HighlightSeverity, TextAttributes> severityTextAttributesProvider, @NotNull HighlightDisplayKey inspectionKey, @NotNull HighlightingGranularity highlightingGranularity) {
        TextAttributes severityTextAttributes;
        HighlightSeverity severity;
        int errorLineStartOffset;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (linterError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linterError", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (messagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagePrefix", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (defaultSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSeverity", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        if (highlightingGranularity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingGranularity", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "createAnnotation"));
        }
        int errorLine = linterError.getLine() - 1;
        int errorColumn = linterError.getColumn() - 1;
        if (errorLine < 0 || errorLine >= document.getLineCount()) {
            return null;
        }
        int lineEndOffset = document.getLineEndOffset(errorLine);
        int lineStartOffset = document.getLineStartOffset(errorLine);
        if (errorColumn == -1) {
            errorLineStartOffset = HighlightingGranularity.line == highlightingGranularity ? lineStartOffset : lineEndOffset;
        } else {
            errorLineStartOffset = JSLinterExternalAnnotator.calcErrorStartOffsetInDocument(document, lineStartOffset, lineEndOffset, errorColumn, tabSize);
            errorLineStartOffset = Math.min(errorLineStartOffset, document.getTextLength() - 1);
        }
        if (errorLineStartOffset == -1) {
            return null;
        }
        PsiElement element = file.findElementAt(errorLineStartOffset);
        if (element != null && element.isValid()) {
            Set suppressors = InspectionProfileEntry.getSuppressors((PsiElement)element);
            for (InspectionSuppressor suppressor : suppressors) {
                if (!suppressor.isSuppressedFor(element, inspectionKey.getID())) continue;
                return null;
            }
        }
        TextRange range = HighlightingGranularity.line.equals((Object)highlightingGranularity) ? new TextRange(lineStartOffset, lineEndOffset) : (HighlightingGranularity.element.equals((Object)highlightingGranularity) && element != null && element.isValid() ? element.getTextRange() : new TextRange(errorLineStartOffset, errorLineStartOffset + 1));
        String message = messagePrefix + linterError.getDescription();
        String code = linterError.getCode();
        if (code != null) {
            message = message + " (" + code + ")";
        }
        if ((severity = linterError.getSeverity()) != null) {
            if (severityTextAttributesProvider == null) {
                throw new AssertionError();
            }
            severityTextAttributes = (TextAttributes)severityTextAttributesProvider.fun((Object)severity);
        } else {
            severity = defaultSeverity;
            severityTextAttributes = defaultSeverityTextAttributes;
        }
        Annotation annotation = JSLinterUtil.createAnnotation(holder, severity, severityTextAttributes, range, message);
        annotation.setAfterEndOfLine(errorLineStartOffset == lineEndOffset);
        return annotation;
    }

    private static int calcErrorStartOffsetInDocument(@NotNull Document document, int lineStartOffset, int lineEndOffset, int errorColumn, int tabSize) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterExternalAnnotator", "calcErrorStartOffsetInDocument"));
        }
        if (tabSize <= 1) {
            if (errorColumn < 0) {
                return lineStartOffset;
            }
            if (lineStartOffset + errorColumn <= lineEndOffset) {
                return lineStartOffset + errorColumn;
            }
            return lineEndOffset;
        }
        CharSequence docText = document.getCharsSequence();
        int offset = lineStartOffset;
        for (int col = 0; offset < lineEndOffset && col < errorColumn; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
        }
        return offset;
    }

    protected static enum HighlightingGranularity {
        none,
        line,
        element;

    }
}

