/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterGuesser
implements DirectoryProjectConfigurator {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.JSLinterGuesser");

    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/linter/JSLinterGuesser", "configureProject"));
        }
        if (project.isDefault()) {
            return;
        }
        Set<Object> dependencies = Collections.emptySet();
        Set<Object> topLevelProperties = Collections.emptySet();
        PackageJsonData data = JSLinterGuesser.getProjectPackageJsonData(project);
        if (data != null) {
            dependencies = data.getAllDependencies();
            topLevelProperties = data.getTopLevelProperties();
        }
        JSLinterDescriptor[] linterDescriptors = (JSLinterDescriptor[])JSLinterDescriptor.EP_NAME.getExtensions();
        ArrayList<JSLinterDescriptor> checkForConfig = new ArrayList<JSLinterDescriptor>();
        for (JSLinterDescriptor descriptor : linterDescriptors) {
            boolean packageNameInDependencies = dependencies.contains(descriptor.packageName());
            if (packageNameInDependencies || topLevelProperties.contains(descriptor.packageJsonSectionName())) {
                if (LOG.isDebugEnabled()) {
                    String reason = packageNameInDependencies ? ", because package.json contains " + descriptor.packageName() + " in dependencies" : ", because package.json has a section " + descriptor.packageJsonSectionName();
                    LOG.debug("Turning on " + descriptor.uniqueName() + " in project " + project.getName() + reason);
                }
                JSLinterInspection.setToolEnabled(project, descriptor.getInspectionClass(), true);
                continue;
            }
            checkForConfig.add(descriptor);
        }
        if (!checkForConfig.isEmpty()) {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                for (JSLinterDescriptor descriptor : checkForConfig) {
                    if (!descriptor.hasConfigFiles(project)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Turning on " + descriptor.uniqueName() + " in project " + project.getName() + ", because a config file found.");
                    }
                    JSLinterInspection.setToolEnabled(project, descriptor.getInspectionClass(), true);
                }
            });
        }
    }

    @Nullable
    public static PackageJsonData getProjectPackageJsonData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterGuesser", "getProjectPackageJsonData"));
        }
        if (project.isDefault()) {
            return null;
        }
        VirtualFile packageJson = project.getBaseDir().findChild("package.json");
        if (packageJson != null && packageJson.isValid()) {
            return PackageJsonData.parse(packageJson, null);
        }
        return null;
    }
}

