/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jscs.JscsCheckStyleOutputFormatParser;
import com.intellij.lang.javascript.linter.jscs.JscsConfigCopier;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigFileSearcher;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Producer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JscsExternalRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    @NonNls
    private static final String CONFIGURATION_FILE_FOR_JSCS_IS_NOT_FOUND = "Configuration file for JSCS is not found";
    public static final int TIMEOUT_IN_MILLISECONDS = (int)TimeUnit.SECONDS.toMillis(10L);
    private final JSLinterInput<JscsState> myInputInfo;
    private final FilesMirror myCodeFilesMirror;
    private final FilesMirror myConfigFilesMirror;
    private final Project myProject;
    private final Getter<File> myEmptyConfig;
    private boolean mySkip;
    private String mySkipReason;
    private final List<Producer<JSLinterAnnotationResult<JscsState>>> mySteps;
    private File myActualConfigFile;
    private File myActualCodeFile;
    private File myNodeFile;
    private File myPackageDir;
    private VirtualFile myConfigVirtualFile;
    private VirtualFile myCodeVirtualFile;
    private File myJscsFile;
    private boolean myFix;
    private File myFoundConfigFile;
    private JscsConfigCopier myCopier;

    public JscsExternalRunner(@NotNull JSLinterInput<JscsState> info, @NotNull FilesMirror filesMirror, @NotNull FilesMirror configMirror, Project project, Getter<File> emptyConfigGetter) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "<init>"));
        }
        if (filesMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesMirror", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "<init>"));
        }
        if (configMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configMirror", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "<init>"));
        }
        this.myInputInfo = info;
        this.myCodeFilesMirror = filesMirror;
        this.myConfigFilesMirror = configMirror;
        this.myProject = project;
        this.myEmptyConfig = emptyConfigGetter;
        this.mySteps = new ArrayList<Producer<JSLinterAnnotationResult<JscsState>>>();
        this.mySteps.add(this.checkExePath());
        this.mySteps.add(this.checkTargetVirtualFile());
        this.mySteps.add(this.checkConfigPath());
        this.mySteps.add(this.checkIfTargetFileChanged());
        this.mySteps.add(this.runExternalProcess());
    }

    public JSLinterAnnotationResult<JscsState> execute() {
        for (Producer<JSLinterAnnotationResult<JscsState>> step : this.mySteps) {
            JSLinterAnnotationResult result = (JSLinterAnnotationResult)step.produce();
            if (result != null) {
                return result;
            }
            if (!this.mySkip) continue;
            return null;
        }
        return null;
    }

    public String getSkipReason() {
        return this.mySkipReason;
    }

    private void skip(String reason) {
        this.mySkip = true;
        this.mySkipReason = reason;
    }

    private Producer<JSLinterAnnotationResult<JscsState>> runExternalProcess() {
        return () -> {
            CapturingProcessHandler processHandler;
            File workingDirectory = this.myActualCodeFile.getParentFile();
            if (workingDirectory == null) {
                LOG.debug("Skipped JSCS file analysis: can not find working directory for file: " + this.myActualCodeFile.getPath());
                this.skip("Can not find working directory for file: " + this.myActualCodeFile.getPath());
                return null;
            }
            JscsConfigFileChangeTracker.getInstance(this.myProject).startIfNeeded();
            String error = null;
            ProcessOutput processOutput = null;
            JscsCheckStyleOutputFormatParser parser = null;
            GeneralCommandLine commandLine = this.createCommandLine(workingDirectory);
            try {
                processHandler = new CapturingProcessHandler(commandLine);
            }
            catch (ExecutionException e) {
                error = "Can not start JSCS process: " + e.getMessage();
                processHandler = null;
            }
            if (processHandler != null) {
                parser = new JscsCheckStyleOutputFormatParser(this.myActualCodeFile.getPath());
                processHandler.addProcessListener((ProcessListener)parser);
                processOutput = processHandler.runProcess(TIMEOUT_IN_MILLISECONDS);
                if (processOutput.isTimeout()) {
                    return JSLinterAnnotationResult.create(this.myInputInfo, new JSLinterFileLevelAnnotation("Process timed out after " + DateFormatUtil.formatDuration((long)TIMEOUT_IN_MILLISECONDS)), this.myConfigVirtualFile);
                }
                parser.process();
                String string = error = parser.getGlobalError() == null ? null : parser.getGlobalError().getDescription();
            }
            if (error != null) {
                IntentionAction details = processHandler == null ? null : JSLinterUtil.createDetailsAction(this.myProject, this.myCodeVirtualFile, commandLine, processOutput, null);
                return JSLinterAnnotationResult.create(this.myInputInfo, new JSLinterFileLevelAnnotation(error, details), this.myConfigVirtualFile);
            }
            return JSLinterAnnotationResult.createLinterResult(this.myInputInfo, parser.getErrors(), this.myConfigVirtualFile);
        };
    }

    private JSLinterAnnotationResult<JscsState> createError(JSLinterFileLevelAnnotation error) {
        return JSLinterAnnotationResult.create(this.myInputInfo, error, this.myConfigVirtualFile);
    }

    private JSLinterAnnotationResult<JscsState> createError(String error) {
        return JSLinterAnnotationResult.create(this.myInputInfo, new JSLinterFileLevelAnnotation(error), this.myConfigVirtualFile);
    }

    @NotNull
    public GeneralCommandLine createCommandLine(@NotNull File workingDir) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        CommandLineUtil.configureShellEnvironment((GeneralCommandLine)commandLine, (boolean)true, Collections.emptyMap());
        commandLine.withWorkDirectory(workingDir);
        commandLine.setExePath(this.myNodeFile.getAbsolutePath());
        commandLine.addParameter(this.myJscsFile.getAbsolutePath());
        this.esNextParameters(commandLine);
        if (this.myFix) {
            commandLine.addParameter("-x");
        } else {
            commandLine.addParameters(new String[]{"-v", "-r", "checkstyle"});
        }
        JscsPreset preset = this.myInputInfo.getState().getPreset();
        if (preset != null) {
            commandLine.addParameters(new String[]{"--preset", preset.getCode()});
        }
        if (this.myActualConfigFile != null) {
            commandLine.addParameters(new String[]{"-c", this.myActualConfigFile.getAbsolutePath()});
        }
        commandLine.addParameters(new String[]{this.myActualCodeFile.getAbsolutePath()});
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/JscsExternalRunner", "createCommandLine"));
        }
        return generalCommandLine;
    }

    private void esNextParameters(GeneralCommandLine commandLine) {
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(this.myInputInfo.getPsiFile());
        if (!this.myCopier.isUseEsNext() && !this.myCopier.isUseEs3() && (DialectOptionHolder.JSX.equals((Object)dialect) || dialect != null && dialect.isECMA6)) {
            commandLine.addParameters(new String[]{"--esnext"});
        }
    }

    public void setFix(boolean fix) {
        this.myFix = fix;
    }

    public Producer<JSLinterAnnotationResult<JscsState>> checkExePath() {
        return () -> {
            String nodePath;
            JscsState state = this.myInputInfo.getState();
            NodeJsInterpreter interpreter = state.getInterpreterRef().resolve(this.myProject);
            String string = nodePath = interpreter == null ? "" : interpreter.getPresentableName();
            if (StringUtil.isEmptyOrSpaces((String)nodePath)) {
                return this.createError("Node interpreter file is not specified");
            }
            this.myNodeFile = new File(nodePath);
            if (!(this.myNodeFile.isFile() && this.myNodeFile.isAbsolute() && this.myNodeFile.canExecute())) {
                return this.createError("Node interpreter file is not found");
            }
            String packagePath = state.getPackagePath();
            if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
                return this.createError(JSLinterUtil.getLinterPackageMissingError(this.myProject, packagePath, "JSCS"));
            }
            this.myPackageDir = new File(packagePath);
            if (this.myPackageDir.isDirectory()) {
                if (!this.myPackageDir.isAbsolute()) {
                    return this.createError(JSLinterUtil.getLinterPackageMissingError(this.myProject, packagePath, "JSCS"));
                }
                this.myJscsFile = new File(this.myPackageDir, "bin" + File.separator + "jscs");
            } else {
                this.myJscsFile = this.myPackageDir;
            }
            if (!this.myJscsFile.exists()) {
                if (this.myPackageDir.exists() && this.myJscsFile == this.myPackageDir) {
                    return this.createError(JSLinterUtil.getLinterPackageMissingError(this.myProject, packagePath, "JSCS"));
                }
                return this.createError("Can not find 'jscs' script file under JSCS package directory");
            }
            return null;
        };
    }

    private Producer<JSLinterAnnotationResult<JscsState>> checkConfigPath() {
        return () -> {
            JscsState state = this.myInputInfo.getState();
            boolean configExactlyNamed = false;
            if (state.isCustomConfigFileUsed()) {
                String configFilePath = state.getCustomConfigFilePath();
                if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
                    return this.createError("Configuration file for JSCS is not specified");
                }
                this.myFoundConfigFile = new File(configFilePath);
            } else {
                JscsConfigFileSearcher searcher = new JscsConfigFileSearcher(this.myProject, this.myCodeVirtualFile);
                searcher.lookup();
                if (searcher.getError() != null) {
                    return this.createError(searcher.getError());
                }
                if (searcher.getPackage() != null) {
                    this.myFoundConfigFile = searcher.getPackage();
                    configExactlyNamed = true;
                } else if (searcher.getConfig() != null) {
                    this.myFoundConfigFile = searcher.getConfig();
                } else if (state.getPreset() != null) {
                    this.myFoundConfigFile = (File)this.myEmptyConfig.get();
                    if (this.myFoundConfigFile == null || !this.myFoundConfigFile.isFile() || !this.myFoundConfigFile.isAbsolute()) {
                        return this.createError("Can not create fictive empty config to run JSCS on (to ignore configs above project and use only preset) for file: " + this.myInputInfo.getPsiFile().getName());
                    }
                } else {
                    return this.createError(CONFIGURATION_FILE_FOR_JSCS_IS_NOT_FOUND);
                }
            }
            if (!this.myFoundConfigFile.isFile() || !this.myFoundConfigFile.isAbsolute()) {
                return this.createError(CONFIGURATION_FILE_FOR_JSCS_IS_NOT_FOUND);
            }
            this.myConfigVirtualFile = VfsUtil.findFileByIoFile((File)this.myFoundConfigFile, (boolean)false);
            if (this.myConfigVirtualFile == null || !this.myConfigVirtualFile.isValid()) {
                LOG.debug("Skipped JSCS file analysis: can not load config file as virtual file: " + this.myFoundConfigFile.getPath());
                this.skip("Can not load config file as virtual file: " + this.myFoundConfigFile.getPath());
                return null;
            }
            if (this.configIgnoresFile()) {
                LOG.debug("Skipped JSCS file analysis: ignored in config: " + this.myFoundConfigFile.getPath());
                this.skip("Ignored in config: " + this.myFoundConfigFile.getPath());
                return null;
            }
            this.myCopier = new JscsConfigCopier(this.myProject, this.myConfigVirtualFile, FileDocumentManager.getInstance().isFileModified(this.myConfigVirtualFile));
            String newContent = this.myCopier.process();
            if (this.myCopier.getError() != null) {
                return this.createError(this.myCopier.getError());
            }
            File file = this.myActualConfigFile = configExactlyNamed ? this.myConfigFilesMirror.getOrCreateExactlyNamed(this.myConfigVirtualFile, newContent) : this.myConfigFilesMirror.getOrCreateFileWithActualContent(this.myConfigVirtualFile, newContent);
            if (this.myActualConfigFile == null) {
                LOG.debug("Skipped JSCS file analysis: can not mirror config file in temp directory: " + this.myFoundConfigFile.getPath());
                this.skip("Can not mirror config file in temp directory: " + this.myFoundConfigFile.getPath());
            }
            return null;
        };
    }

    private boolean configIgnoresFile() {
        Application application = ApplicationManager.getApplication();
        List excludedPaths = (List)application.runReadAction((Computable)new Computable<List<String>>(){

            public List<String> compute() {
                Document document = FileDocumentManager.getInstance().getDocument(JscsExternalRunner.this.myConfigVirtualFile);
                if (document == null) {
                    return Collections.emptyList();
                }
                return JscsConfigHelper.getExcludedPaths(JscsExternalRunner.this.myProject, document);
            }
        });
        if (excludedPaths == null || excludedPaths.isEmpty()) {
            return false;
        }
        File codeFile = new File(FileUtil.toSystemDependentName((String)this.myCodeVirtualFile.getPath()));
        String relativeCodeFile = FileUtil.getRelativePath((File)new File(this.myConfigVirtualFile.getParent().getPath()), (File)codeFile);
        if (relativeCodeFile == null) {
            return false;
        }
        relativeCodeFile = JscsExternalRunner.ensureStartWithDot(FileUtil.toSystemIndependentName((String)relativeCodeFile));
        for (String path : excludedPaths) {
            if (!FilenameUtils.wildcardMatch((String)relativeCodeFile, (String)(path = JscsExternalRunner.ensureStartWithDot(path)))) continue;
            return true;
        }
        return false;
    }

    private static String ensureStartWithDot(String path) {
        if (FileUtil.isAbsolute((String)path)) {
            return path;
        }
        if (path.startsWith(".")) {
            return path;
        }
        if (path.startsWith("/")) {
            return "." + path;
        }
        return "./" + path;
    }

    private Producer<JSLinterAnnotationResult<JscsState>> checkTargetVirtualFile() {
        return () -> {
            PsiFile psiFile = this.myInputInfo.getPsiFile();
            this.myCodeVirtualFile = psiFile.getVirtualFile();
            if (this.myCodeVirtualFile == null || !this.myCodeVirtualFile.isValid()) {
                LOG.debug("Skipped JSCS file analysis: can not load target file as virtual file: " + psiFile.getName());
                this.skip("Can not load target file as virtual file: " + psiFile.getName());
                return null;
            }
            return null;
        };
    }

    private Producer<JSLinterAnnotationResult<JscsState>> checkIfTargetFileChanged() {
        return () -> {
            PsiFile psiFile = this.myInputInfo.getPsiFile();
            this.myActualCodeFile = this.myCodeFilesMirror.getOrCreateFileWithActualContent(this.myCodeVirtualFile, this.myInputInfo.getFileContent());
            if (this.myActualCodeFile == null) {
                LOG.debug("Skipped JSCS file analysis: can not mirror target file in temp directory: " + psiFile.getName());
                this.skip("Can not mirror target file in temp directory: " + psiFile.getName());
            }
            return null;
        };
    }
}

