/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.importer;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.NodeModuleConfigurationView;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import com.intellij.lang.javascript.linter.jscs.JscsState;
import com.intellij.lang.javascript.linter.jscs.JscsView;
import com.intellij.lang.javascript.linter.jscs.importer.JscsSchemeImportWorker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Alarm;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsSchemeImporter
implements SchemeImporter<CodeStyleScheme> {
    @NotNull
    public String[] getSourceExtensions() {
        String[] stringArray = new String[]{"jscsrc", "json"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImporter", "getSourceExtensions"));
        }
        return stringArray;
    }

    @Nullable
    public CodeStyleScheme importScheme(@NotNull Project project, @NotNull VirtualFile selectedFile, @NotNull CodeStyleScheme currentScheme, @NotNull SchemeFactory<CodeStyleScheme> newSchemeFactory) throws SchemeImportException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImporter", "importScheme"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImporter", "importScheme"));
        }
        if (currentScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScheme", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImporter", "importScheme"));
        }
        if (newSchemeFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSchemeFactory", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImporter", "importScheme"));
        }
        OptionsRetriever retriever = new OptionsRetriever();
        Getter schemeFactory = retriever.showOptionsDialog(project, currentScheme, (SchemeFactory<CodeStyleScheme>)newSchemeFactory);
        if (schemeFactory == null) {
            return null;
        }
        JscsSchemeImportWorker worker = new JscsSchemeImportWorker(project, selectedFile);
        return worker.importScheme((Getter<CodeStyleScheme>)schemeFactory, retriever.getPreset(), retriever.getPackagePath());
    }

    @Nullable
    public String getAdditionalImportInfo(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImporter", "getAdditionalImportInfo"));
        }
        return "<br/>See details in Event Log";
    }

    private static class OptionsRetriever {
        private JscsPreset myPreset;
        private String myPackagePath;
        private SchemeFactory<CodeStyleScheme> myFactory;

        private OptionsRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Getter<CodeStyleScheme> showOptionsDialog(Project project, CodeStyleScheme currentScheme, SchemeFactory<CodeStyleScheme> schemeFactory) {
            JBRadioButton useCurrent;
            final ComponentWithBrowseButton<ComboBox> presets = JscsView.createPresetWithHelpButton();
            JEditorPane presetHintComp = JSLinterUtil.createHtmlViewer(JSBundle.message((String)"jscs.configurable.preset.hint.text", (Object[])new Object[0]), UIUtil.getTitledBorderFont());
            JPanel presetHint = SwingHelper.wrapWithHorizontalStretch((JComponent)presetHintComp);
            FormBuilder formBuilder = FormBuilder.createFormBuilder();
            JBTextField schemeName = new JBTextField("JSCS");
            if (currentScheme.isDefault()) {
                useCurrent = null;
                formBuilder.addLabeledComponent("Create new scheme", (JComponent)schemeName);
            } else {
                useCurrent = new JBRadioButton("Update current scheme (" + currentScheme.getName() + ")");
                JBRadioButton createNew = new JBRadioButton("Create new scheme:");
                ButtonGroup group = new ButtonGroup();
                group.add((AbstractButton)useCurrent);
                group.add((AbstractButton)createNew);
                createNew.setSelected(true);
                formBuilder.addComponent((JComponent)useCurrent).addLabeledComponent((JComponent)createNew, (JComponent)schemeName).setFormLeftIndent(0).addVerticalGap(5);
            }
            JscsConfiguration jscsConfiguration = JscsConfiguration.getInstance(project);
            NodeJsInterpreterRef nodePath = ((JscsState)jscsConfiguration.getExtendedState().getState()).getInterpreterRef();
            NodeModuleConfigurationView configurationView = new NodeModuleConfigurationView(project, "jscs", "JSCS", nodePath);
            NodeJsInterpreterField nodeField = configurationView.getNodeInterpreterField();
            final NodePackageField packageField = configurationView.getPackageField();
            NodePackage jscs = NodePackage.findDefaultPackage(project, "jscs", nodePath.resolve(project));
            if (jscs != null) {
                packageField.setSelected(jscs);
            }
            configurationView.setPreferredWidthToComponents();
            formBuilder.addLabeledComponent("&Node interpreter:", (JComponent)((Object)nodeField)).addLabeledComponent(JSBundle.message((String)"jscs.configurable.label.package.path", (Object[])new Object[0]), (JComponent)((Object)packageField));
            formBuilder.addLabeledComponent(JSBundle.message((String)"jscs.configurable.label.preset.label.text", (Object[])new Object[0]), presets).addLabeledComponent("", (JComponent)presetHint);
            final DialogBuilder builder = new DialogBuilder();
            builder.setTitle("Import from JSCS config");
            builder.setNorthPanel((JComponent)formBuilder.getPanel());
            builder.setDimensionServiceKey(JscsSchemeImportWorker.class.getName());
            builder.setPreferredFocusComponent((JComponent)schemeName);
            final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
            try {
                Runnable validation = new Runnable(){

                    @Override
                    public void run() {
                        DialogWrapper dialogWrapper = builder.getDialogWrapper();
                        try {
                            if (dialogWrapper == null) {
                                return;
                            }
                            if ((JscsPreset)((Object)((ComboBox)presets.getChildComponent()).getSelectedItem()) != null && StringUtil.isEmptyOrSpaces((String)packageField.getSelected().getSystemDependentPath())) {
                                builder.okActionEnabled(false);
                                builder.setErrorText("JSCS package field should be filled if preset is selected.");
                            } else {
                                builder.okActionEnabled(true);
                                builder.setErrorText(null);
                            }
                        }
                        finally {
                            if (!alarm.isDisposed()) {
                                alarm.addRequest((Runnable)this, 200, true);
                            }
                        }
                    }
                };
                alarm.addRequest(validation, 200, ModalityState.any());
                if (!builder.showAndGet()) {
                    Getter<CodeStyleScheme> getter = null;
                    return getter;
                }
            }
            finally {
                alarm.cancelAllRequests();
                Disposer.dispose((Disposable)alarm);
            }
            this.myPreset = (JscsPreset)((Object)((ComboBox)presets.getChildComponent()).getSelectedItem());
            this.myPackagePath = packageField.getSelected().getSystemDependentPath();
            return () -> {
                if (useCurrent != null && useCurrent.isSelected()) {
                    return currentScheme;
                }
                String text = schemeName.getText();
                return (CodeStyleScheme)schemeFactory.createNewScheme(StringUtil.isEmptyOrSpaces((String)text) ? null : text);
            };
        }

        public JscsPreset getPreset() {
            return this.myPreset;
        }

        public String getPackagePath() {
            return this.myPackagePath;
        }
    }
}

