/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.tslint.TsLintBinFileVersionManager;
import com.intellij.lang.javascript.linter.tslint.TsLintConfigurable;
import com.intellij.lang.javascript.linter.tslint.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.TsLintExternalRunner;
import com.intellij.lang.javascript.linter.tslint.TsLintInspection;
import com.intellij.lang.javascript.linter.tslint.TsLintState;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintExternalAnnotator
extends JSLinterExternalAnnotator<TsLintState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");
    private static final TsLintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new TsLintExternalAnnotator(false);
    private static final String TSLINT_CODE_TEMP_FILE_MAP_KEY_NAME = "TSLINT_CODE_TEMP_FILE_MAP_KEY";
    private static final String TSLINT_CONFIG_TEMP_FILE_MAP_KEY_NAME = "TSLINT_CONFIG_TEMP_FILE_MAP_KEY";
    private final FilesMirror myCodeFilesMirror = new FilesMirror("TSLINT_CODE_TEMP_FILE_MAP_KEY", "tslint");
    private final FilesMirror myConfigFilesMirror = new FilesMirror("TSLINT_CONFIG_TEMP_FILE_MAP_KEY", "tslint");
    private final TsLintBinFileVersionManager myBinFileVersionManager = new TsLintBinFileVersionManager();

    @NotNull
    public static TsLintExternalAnnotator getInstanceForBatchInspection() {
        TsLintExternalAnnotator tsLintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (tsLintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/TsLintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return tsLintExternalAnnotator;
    }

    public TsLintExternalAnnotator() {
        this(true);
    }

    public TsLintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<TsLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/TsLintExternalAnnotator", "createSettingsConfigurable"));
        }
        TsLintConfigurable tsLintConfigurable = new TsLintConfigurable(project, true);
        if (tsLintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/TsLintExternalAnnotator", "createSettingsConfigurable"));
        }
        return tsLintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<TsLintState>> getConfigurationClass() {
        return TsLintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return TsLintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/tslint/TsLintExternalAnnotator", "acceptPsiFile"));
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile(file);
        return holder != null && holder.isTypeScript;
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<TsLintState> doAnnotate(@Nullable JSLinterInput<TsLintState> collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        return new TsLintExternalRunner(collectedInfo, this.myCodeFilesMirror, this.myConfigFilesMirror, this.myBinFileVersionManager, collectedInfo.getProject()).execute();
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<TsLintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/tslint/TsLintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/tslint/TsLintExternalAnnotator", "apply"));
        }
        new JSLinterAnnotationsBuilder<TsLintState>(file, annotationResult, holder, TsLintInspection.getHighlightDisplayKey(), new TsLintConfigurable(file.getProject(), true), "TSLint: ", this.getInspectionClass(), JSLinterStandardFixes.DEFAULT).setHighlightingGranularity(JSLinterExternalAnnotator.HighlightingGranularity.element).apply();
    }
}

