/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.ES6ModulesSuggester;
import com.intellij.lang.javascript.modules.JSBaseModulesDependenciesElementVisitor;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ModulesDependenciesInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        MyJSElementVisitor myJSElementVisitor = new MyJSElementVisitor(session, holder, this.myOnTheFly);
        if (myJSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ES6ModulesDependenciesInspection", "createVisitor"));
        }
        return myJSElementVisitor;
    }

    private static class MyJSElementVisitor
    extends JSBaseModulesDependenciesElementVisitor {
        public MyJSElementVisitor(LocalInspectionToolSession session, ProblemsHolder holder, boolean onTheFly) {
            super(session, holder, onTheFly);
        }

        @Override
        protected String getInspectionText() {
            return JSBundle.message((String)"js.inspection.es6.modules.dependencies.family.name", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        protected JsModulesSuggester createSuggester() {
            if (!DialectDetector.isES6((PsiElement)this.myNode)) {
                return null;
            }
            if (!NodeModuleUtil.isWrappedInAmdDefinition((PsiElement)this.myNode)) {
                return new ES6ModulesSuggester(this.mySession, this.myModuleReferenceInfo, this.myNode);
            }
            return null;
        }
    }
}

