/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.ES6ImportsWorker;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ImportES6ModuleFix
extends ImportCommonJSModuleFix {
    private String myInsertedText;
    private String myCorrectedPath;

    public ImportES6ModuleFix(@NotNull JSReferenceExpression node, @NotNull ModuleFixCreator.FixDescriptor descriptor, boolean singleQuotes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "<init>"));
        }
        super(node, descriptor, singleQuotes);
    }

    @Override
    protected boolean modifyExistingImports(@NotNull PsiElement scope, Editor editor, @NotNull JSReferenceExpression reference) {
        boolean haveReplacement;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "modifyExistingImports"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "modifyExistingImports"));
        }
        ImportData prefix = this.getPrefix();
        JSReferenceExpression replaceTarget = ImportES6ModuleFix.correctReplaceTarget(reference, prefix);
        Trinity<String, PsiElement, ES6ImportDeclaration> existing = ES6ImportsWorker.getExistingImport(scope, this.getPath(), prefix.myImportedText);
        if (existing == null) {
            return false;
        }
        boolean importAllSuggestedForExactImport = existing.getSecond() instanceof ES6ImportedBinding && this.isNeedMemberImport();
        boolean bl = haveReplacement = existing.getFirst() != null && existing.getSecond() != null && !importAllSuggestedForExactImport;
        if (haveReplacement) {
            this.replaceWithNewReference(replaceTarget, editor, (String)existing.getFirst());
            return true;
        }
        if (existing.getThird() != null && !ImportES6ModuleFix.hasNamespaceImport((ES6ImportDeclaration)existing.getThird())) {
            if (prefix.myIsDefault) {
                return false;
            }
            ES6ImportSpecifier importSpecifier = ES6ImportsWorker.insertImportSpecifier((ES6ImportDeclaration)existing.getThird(), prefix.myPrefixText);
            if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                this.replaceWithNewReference(replaceTarget, editor, importSpecifier.getDeclaredName());
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static JSReferenceExpression correctReplaceTarget(@NotNull JSReferenceExpression reference, ImportData prefix) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "correctReplaceTarget"));
        }
        JSReferenceExpression replaceTarget = reference;
        if (prefix.myReplaceTarget != null) {
            replaceTarget = reference;
        } else {
            while (replaceTarget.getQualifier() instanceof JSReferenceExpression) {
                replaceTarget = (JSReferenceExpression)replaceTarget.getQualifier();
            }
        }
        JSReferenceExpression jSReferenceExpression = replaceTarget;
        if (jSReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "correctReplaceTarget"));
        }
        return jSReferenceExpression;
    }

    @Override
    protected void doSomethingWithCurrentFile(JSReferenceExpression element, Editor editor) {
        JSReferenceExpression replaceTarget = ImportES6ModuleFix.correctReplaceTarget(element, this.getPrefix());
        this.replaceWithNewReference(replaceTarget, editor, replaceTarget.getReferenceName());
    }

    private boolean isNeedMemberImport() {
        SmartPsiElementPointer<JSReferenceExpression> rr = this.myFixDescriptor.getTailToReplaceReference();
        String tailName = rr != null && rr.getElement() != null ? this.myFixDescriptor.getTail()[0] : null;
        return !"default".equals(tailName) && rr != null && rr.getElement() != null;
    }

    private static boolean hasNamespaceImport(@NotNull ES6ImportDeclaration declaration) {
        ES6ImportedBinding[] bindings;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "hasNamespaceImport"));
        }
        for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
            if (!binding.isNamespaceImport()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isPreferImportAnchor() {
        return true;
    }

    @Override
    public String getPath() {
        if (this.myCorrectedPath != null) {
            return this.myCorrectedPath;
        }
        String path = super.getPath();
        int slashIdx = path.lastIndexOf(47);
        int dotIdx = path.lastIndexOf(46);
        this.myCorrectedPath = path;
        if (dotIdx > 0 && dotIdx > slashIdx) {
            this.myCorrectedPath = this.myCorrectedPath.substring(0, dotIdx);
        }
        return this.myCorrectedPath;
    }

    @Override
    protected PsiElement createRequire(Project project) {
        PsiFile file = ImportES6ModuleFix.createDummyFile(project, this.getInsertedText() + JSCodeStyleSettings.getSemicolon(project));
        return file.getFirstChild();
    }

    private String getInsertedText() {
        if (this.myInsertedText == null) {
            String prefix = this.getPrefix().myPrefixText;
            this.myInsertedText = this.mySingleQuotes ? "import " + prefix + " from '" + this.getPath() + "'" : "import " + prefix + " from \"" + this.getPath() + "\"";
        }
        return this.myInsertedText;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inspection.es6.modules.dependencies.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    private ImportData getPrefix() {
        String varName = this.myFixDescriptor.getFirstWordInFile();
        if (this.myFixDescriptor.isDefaultExport()) {
            ImportData importData = new ImportData(varName, true, varName, null);
            if (importData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
            }
            return importData;
        }
        if (this.myFixDescriptor.getFirstWordInExportsName() != null) {
            if (this.myFixDescriptor.getFirstWordInExportsName().equals(varName)) {
                ImportData importData = new ImportData("{" + varName + "}", false, varName, varName);
                if (importData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
                }
                return importData;
            }
            ImportData importData = new ImportData("{" + this.myFixDescriptor.getFirstWordInExportsName() + " as " + varName + "}", false, varName, this.myFixDescriptor.getFirstWordInExportsName());
            if (importData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
            }
            return importData;
        }
        if (this.myFixDescriptor.getTail() != null) {
            String tail = this.myFixDescriptor.getTail()[0];
            JSReferenceExpression target = this.myFixDescriptor.getTailToReplaceReference() == null ? null : (JSReferenceExpression)this.myFixDescriptor.getTailToReplaceReference().getElement();
            ImportData importData = new ImportData("{" + tail + "}", false, tail, tail).withReplaceTarget(target);
            if (importData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
            }
            return importData;
        }
        ImportData importData = new ImportData("* as " + varName, false, varName, null);
        if (importData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
        }
        return importData;
    }

    @Nls
    @NotNull
    public String getText() {
        char quote = this.mySingleQuotes ? (char)'\"' : '\'';
        String string = "Insert " + quote + this.getInsertedText() + quote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getText"));
        }
        return string;
    }

    private static class ImportData {
        private String myPrefixText;
        private boolean myIsDefault;
        private String myVarText;
        private String myImportedText;
        private JSReferenceExpression myReplaceTarget;

        public ImportData(String prefixText, boolean isDefault, String varText, String importedText) {
            this.myPrefixText = prefixText;
            this.myIsDefault = isDefault;
            this.myVarText = varText;
            this.myImportedText = importedText;
        }

        public ImportData withReplaceTarget(JSReferenceExpression target) {
            this.myReplaceTarget = target;
            return this;
        }
    }
}

