/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.lang.javascript.modules.diagramm.ImportedData;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ES6ModuleDataNode {
    @NotNull
    private final SmartPsiElementPointer<PsiFile> myFilePointer;
    @NotNull
    private final MultiMap<SmartPsiElementPointer<PsiElement>, ImportedData> myDependsMap;
    @NotNull
    private final List<SmartPsiElementPointer<JSNamedElement>> myExportedData;
    private boolean myInScope;

    public ES6ModuleDataNode(@NotNull SmartPsiElementPointer<PsiFile> filePointer) {
        if (filePointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointer", "com/intellij/lang/javascript/modules/diagramm/ES6ModuleDataNode", "<init>"));
        }
        this.myFilePointer = filePointer;
        this.myDependsMap = new MultiMap();
        this.myExportedData = new ArrayList<SmartPsiElementPointer<JSNamedElement>>();
    }

    public void dependsOn(@NotNull SmartPsiElementPointer<PsiElement> source, @NotNull ImportedData target) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/modules/diagramm/ES6ModuleDataNode", "dependsOn"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/modules/diagramm/ES6ModuleDataNode", "dependsOn"));
        }
        this.myDependsMap.putValue(source, (Object)target);
    }

    public void exports(@NotNull SmartPsiElementPointer<JSNamedElement> pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/lang/javascript/modules/diagramm/ES6ModuleDataNode", "exports"));
        }
        this.myExportedData.add(pointer);
    }

    public SmartPsiElementPointer<PsiFile> getFilePointer() {
        return this.myFilePointer;
    }

    @NotNull
    public MultiMap<SmartPsiElementPointer<PsiElement>, ImportedData> getDependsMap() {
        MultiMap<SmartPsiElementPointer<PsiElement>, ImportedData> multiMap = this.myDependsMap;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/ES6ModuleDataNode", "getDependsMap"));
        }
        return multiMap;
    }

    public List<SmartPsiElementPointer<JSNamedElement>> getExportedData() {
        return this.myExportedData;
    }

    public boolean isInScope() {
        return this.myInScope;
    }

    public void inScope() {
        this.myInScope = true;
    }
}

