/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.modules.diagramm.ES6ModuleDataNode;
import com.intellij.lang.javascript.modules.diagramm.ImportedData;
import com.intellij.lang.javascript.modules.diagramm.JSModuleConnectionProvider;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramProvider;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiNode;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSModuleDependencyData {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GlobalSearchScope myScope;
    @NotNull
    private final Map<VirtualFile, ES6ModuleDataNode> myNodes;
    @NotNull
    private final SmartPointerManager mySpm;

    public JSModuleDependencyData(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "<init>"));
        }
        this.myProject = project;
        this.myScope = scope;
        this.mySpm = SmartPointerManager.getInstance((Project)this.myProject);
        this.myNodes = new HashMap<VirtualFile, ES6ModuleDataNode>();
    }

    public void calculate() {
        JSModuleConnectionProvider[] extensions = (JSModuleConnectionProvider[])Extensions.getExtensions(JSModuleConnectionProvider.EXTENSION_POINT_NAME);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> {
            FileBasedIndex.getInstance().iterateIndexableFiles(fileOrDir -> {
                if (this.myScope.contains(fileOrDir) && !fileOrDir.isDirectory()) {
                    PsiFile psiFile = psiManager.findFile(fileOrDir);
                    if (psiFile == null) {
                        return true;
                    }
                    JSModuleDependencyData.setProgressText(psiFile);
                    if (fileOrDir.getFileType() instanceof LanguageFileType && ((LanguageFileType)fileOrDir.getFileType()).getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                        this.jsDetection((PsiElement)psiFile);
                    } else if (HtmlFileType.INSTANCE.equals(fileOrDir.getFileType())) {
                        Collection embeddedContents = PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, JSEmbeddedContent.class);
                        if (!embeddedContents.isEmpty()) {
                            for (JSEmbeddedContent content : embeddedContents) {
                                this.jsDetection((PsiElement)content);
                            }
                        }
                        this.includedFilesDetection(psiFile);
                    } else if (CssFileType.INSTANCE.equals(fileOrDir.getFileType())) {
                        this.includedFilesDetection(psiFile);
                    }
                    for (JSModuleConnectionProvider extension : extensions) {
                        List<JSModuleConnectionProvider.Link> dependencies = extension.getDependencies(psiFile);
                        if (dependencies == null) continue;
                        for (JSModuleConnectionProvider.Link dependency : dependencies) {
                            ES6ModuleDataNode node = this.getNode((PsiElement)psiFile);
                            ES6ModuleDataNode target = this.getNode(dependency.getTarget().getElement());
                            ImportedData importedData = new ImportedData(dependency.getSourceName(), dependency.getTargetName(), dependency.getTarget(), target);
                            importedData.setProvider(extension);
                            node.dependsOn(dependency.getSource(), importedData);
                        }
                    }
                }
                return true;
            }, this.myProject, ProgressManager.getInstance().getProgressIndicator());
            for (Map.Entry<VirtualFile, ES6ModuleDataNode> entry : this.myNodes.entrySet()) {
                if (!this.myScope.contains(entry.getKey())) continue;
                entry.getValue().inScope();
            }
        });
    }

    private static void setProgressText(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "setProgressText"));
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.setText("Processing " + psiFile.getName() + (psiFile.getParent() == null ? "" : " (" + psiFile.getParent().getVirtualFile().getPath() + ")"));
        }
    }

    private void includedFilesDetection(PsiFile file) {
        VirtualFile[] files;
        for (VirtualFile virtualFile : files = FileIncludeManager.getManager((Project)file.getProject()).getIncludedFiles(file.getVirtualFile(), true)) {
            PsiFile dependencyFile = file.getManager().findFile(virtualFile);
            if (dependencyFile == null) continue;
            ES6ModuleDataNode node = this.getNode((PsiElement)file);
            ES6ModuleDataNode target = this.getNode((PsiElement)dependencyFile);
            node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)file), new ImportedData(dependencyFile.getName(), dependencyFile.getName(), (SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)dependencyFile), target));
        }
    }

    private void jsDetection(PsiElement context) {
        if (ES6CoolRefactoring.isEs6Compatible(context)) {
            this.es6Detection(context);
        }
        this.requireAndDefineArgumentDetection(context);
    }

    private void requireAndDefineArgumentDetection(PsiElement context) {
        Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)context, JSCallExpression.class);
        for (JSCallExpression expression : expressions) {
            JSArrayLiteralExpression array;
            JSAmdUtil.AmdLoaderCallParametersChecker checker;
            if (expression.isRequireCall()) {
                JSExpression argument;
                PsiReference reference;
                if (expression.getParent() instanceof JSReferenceExpression) {
                    JSReferenceExpression topReference = (JSReferenceExpression)JSResolveUtil.getTopReferenceExpression(expression.getParent());
                    PsiElement resolve = topReference.resolve();
                    if (!(resolve instanceof JSNamedElement) || !resolve.isValid() || ((JSNamedElement)resolve).getName() == null) continue;
                    ES6ModuleDataNode node = this.getNode(context);
                    ES6ModuleDataNode target = this.getNode((PsiElement)resolve.getContainingFile());
                    node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)topReference), new ImportedData(((JSNamedElement)resolve).getName(), ((JSNamedElement)resolve).getName(), (SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer(resolve), target));
                    continue;
                }
                JSExpression[] arguments = expression.getArguments();
                if (arguments.length != 1 || (reference = JSModuleDependencyData.findReference(context, argument = arguments[0])) == null) continue;
                this.addFileReference(context, argument, reference);
                continue;
            }
            if (!expression.isDefineCall() || !(checker = new JSAmdUtil.AmdLoaderCallParametersChecker(expression.getArguments())).isCorrect() || (array = checker.getArray()) == null) continue;
            for (JSExpression ref : array.getExpressions()) {
                PsiReference reference = JSModuleDependencyData.findReference(context, ref);
                if (reference == null) continue;
                this.addFileReference(context, ref, reference);
            }
        }
    }

    private void addFileReference(PsiElement context, JSExpression argument, PsiReference reference) {
        PsiElement resolve = reference.resolve();
        if (!(resolve instanceof PsiFile) || !resolve.isValid()) {
            return;
        }
        ES6ModuleDataNode node = this.getNode(context);
        ES6ModuleDataNode target = this.getNode((PsiElement)resolve.getContainingFile());
        node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)argument), new ImportedData(resolve.getContainingFile().getName(), resolve.getContainingFile().getName(), (SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer(resolve), target));
    }

    private static PsiReference findReference(PsiElement context, JSExpression argument) {
        int offset = argument.getTextRange().isEmpty() ? argument.getTextRange().getStartOffset() : argument.getTextRange().getEndOffset() - 1;
        return context.findReferenceAt(offset);
    }

    private void es6Detection(PsiElement context) {
        Collection declarations = PsiTreeUtil.findChildrenOfType((PsiElement)context, ES6ImportDeclaration.class);
        for (ES6ImportDeclaration declaration : declarations) {
            ES6ImportSpecifier[] specifiers;
            PsiElement referencedFile;
            PsiReference fromClauseReference;
            ES6FromClause fromClause = declaration.getFromClause();
            if (fromClause == null || (fromClauseReference = fromClause.getReference()) == null || (referencedFile = fromClauseReference.resolve()) == null || !referencedFile.isValid()) continue;
            ES6ImportedBinding[] bindings = declaration.getImportedBindings();
            for (ES6ImportSpecifier eS6ImportSpecifier : specifiers = declaration.getImportSpecifiers()) {
                String name;
                PsiElement resolve;
                if (!(eS6ImportSpecifier.getReference() instanceof PsiElement) || !((resolve = eS6ImportSpecifier.getReference().resolve()) instanceof JSNamedElement) || !resolve.isValid()) continue;
                ES6ModuleDataNode node = this.getNode(context);
                ES6ModuleDataNode target = this.getNode((PsiElement)resolve.getContainingFile());
                String string = name = eS6ImportSpecifier.getAlias() != null ? eS6ImportSpecifier.getAlias().getName() : eS6ImportSpecifier.getReferenceName();
                assert (name != null);
                node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)eS6ImportSpecifier), new ImportedData(name, ((JSNamedElement)resolve).getName(), (SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer(resolve), target));
            }
            for (ES6ImportSpecifier eS6ImportSpecifier : bindings) {
                if (eS6ImportSpecifier.getName() == null) continue;
                ES6ModuleDataNode node = this.getNode(context);
                ES6ModuleDataNode target = this.getNode((PsiElement)referencedFile.getContainingFile());
                node.dependsOn((SmartPsiElementPointer<PsiElement>)this.mySpm.createSmartPsiElementPointer((PsiElement)eS6ImportSpecifier), new ImportedData(eS6ImportSpecifier.getName(), referencedFile.getContainingFile().getName(), null, target));
            }
        }
    }

    public Pair<List<JSStructuralUiNode>, List<JSStructuralUiEdge>> getNodesAndEdges(@NotNull JSModulesDiagramProvider provider) {
        PsiFile psiFile;
        ES6ModuleDataNode node;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/lang/javascript/modules/diagramm/JSModuleDependencyData", "getNodesAndEdges"));
        }
        if (this.myNodes.isEmpty()) {
            return Pair.create(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myNodes.keySet());
        Collections.sort(files, Comparator.comparing(VirtualFile::getName));
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)this.myProject);
        HashMap<PsiFile, JSStructuralUiNode> createdNodes = new HashMap<PsiFile, JSStructuralUiNode>();
        ArrayList<JSStructuralUiNode> nodes = new ArrayList<JSStructuralUiNode>();
        HashMap<JSStructuralUiEdge, JSStructuralUiEdge> edges = new HashMap<JSStructuralUiEdge, JSStructuralUiEdge>();
        for (VirtualFile file : files) {
            node = this.myNodes.get(file);
            psiFile = node.getFilePointer().getContainingFile();
            if (psiFile == null) continue;
            JSStructuralDiagramItem item = new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), JSModulesDiagramUtils.getFileNamePart(psiFile), true).setInScope(node.isInScope());
            JSStructuralUiNode uiNode = new JSStructuralUiNode(item, (DiagramProvider<JSStructuralDiagramItem>)provider);
            nodes.add(uiNode);
            createdNodes.put(psiFile, uiNode);
        }
        for (VirtualFile file : files) {
            node = this.myNodes.get(file);
            psiFile = node.getFilePointer().getContainingFile();
            if (psiFile == null) continue;
            for (Map.Entry entry : node.getDependsMap().entrySet()) {
                PsiFile sourceFile = ((SmartPsiElementPointer)entry.getKey()).getContainingFile();
                JSStructuralUiNode source = (JSStructuralUiNode)((Object)createdNodes.get(sourceFile));
                if (source == null) continue;
                for (ImportedData importedData : (Collection)entry.getValue()) {
                    PsiElement element;
                    ES6ModuleDataNode targetNode = importedData.getTargetNode();
                    JSStructuralUiNode target = (JSStructuralUiNode)((Object)createdNodes.get(targetNode.getFilePointer().getContainingFile()));
                    if (target == null) continue;
                    JSStructuralUiEdge edge = new JSStructuralUiEdge((DiagramNode<JSStructuralDiagramItem>)source, (DiagramNode<JSStructuralDiagramItem>)target);
                    Icon icon = null;
                    if (importedData.getProvider() != null) {
                        edge.setProviderName(importedData.getProvider().getName());
                        edge.setColor(importedData.getProvider().getEdgeColor());
                        icon = importedData.getProvider().getIcon();
                    }
                    if (edges.containsKey((Object)edge)) {
                        edge = (JSStructuralUiEdge)((Object)edges.get((Object)edge));
                    } else {
                        edges.put(edge, edge);
                    }
                    if (importedData.getTargetMemberPointer() != null && (element = importedData.getTargetMemberPointer().getElement()) != null && element.isValid() && !Comparing.equal((Object)element, (Object)targetNode.getFilePointer().getElement())) {
                        JSStructuralDiagramItem targetDetail = new JSStructuralDiagramItem(importedData.getTargetMemberPointer(), importedData.getTargetName(), false);
                        if (icon != null) {
                            targetDetail.setIcon(icon);
                        }
                        target.getIdentifyingElement().addExported(targetDetail);
                        edge.links(importedData.getSourceName(), importedData.getTargetName());
                    }
                    if (sourceFile.getName().equals(importedData.getSourceName()) || importedData.getSourceName().equals(importedData.getTargetName())) continue;
                    JSStructuralDiagramItem sourceDetail = new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)((SmartPsiElementPointer)entry.getKey()), importedData.getSourceName(), false);
                    if (icon != null) {
                        sourceDetail.setIcon(icon);
                    }
                    source.getIdentifyingElement().addExported(sourceDetail);
                }
            }
            for (JSStructuralUiNode uiNode : nodes) {
                uiNode.getIdentifyingElement().sortExported();
            }
        }
        return Pair.create(nodes, new ArrayList(edges.values()));
    }

    private ES6ModuleDataNode getNode(PsiElement context) {
        PsiFile psiFile = context.getContainingFile();
        ES6ModuleDataNode node = this.myNodes.get(psiFile.getVirtualFile());
        if (node == null) {
            node = new ES6ModuleDataNode((SmartPsiElementPointer<PsiFile>)this.mySpm.createSmartPsiElementPointer((PsiElement)psiFile));
            this.myNodes.put(psiFile.getVirtualFile(), node);
        }
        return node;
    }
}

