/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.AbstractUmlVisibilityManager;
import com.intellij.diagram.BaseDiagramProvider;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagramm.JSModuleDependencyData;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramModel;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiEdge;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralUiNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModulesDiagramProvider
extends BaseDiagramProvider<JSStructuralDiagramItem> {
    private static final String FIRST_SHOW_KEY = "js.modules.notification.shown";
    public static final String JAVASCRIPT_MODULES_DIAGRAMM = "JavaScript-modules-diagram";
    public static final VisibilityLevel OVERVIEW = new VisibilityLevel("Overview");
    public static final VisibilityLevel DETAILS = new VisibilityLevel("Details");
    public static final Comparator<VisibilityLevel> COMPARATOR = (o1, o2) -> {
        if (o1.equals(o2)) {
            return 0;
        }
        return OVERVIEW.equals(o1) ? -1 : 1;
    };
    public static final DiagramCategory ALL = new DiagramCategory("All", null);
    private final DiagramVfsResolver<JSStructuralDiagramItem> myResolver = new DiagramVfsResolver<JSStructuralDiagramItem>(){

        public String getQualifiedName(JSStructuralDiagramItem element) {
            if (!element.getUsedExported().isEmpty()) {
                return StringUtil.join((Collection)element.getUsedExported().stream().map(i -> JSModulesDiagramProvider.serializeOneItem(i)).collect(Collectors.toList()), (String)";") + ";";
            }
            return JSModulesDiagramProvider.serializeOneItem(element);
        }

        @Nullable
        public JSStructuralDiagramItem resolveElementByFQN(String fqn, Project project) {
            if (fqn.contains(";")) {
                String[] strings = fqn.split(";");
                JSStructuralDiagramItem item = JSModulesDiagramProvider.this.createProjectItem(project, SmartPointerManager.getInstance((Project)project));
                if (item == null) {
                    return null;
                }
                for (String string : strings) {
                    JSStructuralDiagramItem child = JSModulesDiagramProvider.deserializeOneItem(string, project);
                    if (child == null) {
                        return null;
                    }
                    item.addExported(child);
                }
                return item;
            }
            return JSModulesDiagramProvider.deserializeOneItem(fqn, project);
        }
    };
    private final DiagramElementManager<JSStructuralDiagramItem> myElementManager = new AbstractDiagramElementManager<JSStructuralDiagramItem>(){

        public Object[] getNodeItems(JSStructuralDiagramItem parent) {
            return ArrayUtil.toObjectArray(parent.getUsedExported());
        }

        @Nullable
        public JSStructuralDiagramItem findInDataContext(DataContext context) {
            if (!Registry.is((String)"WebStorm.JavaScript.Modules.Diagram")) {
                return null;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            if (project == null) {
                return null;
            }
            VirtualFile[] data = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
            SmartPointerManager spm = SmartPointerManager.getInstance((Project)project);
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            if (data != null) {
                if (data.length == 1) {
                    PsiDirectory psiFile;
                    Object object = psiFile = data[0].isDirectory() ? psiManager.findDirectory(data[0]) : psiManager.findFile(data[0]);
                    if (psiFile == null) {
                        return null;
                    }
                    return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), data[0].getName(), true);
                }
                JSStructuralDiagramItem item = JSModulesDiagramProvider.this.createProjectItem(project, spm);
                if (item == null) {
                    return null;
                }
                for (VirtualFile file : data) {
                    PsiDirectory psiFile;
                    Object object = psiFile = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
                    if (psiFile == null) continue;
                    item.addExported(new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)psiFile), file.getName(), true));
                }
                return item;
            }
            PsiElement element = (PsiElement)CommonDataKeys.PSI_FILE.getData(context);
            return element == null ? null : new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)spm.createSmartPsiElementPointer((PsiElement)element.getContainingFile()), JSModulesDiagramUtils.getFileNamePart(element.getContainingFile()), true);
        }

        public boolean isAcceptableAsNode(Object element) {
            return element instanceof JSStructuralDiagramItem;
        }

        @Nullable
        public String getElementTitle(JSStructuralDiagramItem element) {
            return element.getName();
        }

        @Nullable
        public SimpleColoredText getItemName(Object element, DiagramState presentation) {
            if (element instanceof JSStructuralDiagramItem) {
                return new SimpleColoredText(((JSStructuralDiagramItem)element).getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            return null;
        }

        public Icon getItemIcon(Object element, DiagramState presentation) {
            if (element instanceof JSStructuralDiagramItem) {
                JSStructuralDiagramItem item = (JSStructuralDiagramItem)element;
                if (item.getIcon() != null) {
                    return item.getIcon();
                }
                PsiElement psiElement = item.getElementPointer().getElement();
                if (psiElement != null) {
                    return psiElement.getIcon(2);
                }
            }
            return super.getItemIcon(element, presentation);
        }

        public String getNodeTooltip(JSStructuralDiagramItem element) {
            return JSModulesDiagramUtils.getJSStructuralItemTooltip(element);
        }
    };
    private AbstractUmlVisibilityManager myVisibilityManager = new AbstractUmlVisibilityManager(){

        public VisibilityLevel[] getVisibilityLevels() {
            return new VisibilityLevel[]{OVERVIEW, DETAILS};
        }

        @Nullable
        public VisibilityLevel getVisibilityLevel(Object element) {
            if (element instanceof JSStructuralDiagramItem && !((JSStructuralDiagramItem)element).isFile()) {
                return DETAILS;
            }
            return OVERVIEW;
        }

        public Comparator<VisibilityLevel> getComparator() {
            return COMPARATOR;
        }

        public boolean isRelayoutNeeded() {
            return true;
        }
    };

    @Nullable
    private JSStructuralDiagramItem createProjectItem(Project project, SmartPointerManager spm) {
        VirtualFile baseDir = project.getBaseDir();
        PsiDirectory projectPsiFile = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        if (projectPsiFile == null) {
            return null;
        }
        SmartPsiElementPointer pointer = spm.createSmartPsiElementPointer((PsiElement)projectPsiFile);
        JSStructuralDiagramItem item = new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)pointer, "Selected", false);
        return item;
    }

    @Nullable
    private static JSStructuralDiagramItem deserializeOneItem(String fqn, Project project) {
        int offset;
        PsiDirectory psiFile;
        if (StringUtil.isEmptyOrSpaces((String)fqn)) {
            return null;
        }
        String[] strings = fqn.split("#");
        if (strings.length != 1 && strings.length != 4) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(strings[0]);
        if (file == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Object object = psiFile = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (strings.length == 1) {
            String name = psiFile instanceof PsiFile ? JSModulesDiagramUtils.getFileNamePart((PsiFile)psiFile) : file.getName();
            return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)psiFile), name, true);
        }
        String name = strings[2];
        try {
            offset = Integer.parseInt(strings[3]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        PsiElement element = psiFile.findElementAt(offset);
        if (element == null || !element.isValid()) {
            return null;
        }
        return new JSStructuralDiagramItem((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element), name, false);
    }

    @NotNull
    private static String serializeOneItem(JSStructuralDiagramItem element) {
        PsiElement psiElement = element.getElementPointer().getElement();
        if (psiElement == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider", "serializeOneItem"));
            }
            return "";
        }
        String path = psiElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement).getVirtualFile().getPath() : psiElement.getContainingFile().getVirtualFile().getPath();
        StringBuilder sb = new StringBuilder(path);
        if (!(psiElement instanceof PsiFileSystemItem) && !element.isFile()) {
            if (psiElement.getTextRange() == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider", "serializeOneItem"));
                }
                return "";
            }
            sb.append("#").append(element.getName()).append("#").append(String.format("%d", psiElement.getTextRange().getStartOffset()));
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider", "serializeOneItem"));
        }
        return string;
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return JAVASCRIPT_MODULES_DIAGRAMM;
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public DiagramNodeContentManager getNodeContentManager() {
        return new AbstractDiagramNodeContentManager(){
            {
                this.setEnabled(ALL, true);
            }

            public boolean isInCategory(Object element, DiagramCategory category, DiagramState presentation) {
                return true;
            }

            public DiagramCategory[] getContentCategories() {
                return new DiagramCategory[]{ALL};
            }
        };
    }

    @Nullable
    public DiagramPresentationModel createPresentationModel(Project project, Graph2D graph) {
        return new DiagramPresentationModelImpl(graph, project, (DiagramProvider)this){

            public boolean allowChangeVisibleCategories() {
                return false;
            }

            public void customizeSettings(Graph2DView view, EditMode editMode) {
                super.customizeSettings(view, editMode);
                this.getPresentation().setCategoryEnabled(ALL, true);
                JComponent component = this.getBuilder().getView().getJComponent();
                if (!PropertiesComponent.getInstance().isTrueValue(JSModulesDiagramProvider.FIRST_SHOW_KEY) || this.getBuilder().getDataModel().getNodes().size() == 0) {
                    UiNotifyConnector.doWhenFirstShown((JComponent)component, () -> GotItMessage.createMessage((String)JSBundle.message((String)"javascript.module.dependencies.got.it.title", (Object[])new Object[0]), (String)JSBundle.message((String)"javascript.module.dependencies.got.it.text", (Object[])new Object[0])).setCallback(() -> PropertiesComponent.getInstance().setValue(JSModulesDiagramProvider.FIRST_SHOW_KEY, true)).setDisposable((Disposable)this.getBuilder()).show(RelativePoint.getSouthOf((JComponent)component), Balloon.Position.below));
                }
            }

            @NotNull
            public NodeRealizer getNodeRealizer(DiagramNode node) {
                NodeRealizer nodeRealizer = super.getNodeRealizer(node);
                if (nodeRealizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider$5", "getNodeRealizer"));
                }
                return nodeRealizer;
            }

            public DefaultUmlRenderer getRenderer() {
                if (this.myRenderer == null) {
                    this.myRenderer = new DefaultUmlRenderer(this.getBuilder(), this.createModificationTracker()){

                        public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
                            PsiFile file;
                            JSStructuralDiagramItem element;
                            Border border = JBUI.Borders.customLine((Color)Gray._190);
                            DiagramNode object = this.getBuilder().getNodeObject(realizer.getNode());
                            if (object instanceof JSStructuralUiNode && (element = ((JSStructuralUiNode)object).getIdentifyingElement()).isInScope() && (file = element.getElementPointer().getContainingFile()) != null && !JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile())) {
                                border = JBUI.Borders.customLine((Color)JBColor.black);
                            }
                            wrapper.setBorder(border);
                            if (wrapper.getParent() instanceof JComponent) {
                                ((JComponent)wrapper.getParent()).setBorder((Border)JBUI.Borders.empty());
                            }
                            super.tuneNode(realizer, wrapper);
                        }
                    };
                }
                return this.myRenderer;
            }

            public String getNodeTooltip(DiagramNode node) {
                return node.getTooltip();
            }

            public String getEdgeTooltip(DiagramEdge edge) {
                if (edge instanceof JSStructuralUiEdge) {
                    return ((JSStructuralUiEdge)edge).getTooltip();
                }
                return super.getEdgeTooltip(edge);
            }
        };
    }

    public DiagramColorManager getColorManager() {
        return new DiagramColorManagerBase(){

            public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
                Object element;
                Object object = element = node == null ? null : node.getIdentifyingElement();
                if (element instanceof JSStructuralDiagramItem) {
                    PsiFile file;
                    String module;
                    JSStructuralDiagramModel model = (JSStructuralDiagramModel)builder.getDataModel();
                    String name = ((JSStructuralDiagramItem)element).getName();
                    int idx = name.indexOf("/");
                    String string = module = idx > 0 ? name.substring(0, idx) : "";
                    Color color = ((JSStructuralDiagramItem)element).isInScope() ? ((file = ((JSStructuralDiagramItem)element).getElementPointer().getContainingFile()) != null && JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile()) ? model.getColoredGenerator().generate(module) : model.getInProjectGenerator().generate(module)) : model.getGrayGenerator().generate(module);
                    return color;
                }
                return super.getNodeHeaderColor(builder, node);
            }

            public boolean drawGradientInHeader() {
                return false;
            }

            public Color getNodeForegroundColor(boolean selected) {
                return super.getNodeForegroundColor(selected);
            }

            public Color getEdgeColor(DiagramEdge edge) {
                Color color;
                if (edge instanceof JSStructuralUiEdge && (color = ((JSStructuralUiEdge)edge).getColor()) != null) {
                    return color;
                }
                return JBColor.gray;
            }

            public Color getNodeBackground(Project project, Object element, boolean selected) {
                if (element instanceof JSStructuralDiagramItem) {
                    if (((JSStructuralDiagramItem)element).getParent() != null) {
                        return JBColor.WHITE;
                    }
                    if (((JSStructuralDiagramItem)element).isInScope()) {
                        return LightColors.YELLOW;
                    }
                    return Gray._250;
                }
                return super.getNodeBackground(project, element, selected);
            }

            public Color getToolbarColor() {
                return super.getToolbarColor();
            }
        };
    }

    public DiagramElementManager<JSStructuralDiagramItem> getElementManager() {
        return this.myElementManager;
    }

    public DiagramVfsResolver<JSStructuralDiagramItem> getVfsResolver() {
        return this.myResolver;
    }

    public String getPresentableName() {
        return "JavaScript Modules Diagram";
    }

    @NotNull
    public DiagramExtras<JSStructuralDiagramItem> getExtras() {
        DiagramExtras<JSStructuralDiagramItem> diagramExtras = new DiagramExtras<JSStructuralDiagramItem>(){

            @Nullable
            public Object getData(String dataId, List<DiagramNode<JSStructuralDiagramItem>> list, DiagramBuilder builder) {
                if (CommonDataKeys.PSI_ELEMENT.is(dataId) && list.size() == 1) {
                    SmartPsiElementPointer<PsiElement> target = ((JSStructuralDiagramItem)list.get(0).getIdentifyingElement()).getElementPointer();
                    return target.getElement();
                }
                return super.getData(dataId, list, builder);
            }

            @NotNull
            public JComponent createNodeComponent(DiagramNode<JSStructuralDiagramItem> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
                DiagramNodeContainer container = new DiagramNodeContainer(node, builder, basePoint);
                if (!((JSStructuralDiagramItem)node.getIdentifyingElement()).getUsedExported().isEmpty()) {
                    container.getHeader().setBorder(JBUI.Borders.customLine((Color)Gray._190, (int)0, (int)0, (int)1, (int)0));
                }
                container.setBackground((Color)JBColor.WHITE);
                DiagramNodeContainer diagramNodeContainer = container;
                if (diagramNodeContainer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider$7", "createNodeComponent"));
                }
                return diagramNodeContainer;
            }

            @Nullable
            public Layouter getCustomLayouter(Graph2D graph, Project project) {
                GraphSettingsProvider settingsProvider = GraphSettingsProvider.getInstance((Project)project);
                GraphSettings settings = settingsProvider.getSettings((Graph)graph);
                SmartOrganicLayouter layouter = settings.getOrganicLayouter();
                layouter.setNodeEdgeOverlapAvoided(true);
                layouter.setDeterministic(true);
                return layouter;
            }
        };
        if (diagramExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider", "getExtras"));
        }
        return diagramExtras;
    }

    public DiagramDataModel<JSStructuralDiagramItem> createDataModel(@NotNull Project project, @Nullable JSStructuralDiagramItem element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        GlobalSearchScope scope;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramProvider", "createDataModel"));
        }
        if (element != null && !element.getUsedExported().isEmpty()) {
            GlobalSearchScope current = GlobalSearchScope.EMPTY_SCOPE;
            for (JSStructuralDiagramItem item : element.getUsedExported()) {
                PsiElement child = item.getElementPointer().getElement();
                if (!(child instanceof PsiFileSystemItem)) continue;
                if (child instanceof PsiDirectory) {
                    current = current.union((SearchScope)GlobalSearchScopesCore.directoryScope((PsiDirectory)((PsiDirectory)child), (boolean)true));
                    continue;
                }
                if (!(child instanceof PsiFile)) continue;
                current = current.union((SearchScope)GlobalSearchScope.fileScope((PsiFile)((PsiFile)child)));
            }
            scope = current;
        } else if (element != null) {
            PsiElement psiElement = element.getElementPointer().getElement();
            if (psiElement instanceof PsiFileSystemItem) {
                scope = psiElement instanceof PsiDirectory ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)((PsiDirectory)psiElement).getVirtualFile(), (boolean)true) : (psiElement instanceof PsiFile ? GlobalSearchScope.fileScope((PsiFile)((PsiFile)psiElement)) : GlobalSearchScope.projectScope((Project)project));
            } else {
                PsiFile psiFile = element.getElementPointer().getContainingFile();
                if (psiFile == null) {
                    return null;
                }
                scope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)psiFile.getVirtualFile());
            }
        } else {
            scope = GlobalSearchScope.projectScope((Project)project);
        }
        JSModuleDependencyData data = new JSModuleDependencyData(project, scope);
        data.calculate();
        Pair<List<JSStructuralUiNode>, List<JSStructuralUiEdge>> nodesAndEdges = data.getNodesAndEdges(this);
        return new JSStructuralDiagramModel(project, this, (List)nodesAndEdges.getFirst(), (List)nodesAndEdges.getSecond());
    }
}

