/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModulesDiagramUtils {
    public static String getFileNamePart(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/diagramm/JSModulesDiagramUtils", "getFileNamePart"));
        }
        if (NodeJsCoreLibraryManager.getInstance(file.getProject()).isCoreModuleLibraryFile(file.getVirtualFile())) {
            return file.getName() + " (node.js)";
        }
        VirtualFile folder = JSLibraryUtil.getLibraryFolder(file.getVirtualFile());
        if (folder != null) {
            if (folder.equals(file.getVirtualFile().getParent())) {
                return folder.getName() + "/" + file.getName();
            }
            return folder.getName() + "/.../" + file.getName();
        }
        if (file.getProject().getBaseDir().equals(file.getVirtualFile().getParent())) {
            return file.getName();
        }
        return file.getVirtualFile().getParent().getName() + "/" + file.getName();
    }

    @Nullable
    public static String getJSStructuralItemTooltip(JSStructuralDiagramItem element) {
        PsiElement psiElement = element.getElementPointer().getElement();
        if (psiElement != null && psiElement.isValid()) {
            if (!element.isFile()) {
                return element.getName() + " (" + psiElement.getContainingFile().getVirtualFile().getPath() + ")";
            }
            return psiElement.getContainingFile().getVirtualFile().getPath();
        }
        return element.getName();
    }
}

