/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSStructuralDiagramItem {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    private final String myName;
    private final boolean myIsFile;
    private JSStructuralDiagramItem myParent;
    @NotNull
    private final List<JSStructuralDiagramItem> myUsedExported;
    private boolean myIsInScope;
    private Icon myIcon;

    public JSStructuralDiagramItem(@NotNull SmartPsiElementPointer<PsiElement> elementPointer, String name, boolean isFile) {
        if (elementPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementPointer", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramItem", "<init>"));
        }
        this.myUsedExported = new ArrayList<JSStructuralDiagramItem>();
        this.myElementPointer = elementPointer;
        this.myName = name;
        this.myIsFile = isFile;
    }

    @NotNull
    public SmartPsiElementPointer<PsiElement> getElementPointer() {
        SmartPsiElementPointer<PsiElement> smartPsiElementPointer = this.myElementPointer;
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramItem", "getElementPointer"));
        }
        return smartPsiElementPointer;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    @NotNull
    public List<JSStructuralDiagramItem> getUsedExported() {
        List<JSStructuralDiagramItem> list = Collections.unmodifiableList(this.myUsedExported);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramItem", "getUsedExported"));
        }
        return list;
    }

    public void addExported(@NotNull JSStructuralDiagramItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/lang/javascript/modules/diagramm/JSStructuralDiagramItem", "addExported"));
        }
        this.myUsedExported.add(item);
        item.setParent(this);
    }

    public void sortExported() {
        if (this.myUsedExported.isEmpty()) {
            return;
        }
        TreeSet<JSStructuralDiagramItem> set = new TreeSet<JSStructuralDiagramItem>((o1, o2) -> Comparing.compare((Comparable)((Object)o1.myName), (Comparable)((Object)o2.myName)));
        set.addAll(this.myUsedExported);
        this.myUsedExported.clear();
        this.myUsedExported.addAll(set);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSStructuralDiagramItem item = (JSStructuralDiagramItem)o;
        if (this.myIsFile != item.myIsFile) {
            return false;
        }
        return this.myElementPointer.equals(item.myElementPointer);
    }

    public int hashCode() {
        int result = this.myElementPointer.hashCode();
        result = 31 * result + (this.myIsFile ? 1 : 0);
        return result;
    }

    public boolean isInScope() {
        return this.myIsInScope;
    }

    public JSStructuralDiagramItem setInScope(boolean inScope) {
        this.myIsInScope = inScope;
        return this;
    }

    public JSStructuralDiagramItem getParent() {
        return this.myParent;
    }

    public JSStructuralDiagramItem setParent(JSStructuralDiagramItem parent) {
        this.myParent = parent;
        return this;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }
}

