/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagramm;

import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramProvider;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagramm.JSStructuralDiagramItem;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralUiNode
extends DiagramNodeBase<JSStructuralDiagramItem> {
    @NotNull
    private final JSStructuralDiagramItem myItem;

    public JSStructuralUiNode(@NotNull JSStructuralDiagramItem item, @NotNull DiagramProvider<JSStructuralDiagramItem> provider) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/lang/javascript/modules/diagramm/JSStructuralUiNode", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/lang/javascript/modules/diagramm/JSStructuralUiNode", "<init>"));
        }
        super(provider);
        this.myItem = item;
    }

    @Nullable
    public String getTooltip() {
        return JSModulesDiagramUtils.getJSStructuralItemTooltip(this.myItem);
    }

    public Icon getIcon() {
        PsiElement element = this.myItem.getElementPointer().getElement();
        if (element != null && element.isValid()) {
            return element.getIcon(2);
        }
        return null;
    }

    @NotNull
    public JSStructuralDiagramItem getIdentifyingElement() {
        JSStructuralDiagramItem jSStructuralDiagramItem = this.myItem;
        if (jSStructuralDiagramItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/diagramm/JSStructuralUiNode", "getIdentifyingElement"));
        }
        return jSStructuralDiagramItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSStructuralUiNode node = (JSStructuralUiNode)((Object)o);
        return this.myItem.equals(node.myItem);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myItem.hashCode();
        return result;
    }
}

