/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeEvaluator
extends JSContextExpectedTypeEvaluator {
    public ExpectedTypeEvaluator(JSExpression parent) {
        super(parent);
    }

    @Override
    protected ExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent) {
        return new ExpectedTypeEvaluator(parent);
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSFunction.class);
        if (fun != null) {
            JSTypeSource typeSource;
            JSType returnType = fun.getReturnType();
            JSTypeSource jSTypeSource = typeSource = returnType != null ? returnType.getSource() : null;
            if (returnType != null && typeSource.isExplicitlyDeclared()) {
                this.myResult = returnType;
            }
        }
    }

    public void visitJSIfStatement(JSIfStatement node) {
        if (node.getCondition() == this.myParent) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSLoopStatement(JSLoopStatement node) {
        if (node.getCondition() == this.myParent) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (!(JSTokenTypes.EXCL != node.getOperationSign() || node.getParent() instanceof JSPrefixExpression && JSTokenTypes.EXCL == ((JSPrefixExpression)node.getParent()).getOperationSign())) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSThrowStatement(JSThrowStatement node) {
        PsiComment docComment;
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myParent, JSFunction.class);
        if (fun != null && (docComment = JSDocumentationUtils.findDocComment((PsiElement)fun)) != null) {
            final Ref throwsTypeFromCommentRef = new Ref();
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onCommentLine"));
                    }
                    return false;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onPatternMatch"));
                    }
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onPatternMatch"));
                    }
                    if (patternMatched == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onPatternMatch"));
                    }
                    if (type == JSDocumentationProcessor.MetaDocType.THROWS && matchName != null) {
                        throwsTypeFromCommentRef.set((Object)matchName);
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }
            });
            String throwsTypeFromComment = (String)throwsTypeFromCommentRef.get();
            if (throwsTypeFromComment != null) {
                this.myResult = JSTypeUtils.createType(throwsTypeFromComment, JSTypeSourceFactory.createTypeSource(this.myGrandParent, true));
                return;
            }
        }
        this.myResult = this.createNamedType("Error", this.myGrandParent);
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        this.myResult = node.getCondition() == this.myParent ? this.createNamedType("Boolean", this.myGrandParent) : JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node);
    }

    public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
        if (node.getIndexExpression() == this.myParent) {
            this.evaluateIndexedAccessType(node);
        }
    }

    protected void evaluateIndexedAccessType(JSIndexedPropertyAccessExpression node) {
        this.myResult = this.createNamedType("number", this.myGrandParent);
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        if (node.getROperand() == this.myParent) {
            IElementType opType = node.getOperationSign();
            if (JSTokenTypes.OROR == opType || JSTokenTypes.ANDAND == opType) {
                this.myResult = this.createNamedType("Boolean", this.myGrandParent);
            } else {
                JSExpression lOperand = node.getLOperand();
                if (lOperand != null) {
                    this.myResult = JSResolveUtil.getQualifiedExpressionJSType(lOperand, this.myGrandParent.getContainingFile());
                }
            }
        }
    }

    public void visitJSCaseClause(JSCaseClause node) {
        JSExpression switchExpression;
        JSSwitchStatement switchStatement;
        if (node.getCaseExpression() == this.myParent && (switchStatement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSSwitchStatement.class)) != null && (switchExpression = switchStatement.getSwitchExpression()) != null) {
            this.myResult = JSResolveUtil.getQualifiedExpressionJSType(switchExpression, this.myGrandParent.getContainingFile());
        }
    }

    protected void findRestParameterExpectedType(JSParameterItem param) {
        this.myResult = this.createNamedType("Object", (PsiElement)this.myParent);
    }

    protected JSType createNamedType(String name, PsiElement context) {
        return JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context, true), JSContext.INSTANCE);
    }
}

