/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeProcessorBase
implements JSTypeProcessor {
    @Override
    public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "processNamespace"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "processNamespace"));
        }
        JSTypeProcessorBase.processNamespaceAsType(this, (JSNamespace)namespace, evaluateContext, source);
    }

    @Override
    public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "processResolvedElement"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "processResolvedElement"));
        }
        if (!(element instanceof JSFile)) {
            return;
        }
        JSType alias = ((JSFile)element).getExportsInnerAlias();
        if (alias != null) {
            JSEvaluateContext context = JSEvaluateContext.fromEvaluationResultContext(evaluateContext);
            context.withJSModule((PsiFile)element, () -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "lambda$processResolvedElement$0"));
                }
                JSTypeEvaluator.applyContextAndProcess(alias, context, element, this);
            });
        }
    }

    public static void processNamespaceAsType(@NotNull JSTypeProcessor processor, @NotNull JSNamespace namespace, @NotNull JSEvaluateContext evaluateContext, @Nullable PsiElement source) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "processNamespaceAsType"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "processNamespaceAsType"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "processNamespaceAsType"));
        }
        JSQualifiedName qualifiedName = namespace.getQualifiedName();
        if (qualifiedName != null) {
            JSTypeSource typeSource = JSTypeProcessorBase.creteTypeSource(namespace, source);
            JSType type = JSNamedType.createType(qualifiedName.getQualifiedName(), typeSource, namespace.getJSContext());
            processor.process(type, evaluateContext, source);
        }
    }

    private static JSTypeSource creteTypeSource(@NotNull JSNamespace namespace, PsiElement source) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeProcessorBase", "creteTypeSource"));
        }
        if (source == JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT) {
            return JSTypeSource.EXPLICITLY_DECLARED;
        }
        return JSTypeSourceFactory.createTypeSource(source, namespace.isExplicitlyDeclared());
    }
}

