/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JSNamedObjectStubBase<T extends JSPsiNamedElementBase>
extends JSStubBase<T>
implements JSStubElement<T> {
    protected static final BooleanStructureElement IS_SYMBOL_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(IS_SYMBOL_FLAG);
    protected final StringRef myName;

    protected JSNamedObjectStubBase(T psiElement, StubElement parent, @NotNull JSStubElementType<?, T> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSNamedObjectStubBase", "<init>"));
        }
        super(psiElement, parent, (IStubElementType)elementType);
        this.writeFlag(IS_SYMBOL_FLAG, elementType.shouldIndexSymbol(psiElement));
        this.myName = StringRef.fromString((String)psiElement.getName());
    }

    protected JSNamedObjectStubBase(String name, StubElement parent, @NotNull IStubElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/stubs/impl/JSNamedObjectStubBase", "<init>"));
        }
        super(parent, elementType);
        this.myName = StringRef.fromString((String)name);
        this.writeFlag(IS_SYMBOL_FLAG, Boolean.TRUE);
    }

    protected JSNamedObjectStubBase(StubInputStream dataStream, StubElement parentStub, IStubElementType elementType) throws IOException {
        super(dataStream, parentStub, elementType);
        this.myName = dataStream.readName();
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        JSNamedObjectStubBase.writeString(this.myName, dataStream);
    }

    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    public void index(IndexSink sink) {
        String name = this.getName();
        IStubElementType type = this.getStubType();
        if (name != null && type instanceof JSStubElementType && this.readFlag(IS_SYMBOL_FLAG).booleanValue()) {
            sink.occurrence(JSSymbolIndex2.KEY, (Object)name);
        }
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSNamedObjectStubBase", "getFlagsStructure"));
        }
        return flagsStructure;
    }
}

