/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.util.DeclarationUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean statementMayCompleteNormally(@Nullable JSStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSReturnStatement || statement instanceof JSThrowStatement) {
            return false;
        }
        if (statement instanceof JSExpressionStatement || statement instanceof JSEmptyStatement || statement instanceof JSVarStatement) {
            return true;
        }
        if (statement instanceof JSForStatement) {
            return ControlFlowUtils.forStatementMayReturnNormally((JSForStatement)statement);
        }
        if (statement instanceof JSForInStatement) {
            return ControlFlowUtils.foreachStatementMayReturnNormally((JSForInStatement)statement);
        }
        if (statement instanceof JSWhileStatement) {
            return ControlFlowUtils.whileStatementMayReturnNormally((JSWhileStatement)statement);
        }
        if (statement instanceof JSDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayReturnNormally((JSDoWhileStatement)statement);
        }
        if (statement instanceof JSBlockStatement) {
            return ControlFlowUtils.blockMayCompleteNormally((JSBlockStatement)statement);
        }
        if (statement instanceof JSLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((JSLabeledStatement)statement);
        }
        if (statement instanceof JSIfStatement) {
            return ControlFlowUtils.ifStatementMayReturnNormally((JSIfStatement)statement);
        }
        if (statement instanceof JSTryStatement) {
            return ControlFlowUtils.tryStatementMayReturnNormally((JSTryStatement)statement);
        }
        if (statement instanceof JSSwitchStatement) {
            return ControlFlowUtils.switchStatementMayReturnNormally((JSSwitchStatement)statement);
        }
        if (statement instanceof JSWithStatement) {
            return ControlFlowUtils.withStatementMayReturnNormally((JSWithStatement)statement);
        }
        return true;
    }

    private static boolean withStatementMayReturnNormally(JSWithStatement jsWithStatement) {
        JSStatement body = jsWithStatement.getStatement();
        return ControlFlowUtils.statementMayCompleteNormally(body);
    }

    private static boolean doWhileStatementMayReturnNormally(@NotNull JSDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "doWhileStatementMayReturnNormally"));
        }
        JSExpression test = loopStatement.getCondition();
        JSStatement body = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body) && !ControlFlowUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget((JSStatement)loopStatement);
    }

    private static boolean whileStatementMayReturnNormally(@NotNull JSWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "whileStatementMayReturnNormally"));
        }
        JSExpression test = loopStatement.getCondition();
        return !ControlFlowUtils.isTrue(test) || ControlFlowUtils.statementIsBreakTarget((JSStatement)loopStatement);
    }

    private static boolean forStatementMayReturnNormally(@NotNull JSForStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "forStatementMayReturnNormally"));
        }
        JSExpression test = loopStatement.getCondition();
        if (ControlFlowUtils.statementIsBreakTarget((JSStatement)loopStatement)) {
            return true;
        }
        if (test == null) {
            return false;
        }
        return !ControlFlowUtils.isTrue(test);
    }

    private static boolean foreachStatementMayReturnNormally(@NotNull JSForInStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "foreachStatementMayReturnNormally"));
        }
        return true;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull JSSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "switchStatementMayReturnNormally"));
        }
        if (ControlFlowUtils.statementIsBreakTarget((JSStatement)switchStatement)) {
            return true;
        }
        JSCaseClause[] caseClauses = switchStatement.getCaseClauses();
        if (caseClauses.length == 0) {
            return true;
        }
        boolean hasDefaultCase = false;
        for (JSCaseClause clause : caseClauses) {
            if (!clause.isDefault()) continue;
            hasDefaultCase = true;
        }
        if (!hasDefaultCase) {
            return true;
        }
        JSCaseClause lastClause = caseClauses[caseClauses.length - 1];
        JSStatement[] statements = lastClause.getStatements();
        if (statements.length == 0) {
            return true;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean tryStatementMayReturnNormally(@NotNull JSTryStatement tryStatement) {
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "tryStatementMayReturnNormally"));
        }
        JSStatement finallyBlock = tryStatement.getFinallyStatement();
        if (finallyBlock != null && !ControlFlowUtils.statementMayCompleteNormally(finallyBlock)) {
            return false;
        }
        JSStatement tryBlock = tryStatement.getStatement();
        if (ControlFlowUtils.statementMayCompleteNormally(tryBlock)) {
            return true;
        }
        JSCatchBlock[] allCatchBlocks = tryStatement.getAllCatchBlocks();
        if (allCatchBlocks.length == 0) {
            return false;
        }
        for (JSCatchBlock c : allCatchBlocks) {
            if (!ControlFlowUtils.statementMayCompleteNormally(c.getStatement())) continue;
            return true;
        }
        return tryStatement.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull JSIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "ifStatementMayReturnNormally"));
        }
        JSStatement thenBranch = ifStatement.getThen();
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
            return true;
        }
        JSStatement elseBranch = ifStatement.getElse();
        return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull JSLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "labeledStatementMayCompleteNormally"));
        }
        JSStatement statement = labeledStatement.getStatement();
        return ControlFlowUtils.statementMayCompleteNormally(statement) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean blockMayCompleteNormally(@Nullable JSBlockStatement block) {
        JSStatement[] statements;
        if (block == null) {
            return true;
        }
        for (JSStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull JSStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementIsBreakTarget"));
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    public static boolean elementContainsReturn(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "elementContainsReturn"));
        }
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull JSStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementIsContinueTarget"));
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean isInLoop(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInLoop"));
        }
        return ControlFlowUtils.isInForStatementBody(element) || ControlFlowUtils.isInForeachStatementBody(element) || ControlFlowUtils.isInWhileStatementBody(element) || ControlFlowUtils.isInDoWhileStatementBody(element);
    }

    public static boolean isInFinallyBlock(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInFinallyBlock"));
        }
        JSElement currentElement = element;
        JSTryStatement tryStatement;
        while ((tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, JSTryStatement.class, (boolean)true, (Class[])new Class[]{JSFunction.class})) != null) {
            JSStatement finallyBlock = tryStatement.getFinallyStatement();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInCatchBlock"));
        }
        JSElement currentElement = element;
        JSTryStatement tryStatement;
        while ((tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, JSTryStatement.class)) != null) {
            JSStatement catchStatement;
            JSCatchBlock catchBlock = tryStatement.getCatchBlock();
            if (catchBlock != null && PsiTreeUtil.isAncestor((PsiElement)(catchStatement = catchBlock.getStatement()), (PsiElement)currentElement, (boolean)true)) {
                return true;
            }
            currentElement = tryStatement;
        }
        return false;
    }

    private static boolean isInWhileStatementBody(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInWhileStatementBody"));
        }
        JSWhileStatement whileStatement = (JSWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSWhileStatement.class);
        if (whileStatement == null) {
            return false;
        }
        JSStatement body = whileStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInDoWhileStatementBody(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInDoWhileStatementBody"));
        }
        JSDoWhileStatement doWhileStatement = (JSDoWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSDoWhileStatement.class);
        if (doWhileStatement == null) {
            return false;
        }
        JSStatement body = doWhileStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInForStatementBody(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInForStatementBody"));
        }
        JSForStatement forStatement = (JSForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSForStatement.class);
        if (forStatement == null) {
            return false;
        }
        JSStatement body = forStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInForeachStatementBody(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInForeachStatementBody"));
        }
        JSForInStatement foreachStatement = (JSForInStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSForInStatement.class);
        if (foreachStatement == null) {
            return false;
        }
        JSStatement body = foreachStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static JSStatement stripBraces(@NotNull JSStatement branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "stripBraces"));
        }
        if (branch instanceof JSBlockStatement) {
            JSBlockStatement block = (JSBlockStatement)branch;
            JSStatement[] statements = block.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean statementCompletesWithStatement(@NotNull JSStatement containingStatement, @NotNull JSStatement statement) {
        if (containingStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        JSStatement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            JSElement container = ControlFlowUtils.getContainingStatement((JSElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof JSBlockStatement ? !ControlFlowUtils.statementIsLastInBlock((JSBlockStatement)container, statementToCheck) : container instanceof JSSwitchStatement && !ControlFlowUtils.statementIsLastInSwitch((JSSwitchStatement)container, statementToCheck)) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof JSSwitchStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull JSBlockStatement body, @NotNull JSStatement statement) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        JSStatement statementToCheck = statement;
        while (statementToCheck != null) {
            JSElement container = ControlFlowUtils.getContainingStatement((JSElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof JSBlockStatement) {
                if (!ControlFlowUtils.statementIsLastInBlock((JSBlockStatement)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)container, JSStatement.class);
                continue;
            }
            if (container instanceof JSSwitchStatement) {
                if (!ControlFlowUtils.statementIsLastInSwitch((JSSwitchStatement)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = container;
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    private static boolean isLoop(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isLoop"));
        }
        return element instanceof JSLoopStatement;
    }

    @Nullable
    private static JSElement getContainingStatement(@NotNull JSElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "getContainingStatement"));
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)statement, JSStatement.class);
    }

    private static boolean statementIsLastInBlock(@NotNull JSBlockStatement block, @NotNull JSStatement statement) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementIsLastInBlock"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementIsLastInBlock"));
        }
        return ControlFlowUtils.statementIsLastInStatements(statement, block.getStatements());
    }

    private static boolean statementIsLastInSwitch(@NotNull JSSwitchStatement switchStatement, @NotNull JSStatement statement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementIsLastInSwitch"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "statementIsLastInSwitch"));
        }
        return ControlFlowUtils.statementIsLastInStatements(statement, switchStatement.getStatements());
    }

    private static boolean statementIsLastInStatements(JSStatement statement, JSStatement[] statements) {
        for (int i = statements.length - 1; i >= 0; --i) {
            JSStatement childStatement = statements[i];
            if (statement.equals(childStatement)) {
                return true;
            }
            if (statement instanceof JSEmptyStatement) continue;
            return false;
        }
        return false;
    }

    public static boolean isFalse(@Nullable JSExpression test) {
        if (test == null) {
            return false;
        }
        String text = test.getText();
        return "false".equals(text);
    }

    public static boolean isTrue(@Nullable JSExpression test) {
        if (test == null) {
            return false;
        }
        String text = test.getText();
        return "true".equals(text);
    }

    public static boolean isInExitStatement(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInExitStatement"));
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInReturnStatementArgument"));
        }
        JSReturnStatement returnStatement = (JSReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSReturnStatement.class);
        return returnStatement != null;
    }

    private static boolean isInThrowStatementArgument(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/ControlFlowUtils", "isInThrowStatementArgument"));
        }
        JSThrowStatement throwStatement = (JSThrowStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSThrowStatement.class);
        return throwStatement != null;
    }

    @Nullable
    public static JSFunction resolveMethod(JSCallExpression expression) {
        JSExpression methodExpression;
        JSExpression jSExpression = methodExpression = expression == null ? null : expression.getMethodExpression();
        if (methodExpression != null && methodExpression instanceof JSReferenceExpression) {
            PsiElement referent = ((JSReferenceExpression)methodExpression).resolve();
            return referent != null && referent instanceof JSFunction ? (JSFunction)referent : null;
        }
        return null;
    }

    @Nullable
    public static JSVariable resolveVariable(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JSReferenceExpression) {
            PsiElement variable = ((JSReferenceExpression)expression).resolve();
            return variable != null && variable instanceof JSVariable ? (JSVariable)variable : null;
        }
        if (expression instanceof JSDefinitionExpression) {
            JSExpression referentExpression = ((JSDefinitionExpression)expression).getExpression();
            PsiReference reference = referentExpression == null ? null : referentExpression.getReference();
            PsiElement variable = reference == null ? null : reference.resolve();
            return variable != null && variable instanceof JSVariable ? (JSVariable)variable : null;
        }
        return null;
    }

    public static void appendStatementsInSequence(StringBuilder buffer, JSStatement statement1, JSStatement statement2) {
        if (statement1 == null) {
            buffer.append(' ').append(statement2.getText());
        } else if (statement2 == null) {
            buffer.append(' ').append(statement1.getText());
        } else {
            buffer.append('{');
            ControlFlowUtils.appendStatementStripped(buffer, statement1);
            ControlFlowUtils.appendStatementStripped(buffer, statement2);
            buffer.append('}');
        }
    }

    private static void appendStatementStripped(StringBuilder buffer, JSStatement statement) {
        if (statement instanceof JSBlockStatement) {
            for (JSStatement child : ((JSBlockStatement)statement).getStatements()) {
                buffer.append(child.getText());
            }
        } else {
            buffer.append(statement.getText());
        }
    }

    public static boolean canBeMerged(JSStatement statement1, JSStatement statement2) {
        if (!ControlFlowUtils.statementMayCompleteNormally(statement1)) {
            return false;
        }
        Set<String> statement1Declarations = ControlFlowUtils.calculateTopLevelDeclarations(statement1);
        if (ControlFlowUtils.containsConflictingDeclarations(statement1Declarations, statement2)) {
            return false;
        }
        Set<String> statement2Declarations = ControlFlowUtils.calculateTopLevelDeclarations(statement2);
        return !ControlFlowUtils.containsConflictingDeclarations(statement2Declarations, statement1);
    }

    public static boolean containsConflictingDeclarations(JSBlockStatement block, JSBlockStatement parentBlock) {
        JSStatement[] statements = block.getStatements();
        HashSet<JSVariable> declaredVars = new HashSet<JSVariable>();
        for (JSStatement statement : statements) {
            if (!(statement instanceof JSVarStatement)) continue;
            JSVarStatement declaration = (JSVarStatement)statement;
            for (JSVariable var : declaration.getVariables()) {
                declaredVars.add(var);
            }
        }
        for (JSVariable variable : declaredVars) {
            if (!ControlFlowUtils.conflictingDeclarationExists(variable.getName(), parentBlock, block)) continue;
            return true;
        }
        return false;
    }

    private static boolean conflictingDeclarationExists(String name, JSBlockStatement parentBlock, JSBlockStatement exceptBlock) {
        ConflictingDeclarationVisitor visitor = new ConflictingDeclarationVisitor(name, exceptBlock);
        parentBlock.accept((PsiElementVisitor)visitor);
        return visitor.hasConflictingDeclaration();
    }

    private static Set<String> calculateTopLevelDeclarations(JSStatement statement) {
        HashSet<String> out = new HashSet<String>();
        if (statement instanceof JSVarStatement) {
            ControlFlowUtils.addDeclarations((JSVarStatement)statement, out);
        } else if (statement instanceof JSBlockStatement) {
            for (JSStatement subStatement : ((JSBlockStatement)statement).getStatements()) {
                if (!(subStatement instanceof JSVarStatement)) continue;
                ControlFlowUtils.addDeclarations((JSVarStatement)subStatement, out);
            }
        }
        return out;
    }

    private static void addDeclarations(JSVarStatement statement, Set<String> declaredVars) {
        for (JSVariable variable : statement.getVariables()) {
            declaredVars.add(variable.getName());
        }
    }

    private static boolean containsConflictingDeclarations(Set<String> declarations, JSStatement statement) {
        DeclarationUtils.DeclarationConflictVisitor visitor = new DeclarationUtils.DeclarationConflictVisitor(declarations);
        statement.accept((PsiElementVisitor)visitor);
        return visitor.hasConflict();
    }

    public static boolean statementContainsExitingBreak(@Nullable JSStatement statement) {
        if (statement == null) {
            return false;
        }
        ExitingBreakFinder breakFinder = new ExitingBreakFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static class ExitingBreakFinder
    extends JSRecursiveElementVisitor {
        private boolean found;

        private ExitingBreakFinder() {
        }

        private boolean breakFound() {
            return this.found;
        }

        public void visitJSReferenceExpression(JSReferenceExpression exp) {
        }

        public void visitJSBreakStatement(JSBreakStatement breakStatement) {
            if (breakStatement.getLabel() != null) {
                return;
            }
            this.found = true;
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement statement) {
        }

        public void visitJSForStatement(JSForStatement statement) {
        }

        public void visitJSForInStatement(JSForInStatement statement) {
        }

        public void visitJSWhileStatement(JSWhileStatement statement) {
        }

        public void visitJSSwitchStatement(JSSwitchStatement statement) {
        }
    }

    private static class ConflictingDeclarationVisitor
    extends JSRecursiveElementVisitor {
        private final String variableName;
        private final JSBlockStatement exceptBlock;
        private boolean hasConflictingDeclaration;

        ConflictingDeclarationVisitor(String variableName, JSBlockStatement exceptBlock) {
            this.variableName = variableName;
            this.exceptBlock = exceptBlock;
        }

        public void visitJSElement(JSElement element) {
            if (!this.hasConflictingDeclaration) {
                super.visitJSElement(element);
            }
        }

        public void visitJSBlock(JSBlockStatement block) {
            if (!this.hasConflictingDeclaration && !block.equals(this.exceptBlock)) {
                super.visitJSBlock(block);
            }
        }

        public void visitJSVariable(JSVariable variable) {
            if (!this.hasConflictingDeclaration) {
                super.visitJSVariable(variable);
                String name = variable.getName();
                this.hasConflictingDeclaration = name != null && name.equals(this.variableName);
            }
        }

        public boolean hasConflictingDeclaration() {
            return this.hasConflictingDeclaration;
        }
    }

    private static class ContinueFinder
    extends JSRecursiveElementVisitor {
        private boolean m_found;
        private final JSStatement m_target;

        private ContinueFinder(@NotNull JSStatement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ContinueFinder", "<init>"));
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean continueFound() {
            return this.m_found;
        }

        public void visitJSContinueStatement(@NotNull JSContinueStatement continueStatement) {
            if (continueStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continueStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ContinueFinder", "visitJSContinueStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitJSContinueStatement(continueStatement);
            JSStatement exitedStatement = continueStatement.getStatementToContinue();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }
    }

    private static class BreakFinder
    extends JSRecursiveElementVisitor {
        private boolean m_found;
        private final JSStatement m_target;

        private BreakFinder(@NotNull JSStatement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$BreakFinder", "<init>"));
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        public void visitJSBreakStatement(@NotNull JSBreakStatement breakStatement) {
            JSStatement prevStatement;
            if (breakStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$BreakFinder", "visitJSBreakStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitJSBreakStatement(breakStatement);
            JSStatement exitedStatement = breakStatement.getStatementToBreak();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false) && ((prevStatement = (JSStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)breakStatement, JSStatement.class)) == null || ControlFlowUtils.statementMayCompleteNormally(prevStatement))) {
                this.m_found = true;
            }
        }
    }

    private static class ReturnFinder
    extends JSRecursiveElementVisitor {
        private boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        public void visitJSReturnStatement(@NotNull JSReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/intellij/lang/javascript/psi/util/ControlFlowUtils$ReturnFinder", "visitJSReturnStatement"));
            }
            this.m_found = true;
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public void visitJSFunctionDeclaration(JSFunction node) {
        }
    }
}

