/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.List;

public class HighlightingUtils {
    public static ArrayList<RangeHighlighter> highlightOccurrences(Project project, Editor editor, PsiElement[] elts) {
        return HighlightingUtils.highlightOccurrences(project, editor, new PsiElementsOccurrenceInfoSource(elts));
    }

    public static ArrayList<RangeHighlighter> highlightOccurrences(Project project, Editor editor, OccurrenceInfoSource occurrenceInfoSource) {
        ArrayList<RangeHighlighter> result = HighlightingUtils.doHighlightOccurences(project, editor, occurrenceInfoSource, false);
        HighlightingUtils.informThatHighlightingCanbeRemoved(project);
        return result;
    }

    public static void informThatHighlightingCanbeRemoved(Project project) {
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    public static ArrayList<RangeHighlighter> doHighlightOccurences(Project project, Editor editor, OccurrenceInfoSource occurrenceInfoSource, boolean isWrite) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(isWrite ? EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES : EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ArrayList<RangeHighlighter> result = new ArrayList<RangeHighlighter>();
        if (occurrenceInfoSource instanceof PsiElementsOccurrenceInfoSource) {
            PsiElement[] occurrences = ((PsiElementsOccurrenceInfoSource)occurrenceInfoSource).occurrences;
            highlightManager.addOccurrenceHighlights(editor, occurrences, attributes, true, result);
        } else if (occurrenceInfoSource instanceof RangesOccurrenceInfoSource) {
            for (RangeMarker r : ((RangesOccurrenceInfoSource)occurrenceInfoSource).myRanges) {
                highlightManager.addOccurrenceHighlight(editor, r.getStartOffset(), r.getEndOffset(), attributes, 5, result, attributes.getErrorStripeColor());
            }
        } else assert (false);
        return result;
    }

    public static class PsiElementsOccurrenceInfoSource
    extends OccurrenceInfoSource {
        private final PsiElement[] occurrences;

        public PsiElementsOccurrenceInfoSource(PsiElement[] occurrences) {
            this.occurrences = occurrences;
        }
    }

    public static class RangesOccurrenceInfoSource
    extends OccurrenceInfoSource {
        private final List<RangeMarker> myRanges;

        public RangesOccurrenceInfoSource(List<RangeMarker> ranges) {
            this.myRanges = ranges;
        }
    }

    public static class OccurrenceInfoSource {
    }
}

