/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

class JSDefinitionsSearchExecutor
implements QueryExecutor<PsiElement, PsiElement> {
    JSDefinitionsSearchExecutor() {
    }

    public boolean execute(@NotNull PsiElement _sourceElement, @NotNull Processor<PsiElement> consumer) {
        if (_sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_sourceElement", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor", "execute"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (_sourceElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_sourceElement", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor", "lambda$execute$0"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor", "lambda$execute$0"));
            }
            return JSDefinitionsSearchExecutor.doExecute(_sourceElement, consumer);
        });
    }

    private static boolean doExecute(PsiElement _sourceElement, Processor<PsiElement> consumer) {
        if (JSDefinitionsSearchExecutor.isJavaScript(_sourceElement)) {
            if (_sourceElement instanceof PsiNamedElement) {
                PsiElement sourceElement = _sourceElement;
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)sourceElement.getProject());
                GlobalSearchScope fixedScope = JSDefinitionsSearchExecutor.createFixedScope(projectScope);
                ReferencesSearch.search((PsiElement)sourceElement, (SearchScope)fixedScope).forEach(t -> JSDefinitionsSearchExecutor.processRefElement(consumer, sourceElement, t));
                if (sourceElement instanceof JSClass) {
                    JSClass clazz = (JSClass)sourceElement;
                    Processor delegatingProcessor = jsClass -> {
                        JSClass e = jsClass instanceof XmlBackedJSClass ? jsClass : jsClass.getNavigationElement();
                        return consumer.process((Object)e);
                    };
                    JSClassSearch.searchClassInheritors(clazz, true).forEach(delegatingProcessor);
                    if (clazz.isInterface()) {
                        JSClassSearch.searchInterfaceImplementations(clazz, true).forEach(delegatingProcessor);
                    }
                } else if (sourceElement instanceof JSFunction && JSInheritanceUtil.canBeSuperMethod((JSFunction)sourceElement)) {
                    JSFunction baseFunction = (JSFunction)sourceElement;
                    Processor delegatingProcessor = jsFunction -> consumer.process((Object)jsFunction.getNavigationElement());
                    JSFunctionsSearch.searchOverridingFunctions(baseFunction, true).forEach(delegatingProcessor);
                    JSClass parent = JSUtils.getMemberContainingClass(sourceElement);
                    if (parent != null && JSClassUtils.isAllowImplementation(parent, sourceElement)) {
                        JSFunctionsSearch.searchImplementingFunctions(baseFunction, true).forEach(delegatingProcessor);
                    }
                } else if ((!(sourceElement instanceof JSFunction) || ((JSFunction)sourceElement).isConstructor()) && sourceElement instanceof JSPsiElementBase) {
                    JSResolveUtil.doFindOverridenFunctionStatic((JSPsiElementBase)sourceElement).forEach(arg_0 -> consumer.process(arg_0));
                }
            }
            if (JSDefinitionsSearchExecutor.isStaticVariableWithInitializer(_sourceElement)) {
                ReferencesSearch.search((PsiElement)_sourceElement).forEach(psiReference -> {
                    JSExpression[] arguments;
                    JSExpression methodExpression;
                    PsiElement grandParent;
                    PsiElement elt = psiReference.getElement();
                    PsiElement parent = elt.getParent();
                    if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && "addEventListener".equals(((JSReferenceExpression)methodExpression).getReferenceName()) && (arguments = ((JSArgumentList)parent).getArguments())[0] == elt && arguments.length > 1) {
                        PsiElement resolve;
                        JSExpression argument = arguments[1];
                        if (argument instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)argument).resolve()) instanceof JSFunction) {
                            argument = resolve;
                        }
                        if (argument instanceof JSFunction) {
                            return consumer.process((Object)argument);
                        }
                    }
                    return true;
                });
            }
        }
        return true;
    }

    private static boolean isStaticVariableWithInitializer(PsiElement _sourceElement) {
        return _sourceElement instanceof JSVariable && JSDefinitionsSearchExecutor.isStatic((JSVariable)_sourceElement) && ((JSVariable)_sourceElement).hasInitializer();
    }

    private static boolean isStatic(JSVariable _sourceElement) {
        JSAttributeList attrList = _sourceElement.getAttributeList();
        return attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    private static boolean isJavaScript(PsiElement _sourceElement) {
        return _sourceElement.getLanguage().isKindOf(Language.findInstance(JavascriptLanguage.class));
    }

    private static boolean processRefElement(Processor<PsiElement> consumer, PsiElement sourceElement, PsiReference ref) {
        ResolveResult[] resolveResults;
        if (ref instanceof JSPropertyNameReference && sourceElement instanceof TypeScriptTypeMember) {
            return consumer.process((Object)ref.getElement());
        }
        if (!(ref instanceof JSReferenceExpression) || sourceElement instanceof TypeScriptTypeMember) {
            return true;
        }
        PsiElement parent = ((JSReferenceExpression)ref).getParent();
        for (ResolveResult r : resolveResults = ((JSReferenceExpression)ref).multiResolve(true)) {
            PsiElement psiElement = r.getElement();
            if (psiElement == null || JSResolveUtil.isFromPredefinedFile(psiElement.getContainingFile()) || sourceElement == psiElement) continue;
            if (psiElement instanceof JSFunction && sourceElement instanceof JSFunction) {
                JSFunction fun = (JSFunction)psiElement;
                JSFunction sourceFun = (JSFunction)sourceElement;
                if (sourceFun.isGetProperty() && fun.isSetProperty() || sourceFun.isSetProperty() && fun.isGetProperty()) {
                    return true;
                }
            }
            if (consumer.process((Object)psiElement)) continue;
            return false;
        }
        return parent instanceof JSDefinitionExpression;
    }

    @NotNull
    private static GlobalSearchScope createFixedScope(GlobalSearchScope searchScope) {
        final NullableLazyValue javaFileTypeLazyValue = NullableLazyValue.createValue(() -> FileTypeRegistry.getInstance().findFileTypeByName("JAVA"));
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(searchScope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor$1", "contains"));
                }
                if (!super.contains(file)) {
                    return false;
                }
                return file.getFileType() != javaFileTypeLazyValue.getValue();
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor", "createFixedScope"));
        }
        return delegatingGlobalSearchScope;
    }
}

