/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHighlightingInfoBuilder {
    @NotNull
    public static JSFileHighlightingInfo createInfoWithUnSavedFiles(@NotNull Project project, @NotNull VirtualFile currentVirtualFile, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "createInfoWithUnSavedFiles"));
        }
        if (currentVirtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentVirtualFile", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "createInfoWithUnSavedFiles"));
        }
        if (filesFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesFilter", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "createInfoWithUnSavedFiles"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceUpdateContext context = JSHighlightingInfoBuilder.createUpdateContext(project, filesFilter);
        JSFileHighlightingInfo jSFileHighlightingInfo = new JSFileHighlightingInfo(currentVirtualFile, context);
        if (jSFileHighlightingInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "createInfoWithUnSavedFiles"));
        }
        return jSFileHighlightingInfo;
    }

    @NotNull
    public static JSLanguageServiceUpdateContext createUpdateContext(@NotNull Project project, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "createUpdateContext"));
        }
        if (filesFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesFilter", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "createUpdateContext"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap nameToContent = ContainerUtil.newHashMap();
        HashMap nameToTimestamps = ContainerUtil.newHashMap();
        JSHighlightingInfoBuilder.fillByUnsavedDocuments(project, nameToContent, nameToTimestamps, filesFilter);
        JSHighlightingInfoBuilder.fillByOpenedEditors(project, nameToContent, nameToTimestamps, filesFilter);
        JSLanguageServiceUpdateContext jSLanguageServiceUpdateContext = new JSLanguageServiceUpdateContext(nameToContent, nameToTimestamps);
        if (jSLanguageServiceUpdateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "createUpdateContext"));
        }
        return jSLanguageServiceUpdateContext;
    }

    private static void fillByOpenedEditors(@NotNull Project project, @NotNull Map<String, Document> nameToContent, @NotNull Map<String, Long> nameToTimestamps, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByOpenedEditors"));
        }
        if (nameToContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToContent", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByOpenedEditors"));
        }
        if (nameToTimestamps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToTimestamps", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByOpenedEditors"));
        }
        if (filesFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesFilter", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByOpenedEditors"));
        }
        Map<VirtualFile, Document> files = JSHighlightingInfoBuilder.getOpenedFiles(project, filesFilter);
        for (Map.Entry<VirtualFile, Document> entry : files.entrySet()) {
            long processedDocumentModificationStamp;
            VirtualFile processedOpenedFile = entry.getKey();
            String name = JSHighlightingInfoBuilder.normalizeNameAndPath(processedOpenedFile);
            if (nameToTimestamps.containsKey(name)) continue;
            Document document = entry.getValue();
            long processedStamp = processedOpenedFile.getModificationStamp();
            if (processedStamp < (processedDocumentModificationStamp = document.getModificationStamp())) {
                processedStamp = processedDocumentModificationStamp;
            }
            nameToContent.put(name, document);
            nameToTimestamps.put(name, processedStamp);
        }
    }

    private static void fillByUnsavedDocuments(@NotNull Project project, @NotNull Map<String, Document> nameToContent, @NotNull Map<String, Long> nameToTimestamps, @NotNull Condition<VirtualFile> filter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByUnsavedDocuments"));
        }
        if (nameToContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToContent", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByUnsavedDocuments"));
        }
        if (nameToTimestamps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameToTimestamps", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByUnsavedDocuments"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "fillByUnsavedDocuments"));
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile virtualFile = manager.getFile(document);
            if (virtualFile == null || !filter.value((Object)virtualFile) || !scope.accept(virtualFile)) continue;
            String name = JSHighlightingInfoBuilder.normalizeNameAndPath(virtualFile);
            nameToContent.put(name, document);
            nameToTimestamps.put(name, document.getModificationStamp());
        }
    }

    @NotNull
    public static Pair<String, String> getModuleInfo(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "getModuleInfo"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "getModuleInfo"));
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(file);
        String contentRootPath = null;
        if (contentRoot != null) {
            contentRootPath = JSHighlightingInfoBuilder.normalizeNameAndPath(contentRoot.getCanonicalPath());
        }
        VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(file);
        String sourceRootPath = null;
        if (sourceRoot != null) {
            sourceRootPath = JSHighlightingInfoBuilder.normalizeNameAndPath(sourceRoot.getCanonicalPath());
        }
        Pair pair = Pair.create((Object)contentRootPath, sourceRootPath);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "getModuleInfo"));
        }
        return pair;
    }

    @NotNull
    public static String toPath(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "toPath"));
        }
        String canonicalPath = configFile.getCanonicalPath();
        assert (canonicalPath != null);
        String string = FileUtil.toSystemDependentName((String)canonicalPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "toPath"));
        }
        return string;
    }

    @Contract(value="!null -> !null")
    public static String normalizeNameAndPath(@Nullable String path) {
        if (null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "normalizeNameAndPath"));
        }
        String path = name.getCanonicalPath();
        if (!name.isInLocalFileSystem() || null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @NotNull
    public static Map<VirtualFile, Document> getOpenedFiles(@NotNull Project project, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "getOpenedFiles"));
        }
        if (filesFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesFilter", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "getOpenedFiles"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap filesToOpen = ContainerUtil.newHashMap();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject == null || editorProject != project || !(editor instanceof EditorEx) || editor.getProject() != editorProject || (vFile = ((EditorEx)editor).getVirtualFile()) == null || !filesFilter.value((Object)vFile)) continue;
            filesToOpen.put(vFile, editor.getDocument());
        }
        HashMap hashMap = filesToOpen;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder", "getOpenedFiles"));
        }
        return hashMap;
    }
}

